/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.IDrillInteraction;
import api.hbm.block.IMiningDrill;
import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidStandardSender;
import com.google.common.collect.Sets;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerMiningLaser;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMiningLaser;
import com.hbm.inventory.recipes.CentrifugeRecipes;
import com.hbm.inventory.recipes.CrystallizerRecipes;
import com.hbm.inventory.recipes.ShredderRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.InventoryUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineMiningLaser
extends TileEntityMachineBase
implements IEnergyUser,
IFluidSource,
IMiningDrill,
IFluidStandardSender,
IGUIProvider {
    public long power;
    public int age = 0;
    public static final long maxPower = 100000000L;
    public static final int consumption = 10000;
    public FluidTank tank;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();
    public boolean isOn;
    public int targetX;
    public int targetY;
    public int targetZ;
    public int lastTargetX;
    public int lastTargetY;
    public int lastTargetZ;
    public boolean beam;
    boolean lock = false;
    double breakProgress;
    private static final Set<Item> bad = Sets.newHashSet((Object[])new Item[]{Item.func_150898_a((Block)Blocks.field_150346_d), Item.func_150898_a((Block)Blocks.field_150348_b), Item.func_150898_a((Block)Blocks.field_150347_e), Item.func_150898_a((Block)Blocks.field_150354_m), Item.func_150898_a((Block)Blocks.field_150322_A), Item.func_150898_a((Block)Blocks.field_150351_n), Item.func_150898_a((Block)ModBlocks.basalt), Item.func_150898_a((Block)ModBlocks.stone_gneiss), Items.field_151145_ak, Items.field_151126_ay, Items.field_151014_N});

    public TileEntityMachineMiningLaser() {
        super(30);
        this.tank = new FluidTank(Fluids.OIL, 64000, 0);
    }

    @Override
    public String getName() {
        return "container.miningLaser";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tank.getTankType());
            }
            this.sendFluid(this.tank, this.field_145850_b, this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X);
            this.sendFluid(this.tank, this.field_145850_b, this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X);
            this.sendFluid(this.tank, this.field_145850_b, this.field_145851_c, this.field_145848_d + 2, this.field_145849_e, Library.POS_Z);
            this.sendFluid(this.tank, this.field_145850_b, this.field_145851_c, this.field_145848_d - 2, this.field_145849_e, Library.NEG_Z);
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000000L);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            if (this.lastTargetX != this.targetX || this.lastTargetY != this.targetY || this.lastTargetZ != this.targetZ) {
                this.breakProgress = 0.0;
            }
            this.lastTargetX = this.targetX;
            this.lastTargetY = this.targetY;
            this.lastTargetZ = this.targetZ;
            double clientBreakProgress = 0.0;
            if (this.isOn) {
                UpgradeManager.eval(this.slots, 1, 8);
                int cycles = 1 + UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
                int speed = 1 + Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 12);
                int range = 1 + Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.EFFECT) * 2, 24);
                int fortune = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.FORTUNE), 3);
                int consumption = 10000 - 10000 * Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 12) / 16 + 10000 * Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 12) / 16;
                for (int i = 0; i < cycles; ++i) {
                    if (this.power < (long)consumption) {
                        this.beam = false;
                        break;
                    }
                    this.power -= (long)consumption;
                    if (this.targetY <= 0) {
                        this.targetY = this.field_145848_d - 2;
                    }
                    this.scan(range);
                    Block block = this.field_145850_b.func_147439_a(this.targetX, this.targetY, this.targetZ);
                    if (block.func_149688_o().func_76224_d()) {
                        this.field_145850_b.func_147468_f(this.targetX, this.targetY, this.targetZ);
                        this.buildDam();
                        continue;
                    }
                    if (!this.beam || !this.canBreak(block, this.targetX, this.targetY, this.targetZ)) continue;
                    this.breakProgress += this.getBreakSpeed(speed);
                    clientBreakProgress = Math.min(this.breakProgress, 1.0);
                    if (this.breakProgress < 1.0) {
                        this.field_145850_b.func_147443_d(-1, this.targetX, this.targetY, this.targetZ, (int)Math.floor(this.breakProgress * 10.0));
                        continue;
                    }
                    this.breakBlock(fortune);
                    this.buildDam();
                }
            } else {
                this.targetY = this.field_145848_d - 2;
                this.beam = false;
            }
            this.tryFillContainer(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e);
            this.tryFillContainer(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e);
            this.tryFillContainer(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2);
            this.tryFillContainer(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("lastX", this.lastTargetX);
            data.func_74768_a("lastY", this.lastTargetY);
            data.func_74768_a("lastZ", this.lastTargetZ);
            data.func_74768_a("x", this.targetX);
            data.func_74768_a("y", this.targetY);
            data.func_74768_a("z", this.targetZ);
            data.func_74757_a("beam", this.beam);
            data.func_74757_a("isOn", this.isOn);
            data.func_74780_a("progress", clientBreakProgress);
            this.networkPack(data, 250);
        }
    }

    private void updateConnections() {
        this.trySubscribe(this.field_145850_b, this.field_145851_c, this.field_145848_d + 2, this.field_145849_e, ForgeDirection.UP);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.lastTargetX = data.func_74762_e("lastX");
        this.lastTargetY = data.func_74762_e("lastY");
        this.lastTargetZ = data.func_74762_e("lastZ");
        this.targetX = data.func_74762_e("x");
        this.targetY = data.func_74762_e("y");
        this.targetZ = data.func_74762_e("z");
        this.beam = data.func_74767_n("beam");
        this.isOn = data.func_74767_n("isOn");
        this.breakProgress = data.func_74769_h("progress");
    }

    private void buildDam() {
        if (this.field_145850_b.func_147439_a(this.targetX + 1, this.targetY, this.targetZ).func_149688_o().func_76224_d()) {
            this.field_145850_b.func_147449_b(this.targetX + 1, this.targetY, this.targetZ, ModBlocks.barricade);
        }
        if (this.field_145850_b.func_147439_a(this.targetX - 1, this.targetY, this.targetZ).func_149688_o().func_76224_d()) {
            this.field_145850_b.func_147449_b(this.targetX - 1, this.targetY, this.targetZ, ModBlocks.barricade);
        }
        if (this.field_145850_b.func_147439_a(this.targetX, this.targetY, this.targetZ + 1).func_149688_o().func_76224_d()) {
            this.field_145850_b.func_147449_b(this.targetX, this.targetY, this.targetZ + 1, ModBlocks.barricade);
        }
        if (this.field_145850_b.func_147439_a(this.targetX, this.targetY, this.targetZ - 1).func_149688_o().func_76224_d()) {
            this.field_145850_b.func_147449_b(this.targetX, this.targetY, this.targetZ - 1, ModBlocks.barricade);
        }
    }

    private void tryFillContainer(int x, int y, int z) {
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        if (b != Blocks.field_150486_ae && b != Blocks.field_150447_bR && b != ModBlocks.crate_iron && b != ModBlocks.crate_desh && b != ModBlocks.crate_steel && b != ModBlocks.safe && b != Blocks.field_150438_bZ) {
            return;
        }
        IInventory inventory = (IInventory)this.field_145850_b.func_147438_o(x, y, z);
        if (inventory == null) {
            return;
        }
        for (int i = 9; i <= 29; ++i) {
            if (this.slots[i] == null) continue;
            int prev = this.slots[i].field_77994_a;
            this.slots[i] = InventoryUtil.tryAddItemToInventory(inventory, 0, inventory.func_70302_i_() - 1, this.slots[i]);
            if (this.slots[i] != null && this.slots[i].field_77994_a >= prev) continue;
            return;
        }
    }

    private void breakBlock(int fortune) {
        ItemStack stack;
        Block b = this.field_145850_b.func_147439_a(this.targetX, this.targetY, this.targetZ);
        int meta = this.field_145850_b.func_72805_g(this.targetX, this.targetY, this.targetZ);
        boolean normal = true;
        boolean doesBreak = true;
        if (b == Blocks.field_150439_ay) {
            b = Blocks.field_150450_ax;
        }
        if ((stack = new ItemStack(b, 1, meta)) != null && stack.func_77973_b() != null) {
            Object result;
            if (this.hasCrystallizer()) {
                result = CrystallizerRecipes.getOutput(stack, Fluids.ACID);
                if (result == null) {
                    result = CrystallizerRecipes.getOutput(stack, Fluids.SULFURIC_ACID);
                }
                if (result != null) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, result.output.func_77946_l()));
                    normal = false;
                }
            } else if (this.hasCentrifuge()) {
                result = CentrifugeRecipes.getOutput(stack);
                if (result != null) {
                    for (ItemStack sta : result) {
                        if (sta == null) continue;
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, sta.func_77946_l()));
                        normal = false;
                    }
                }
            } else if (this.hasShredder()) {
                result = ShredderRecipes.getShredderResult(stack);
                if (result != null && result.func_77973_b() != ModItems.scrap) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, result.func_77946_l()));
                    normal = false;
                }
            } else if (this.hasSmelter() && (result = FurnaceRecipes.func_77602_a().func_151395_a(stack)) != null) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, result.func_77946_l()));
                normal = false;
            }
        }
        if (normal && b instanceof IDrillInteraction) {
            IDrillInteraction in = (IDrillInteraction)b;
            ItemStack drop = in.extractResource(this.field_145850_b, this.targetX, this.targetY, this.targetZ, meta, this);
            if (drop != null) {
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, drop.func_77946_l()));
            }
            doesBreak = in.canBreak(this.field_145850_b, this.targetX, this.targetY, this.targetZ, meta, this);
        }
        if (doesBreak) {
            if (normal) {
                b.func_149697_b(this.field_145850_b, this.targetX, this.targetY, this.targetZ, meta, fortune);
            }
            this.field_145850_b.func_147480_a(this.targetX, this.targetY, this.targetZ, false);
        }
        this.suckDrops();
        if (this.doesScream()) {
            this.field_145850_b.func_72908_a((double)this.targetX + 0.5, (double)this.targetY + 0.5, (double)this.targetZ + 0.5, "hbm:block.screm", 2000.0f, 1.0f);
        }
        this.breakProgress = 0.0;
    }

    private void suckDrops() {
        int rangeHor = 3;
        boolean rangeVer = true;
        boolean nullifier = this.hasNullifier();
        List items = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)((double)this.targetX + 0.5 - (double)rangeHor), (double)((double)this.targetY + 0.5 - (double)rangeVer), (double)((double)this.targetZ + 0.5 - (double)rangeHor), (double)((double)this.targetX + 0.5 + (double)rangeHor), (double)((double)this.targetY + 0.5 + (double)rangeVer), (double)((double)this.targetZ + 0.5 + (double)rangeHor)));
        for (EntityItem item : items) {
            if (item.field_70128_L) continue;
            if (nullifier && bad.contains(item.func_92059_d().func_77973_b())) {
                item.func_70106_y();
                continue;
            }
            if (item.func_92059_d().func_77973_b() == Item.func_150898_a((Block)ModBlocks.ore_oil)) {
                this.tank.setTankType(Fluids.OIL);
                this.tank.setFill(this.tank.getFill() + 500);
                if (this.tank.getFill() > this.tank.getMaxFill()) {
                    this.tank.setFill(this.tank.getMaxFill());
                }
                item.func_70106_y();
                continue;
            }
            ItemStack stack = InventoryUtil.tryAddItemToInventory(this.slots, 9, 29, item.func_92059_d().func_77946_l());
            if (stack == null) {
                item.func_70106_y();
                continue;
            }
            item.func_92058_a(stack.func_77946_l());
        }
        List mobs = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((double)this.targetX + 0.5 - 1.0), (double)((double)this.targetY + 0.5 - 1.0), (double)((double)this.targetZ + 0.5 - 1.0), (double)((double)this.targetX + 0.5 + 1.0), (double)((double)this.targetY + 0.5 + 1.0), (double)((double)this.targetZ + 0.5 + 1.0)));
        for (EntityLivingBase mob : mobs) {
            mob.func_70015_d(5);
        }
    }

    public double getBreakSpeed(int speed) {
        float hardness = this.field_145850_b.func_147439_a(this.targetX, this.targetY, this.targetZ).func_149712_f(this.field_145850_b, this.targetX, this.targetY, this.targetZ) * 15.0f / (float)speed;
        if (hardness == 0.0f) {
            return 1.0;
        }
        return 1.0f / hardness;
    }

    public void scan(int range) {
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (this.field_145850_b.func_147439_a(x + this.field_145851_c, this.targetY, z + this.field_145849_e).func_149688_o().func_76224_d() || !this.canBreak(this.field_145850_b.func_147439_a(x + this.field_145851_c, this.targetY, z + this.field_145849_e), x + this.field_145851_c, this.targetY, z + this.field_145849_e)) continue;
                this.targetX = x + this.field_145851_c;
                this.targetZ = z + this.field_145849_e;
                this.beam = true;
                return;
            }
        }
        this.beam = false;
        --this.targetY;
    }

    private boolean canBreak(Block block, int x, int y, int z) {
        return !block.isAir((IBlockAccess)this.field_145850_b, x, y, z) && block.func_149712_f(this.field_145850_b, x, y, z) >= 0.0f && !block.func_149688_o().func_76224_d() && block != Blocks.field_150357_h;
    }

    public int getRange() {
        int range = 1;
        for (int i = 1; i < 9; ++i) {
            if (this.slots[i] == null) continue;
            if (this.slots[i].func_77973_b() == ModItems.upgrade_effect_1) {
                range += 2;
                continue;
            }
            if (this.slots[i].func_77973_b() == ModItems.upgrade_effect_2) {
                range += 4;
                continue;
            }
            if (this.slots[i].func_77973_b() != ModItems.upgrade_effect_3) continue;
            range += 6;
        }
        return Math.min(range, 25);
    }

    public boolean hasNullifier() {
        for (int i = 1; i < 9; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_nullifier) continue;
            return true;
        }
        return false;
    }

    public boolean hasSmelter() {
        for (int i = 1; i < 9; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_smelter) continue;
            return true;
        }
        return false;
    }

    public boolean hasShredder() {
        for (int i = 1; i < 9; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_shredder) continue;
            return true;
        }
        return false;
    }

    public boolean hasCentrifuge() {
        for (int i = 1; i < 9; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_centrifuge) continue;
            return true;
        }
        return false;
    }

    public boolean hasCrystallizer() {
        for (int i = 1; i < 9; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_crystallizer) continue;
            return true;
        }
        return false;
    }

    public boolean doesScream() {
        for (int i = 1; i < 9; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_screm) continue;
            return true;
        }
        return false;
    }

    public int getConsumption() {
        return 10000;
    }

    public int getWidth() {
        return 1 + this.getRange() * 2;
    }

    public int getPowerScaled(int i) {
        return (int)(this.power * (long)i / 100000000L);
    }

    public int getProgressScaled(int i) {
        return (int)(this.breakProgress * (double)i);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i >= 9 && i <= 29;
    }

    @Override
    public int[] func_94128_d(int slot) {
        int[] slots = new int[21];
        for (int i = 0; i < 21; ++i) {
            slots[i] = i + 9;
        }
        return slots;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && i >= 1 && i <= 8 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setFluidFill(int fill, FluidType type) {
        if (type == Fluids.OIL) {
            this.tank.setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getFluidFill(FluidType type) {
        if (type == Fluids.OIL) {
            return this.tank.getFill();
        }
        return 0;
    }

    @Override
    public void fillFluidInit(FluidType type) {
        this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidType type) {
        this.list.clear();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "oil");
        this.isOn = nbt.func_74767_n("isOn");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "oil");
        nbt.func_74757_a("isOn", this.isOn);
    }

    @Override
    public IMiningDrill.DrillType getDrillTier() {
        return IMiningDrill.DrillType.HITECH;
    }

    @Override
    public int getDrillRating() {
        return 100;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMiningLaser(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMiningLaser(player.field_71071_by, this);
    }
}

