/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.container.ContainerMachineLargeTurbine;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.inventory.gui.GUIMachineLargeTurbine;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineLargeTurbine
extends TileEntityMachineBase
implements IFluidContainer,
IFluidAcceptor,
IFluidSource,
IEnergyGenerator,
IFluidStandardTransceiver,
IGUIProvider {
    public long power;
    public static final long maxPower = 100000000L;
    public int age = 0;
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks = new FluidTank[2];
    private boolean shouldTurn;
    public float rotor;
    public float lastRotor;
    public float fanAcceleration = 0.0f;

    public TileEntityMachineLargeTurbine() {
        super(7);
        this.tanks[0] = new FluidTank(Fluids.STEAM, 512000, 0);
        this.tanks[1] = new FluidTank(Fluids.SPENTSTEAM, 10240000, 1);
    }

    @Override
    public String getName() {
        return "container.machineLargeTurbine";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            FT_Coolable trait;
            double eff;
            ++this.age;
            if (this.age >= 2) {
                this.age = 0;
            }
            this.fillFluidInit(this.tanks[1].getTankType());
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            this.sendPower(this.field_145850_b, this.field_145851_c + dir.offsetX * -4, this.field_145848_d, this.field_145849_e + dir.offsetZ * -4, dir.getOpposite());
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            for (DirPos pos : this.getConPos()) {
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.tanks[0].setType(0, 1, this.slots);
            this.tanks[0].loadTank(2, 3, this.slots);
            this.power = Library.chargeItemsFromTE(this.slots, 4, this.power, 100000000L);
            boolean operational = false;
            FluidType in = this.tanks[0].getTankType();
            boolean valid = false;
            if (in.hasTrait(FT_Coolable.class) && (eff = (trait = in.getTrait(FT_Coolable.class)).getEfficiency(FT_Coolable.CoolingType.TURBINE)) > 0.0) {
                this.tanks[1].setTankType(trait.coolsTo);
                int inputOps = (int)Math.floor(this.tanks[0].getFill() / trait.amountReq);
                int outputOps = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / trait.amountProduced;
                int cap = (int)Math.ceil((float)(this.tanks[0].getFill() / trait.amountReq) / 5.0f);
                int ops = Math.min(inputOps, Math.min(outputOps, cap));
                this.tanks[0].setFill(this.tanks[0].getFill() - ops * trait.amountReq);
                this.tanks[1].setFill(this.tanks[1].getFill() + ops * trait.amountProduced);
                this.power = (long)((double)this.power + (double)(ops * trait.heatEnergy) * eff);
                valid = true;
                boolean bl = operational = ops > 0;
            }
            if (!valid) {
                this.tanks[1].setTankType(Fluids.NONE);
            }
            if (this.power > 100000000L) {
                this.power = 100000000L;
            }
            this.tanks[1].unloadTank(5, 6, this.slots);
            for (int i = 0; i < 2; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74757_a("operational", operational);
            this.networkPack(data, 50);
        } else {
            this.lastRotor = this.rotor;
            this.rotor += this.fanAcceleration;
            if (this.rotor >= 360.0f) {
                this.rotor -= 360.0f;
                this.lastRotor -= 360.0f;
            }
            if (this.shouldTurn) {
                this.fanAcceleration = Math.max(0.0f, Math.min(15.0f, this.fanAcceleration += 0.1f));
            }
            if (!this.shouldTurn) {
                this.fanAcceleration = Math.max(0.0f, Math.min(15.0f, this.fanAcceleration -= 0.1f));
            }
        }
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2, dir)};
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.shouldTurn = data.func_74767_n("operational");
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 100000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.power = nbt.func_74763_f("power");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        nbt.func_74772_a("power", this.power);
    }

    @Override
    public void fillFluidInit(FluidType type) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        dir = dir.getRotation(ForgeDirection.UP);
        this.fillFluid(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c + dir.offsetX * -2, this.field_145848_d, this.field_145849_e + dir.offsetZ * -2, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age == 0;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        return this.list2;
    }

    @Override
    public void clearFluidList(FluidType type) {
        this.list2.clear();
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineLargeTurbine(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineLargeTurbine(player.field_71071_by, this);
    }
}

