/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardReceiver;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.config.GeneralConfig;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.inventory.container.ContainerIGenerator;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.gui.GUIIGenerator;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.RTGUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineIGenerator
extends TileEntityMachineBase
implements IFluidAcceptor,
IEnergyGenerator,
IFluidStandardReceiver,
IConfigurableMachine,
IGUIProvider {
    public long power;
    public int spin;
    public int[] burn = new int[4];
    public boolean hasRTG = false;
    public int[] RTGSlots = new int[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    @SideOnly(value=Side.CLIENT)
    public float rotation;
    @SideOnly(value=Side.CLIENT)
    public float prevRotation;
    public FluidTank[] tanks = new FluidTank[3];
    public int age = 0;
    public static final int coalConRate = 75;
    public static long maxPower = 1000000L;
    public static int waterCap = 16000;
    public static int oilCap = 16000;
    public static int lubeCap = 4000;
    public static int coalGenRate = 20;
    public static double rtgHeatMult = 0.15;
    public static double waterPowerMult = 1.0;
    public static double lubePowerMult = 1.5;
    public static double heatExponent = 1.15;
    public static int waterRate = 10;
    public static int lubeRate = 1;
    public static long fluidHeatDiv = 1000L;

    @Override
    public String getConfigName() {
        return "igen";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "L:powerCap", maxPower);
        waterCap = IConfigurableMachine.grab(obj, "I:waterCap", waterCap);
        oilCap = IConfigurableMachine.grab(obj, "I:oilCap", oilCap);
        lubeCap = IConfigurableMachine.grab(obj, "I:lubeCap", lubeCap);
        coalGenRate = IConfigurableMachine.grab(obj, "I:solidFuelRate", coalGenRate);
        rtgHeatMult = IConfigurableMachine.grab(obj, "D:rtgHeatMult", rtgHeatMult);
        waterPowerMult = IConfigurableMachine.grab(obj, "D:waterPowerMult", waterPowerMult);
        lubePowerMult = IConfigurableMachine.grab(obj, "D:lubePowerMult", lubePowerMult);
        heatExponent = IConfigurableMachine.grab(obj, "D:heatExponent", heatExponent);
        waterRate = IConfigurableMachine.grab(obj, "I:waterRate", waterRate);
        lubeRate = IConfigurableMachine.grab(obj, "I:lubeRate", lubeRate);
        fluidHeatDiv = IConfigurableMachine.grab(obj, "D:fluidHeatDiv", fluidHeatDiv);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:powerCap").value(maxPower);
        writer.name("I:waterCap").value((long)waterCap);
        writer.name("I:oilCap").value((long)oilCap);
        writer.name("I:lubeCap").value((long)lubeCap);
        writer.name("I:solidFuelRate").value((long)coalGenRate);
        writer.name("D:rtgHeatMult").value(rtgHeatMult);
        writer.name("D:waterPowerMult").value(waterPowerMult);
        writer.name("D:lubePowerMult").value(lubePowerMult);
        writer.name("D:heatExponent").value(heatExponent);
        writer.name("I:waterRate").value((long)waterRate);
        writer.name("I:lubeRate").value((long)lubeRate);
        writer.name("D:fluidHeatDiv").value(fluidHeatDiv);
    }

    public TileEntityMachineIGenerator() {
        super(21);
        this.tanks[0] = new FluidTank(Fluids.WATER, waterCap, 0);
        this.tanks[1] = new FluidTank(Fluids.HEATINGOIL, oilCap, 1);
        this.tanks[2] = new FluidTank(Fluids.LUBRICANT, lubeCap, 2);
    }

    @Override
    public String getName() {
        return "container.iGenerator";
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * -4, this.field_145848_d, this.field_145849_e + dir.offsetZ * -4, dir.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3, dir)};
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int pow;
            boolean con = GeneralConfig.enableLBSM && GeneralConfig.enableLBSMIGen;
            this.power = Library.chargeItemsFromTE(this.slots, 0, this.power, maxPower);
            for (DirPos dir : this.getConPos()) {
                this.sendPower(this.field_145850_b, dir.getX(), dir.getY(), dir.getZ(), dir.getDir());
                for (FluidTank tank : this.tanks) {
                    this.trySubscribe(tank.getTankType(), this.field_145850_b, dir.getX(), dir.getY(), dir.getZ(), dir.getDir());
                }
            }
            this.tanks[1].setType(9, 10, this.slots);
            this.tanks[0].loadTank(1, 2, this.slots);
            this.tanks[1].loadTank(9, 10, this.slots);
            this.tanks[2].loadTank(7, 8, this.slots);
            this.spin = 0;
            if (this.tanks[1].getFill() > 0 && (pow = this.getPowerFromFuel(con)) > 0) {
                this.tanks[1].setFill(this.tanks[1].getFill() - 1);
                this.spin += pow;
            }
            for (int i = 0; i < 4; ++i) {
                ItemStack fuel;
                int burnTime;
                if (this.burn[i] > 0) {
                    int n = i;
                    this.burn[n] = this.burn[n] - 1;
                    this.spin += con ? 75 : coalGenRate;
                    continue;
                }
                int slot = i + 3;
                if (this.slots[slot] == null || (burnTime = TileEntityFurnace.func_145952_a((ItemStack)(fuel = this.slots[slot])) / 2) <= 0) continue;
                if (fuel.func_77973_b() == Items.field_151044_h) {
                    burnTime = (int)((double)burnTime * (con ? 1.5 : 1.1));
                }
                if (fuel.func_77973_b() == ModItems.solid_fuel) {
                    burnTime = (int)((double)burnTime * (con ? 2.0 : 1.1));
                }
                if (fuel.func_77973_b() == ModItems.solid_fuel_presto) {
                    burnTime = (int)((double)burnTime * (con ? 4.0 : 1.1));
                }
                if (fuel.func_77973_b() == ModItems.solid_fuel_presto_triplet) {
                    burnTime = (int)((double)burnTime * (con ? 4.0 : 1.1));
                }
                this.burn[i] = burnTime;
                --this.slots[slot].field_77994_a;
                if (this.slots[slot].field_77994_a > 0) continue;
                this.slots[slot] = this.slots[slot].func_77973_b().hasContainerItem(this.slots[slot]) ? this.slots[slot].func_77973_b().getContainerItem(this.slots[slot]) : null;
            }
            this.hasRTG = RTGUtil.hasHeat(this.slots, this.RTGSlots);
            this.spin = (int)((double)this.spin + (double)RTGUtil.updateRTGs(this.slots, this.RTGSlots) * (con ? 0.2 : rtgHeatMult));
            if (this.spin > 0) {
                int powerGen = this.spin;
                if (this.tanks[0].getFill() >= 10) {
                    powerGen = (int)((double)powerGen + (double)this.spin * waterPowerMult);
                    this.tanks[0].setFill(this.tanks[0].getFill() - waterRate);
                }
                if (this.tanks[2].getFill() >= 1) {
                    powerGen = (int)((double)powerGen + (double)this.spin * lubePowerMult);
                    this.tanks[2].setFill(this.tanks[2].getFill() - lubeRate);
                }
                this.power = (long)((double)this.power + Math.pow(powerGen, heatExponent));
                if (this.power > maxPower) {
                    this.power = maxPower;
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("spin", this.spin);
            data.func_74783_a("burn", this.burn);
            data.func_74757_a("hasRTG", this.hasRTG);
            this.networkPack(data, 150);
            for (int i = 0; i < 3; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
        } else {
            this.prevRotation = this.rotation;
            if (this.spin > 0) {
                this.rotation += 15.0f;
            }
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i >= 3 && i <= 6 && TileEntityFurnace.func_145952_a((ItemStack)itemStack) > 0;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{3, 4, 5, 6};
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.spin = nbt.func_74762_e("spin");
        this.burn = nbt.func_74759_k("burn");
        this.hasRTG = nbt.func_74767_n("hasRTG");
    }

    public int getPowerFromFuel(boolean con) {
        FluidType type = this.tanks[1].getTankType();
        return type.hasTrait(FT_Flammable.class) ? (int)(type.getTrait(FT_Flammable.class).getHeatEnergy() / (con ? 5000L : fluidHeatDiv)) : 0;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tanks[index].setFill(fill);
    }

    @Override
    public void setFluidFill(int fill, FluidType type) {
        if (type == Fluids.WATER) {
            this.tanks[0].setFill(fill);
        } else if (type == Fluids.LUBRICANT) {
            this.tanks[2].setFill(fill);
        } else if (this.tanks[1].getTankType() == type) {
            this.tanks[1].setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tanks[index].setTankType(type);
    }

    @Override
    public int getFluidFill(FluidType type) {
        for (int i = 0; i < 3; ++i) {
            if (this.tanks[i].getTankType() != type) continue;
            return this.tanks[i].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        for (int i = 0; i < 3; ++i) {
            if (this.tanks[i].getTankType() != type) continue;
            return this.tanks[i].getMaxFill();
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].readFromNBT(nbt, "tank_" + i);
        }
        this.power = nbt.func_74763_f("power");
        this.burn = nbt.func_74759_k("burn");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].writeToNBT(nbt, "tank_" + i);
        }
        nbt.func_74772_a("power", this.power);
        nbt.func_74783_a("burn", this.burn);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerIGenerator(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIIGenerator(player.field_71071_by, this);
    }
}

