/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Heatable;
import com.hbm.lib.Library;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineHephaestus
extends TileEntityLoadedBase
implements INBTPacketReceiver,
IFluidStandardTransceiver {
    public FluidTank input;
    public FluidTank output;
    public int bufferedHeat;
    public float rot;
    public float prevRot;
    private int[] heat = new int[10];
    private long fissureScanTime;
    AxisAlignedBB bb = null;

    public TileEntityMachineHephaestus() {
        this.input = new FluidTank(Fluids.OIL, 24000);
        this.output = new FluidTank(Fluids.HOTOIL, 24000);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.setupTanks();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            int height = (int)(this.field_145850_b.func_82737_E() % 10L);
            int range = 7;
            int y = this.field_145848_d - 1 - height;
            this.heat[height] = 0;
            if (y >= 0) {
                for (int x = -range; x <= range; ++x) {
                    for (int z = -range; z <= range; ++z) {
                        int n = height;
                        this.heat[n] = this.heat[n] + this.heatFromBlock(this.field_145851_c + x, y, this.field_145849_e + z);
                    }
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            this.input.writeToNBT(data, "i");
            this.heatFluid();
            this.output.writeToNBT(data, "o");
            if (this.output.getFill() > 0) {
                for (DirPos pos : this.getConPos()) {
                    this.sendFluid(this.output, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            data.func_74768_a("heat", this.getTotalHeat());
            INBTPacketReceiver.networkPack(this, data, 150);
        } else {
            this.prevRot = this.rot;
            if (this.bufferedHeat > 0) {
                this.rot += 0.5f;
                if (this.field_145850_b.field_73012_v.nextInt(7) == 0) {
                    double x = this.field_145850_b.field_73012_v.nextGaussian() * 2.0;
                    double y = this.field_145850_b.field_73012_v.nextGaussian() * 3.0;
                    double z = this.field_145850_b.field_73012_v.nextGaussian() * 2.0;
                    this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 + x, (double)(this.field_145848_d + 6) + y, (double)this.field_145849_e + 0.5 + z, 0.0, 0.0, 0.0);
                }
            }
            if (this.rot >= 360.0f) {
                this.prevRot -= 360.0f;
                this.rot -= 360.0f;
            }
        }
    }

    protected void heatFluid() {
        FluidType type = this.input.getTankType();
        if (type.hasTrait(FT_Heatable.class)) {
            FT_Heatable trait = type.getTrait(FT_Heatable.class);
            int heat = this.getTotalHeat();
            FT_Heatable.HeatingStep step = trait.getFirstStep();
            int inputOps = this.input.getFill() / step.amountReq;
            int outputOps = (this.output.getMaxFill() - this.output.getFill()) / step.amountProduced;
            int heatOps = heat / step.heatReq;
            int ops = Math.min(Math.min(inputOps, outputOps), heatOps);
            this.input.setFill(this.input.getFill() - step.amountReq * ops);
            this.output.setFill(this.output.getFill() + step.amountProduced * ops);
            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        }
    }

    protected void setupTanks() {
        FT_Heatable trait;
        FluidType type = this.input.getTankType();
        if (type.hasTrait(FT_Heatable.class) && (trait = type.getTrait(FT_Heatable.class)).getEfficiency(FT_Heatable.HeatingType.HEATEXCHANGER) > 0.0) {
            FluidType outType = trait.getFirstStep().typeProduced;
            this.output.setTankType(outType);
            return;
        }
        this.input.setTankType(Fluids.NONE);
        this.output.setTankType(Fluids.NONE);
    }

    protected int heatFromBlock(int x, int y, int z) {
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        if (b == Blocks.field_150353_l || b == Blocks.field_150356_k) {
            return 5;
        }
        if (b == ModBlocks.volcanic_lava_block) {
            return 150;
        }
        if (b == ModBlocks.ore_volcano) {
            this.fissureScanTime = this.field_145850_b.func_82737_E();
            return 300;
        }
        return 0;
    }

    public int getTotalHeat() {
        boolean fissure = this.field_145850_b.func_82737_E() - this.fissureScanTime < 20L;
        int heat = 0;
        for (int h : this.heat) {
            heat += h;
        }
        if (fissure) {
            heat *= 3;
        }
        return heat;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.input.readFromNBT(nbt, "i");
        this.output.readFromNBT(nbt, "o");
        this.bufferedHeat = nbt.func_74762_e("heat");
    }

    private void updateConnections() {
        if (this.input.getTankType() == Fluids.NONE) {
            return;
        }
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.input.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c + 2, this.field_145848_d + 11, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d + 11, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d + 11, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d + 11, this.field_145849_e - 2, Library.NEG_Z)};
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.input.readFromNBT(nbt, "0");
        this.output.readFromNBT(nbt, "1");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.input.writeToNBT(nbt, "0");
        this.output.writeToNBT(nbt, "1");
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.input, this.output};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.output};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.input};
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.UP && dir != ForgeDirection.DOWN;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 12), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

