/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.inventory.container.ContainerMachineGasCent;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineGasCent;
import com.hbm.inventory.recipes.GasCentrifugeRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.lib.Library;
import com.hbm.packet.LoopedSoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.InventoryUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineGasCent
extends TileEntityMachineBase
implements IEnergyUser,
IFluidAcceptor,
IFluidStandardReceiver,
IGUIProvider {
    public long power;
    public int progress;
    public boolean isProgressing;
    public static final int maxPower = 100000;
    public static final int processingSpeed = 150;
    public FluidTank tank = new FluidTank(Fluids.UF6, 2000, 0);
    public PseudoFluidTank inputTank = new PseudoFluidTank(GasCentrifugeRecipes.PseudoFluidType.NUF6, 8000);
    public PseudoFluidTank outputTank = new PseudoFluidTank(GasCentrifugeRecipes.PseudoFluidType.LEUF6, 8000);
    private static final int[] slots_io = new int[]{0, 1, 2, 3};
    private static HashMap<FluidType, GasCentrifugeRecipes.PseudoFluidType> fluidConversions = new HashMap();
    AxisAlignedBB bb = null;

    public TileEntityMachineGasCent() {
        super(7);
    }

    @Override
    public String getName() {
        return "container.gasCentrifuge";
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i < 4;
    }

    @Override
    public int[] func_94128_d(int side) {
        return slots_io;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74765_d("progress");
        this.tank.readFromNBT(nbt, "tank");
        this.inputTank.readFromNBT(nbt, "inputTank");
        this.outputTank.readFromNBT(nbt, "outputTank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74777_a("progress", (short)this.progress);
        this.tank.writeToNBT(nbt, "tank");
        this.inputTank.writeToNBT(nbt, "inputTank");
        this.outputTank.writeToNBT(nbt, "outputTank");
    }

    public int getCentrifugeProgressScaled(int i) {
        return this.progress * i / this.getProcessingSpeed();
    }

    public long getPowerRemainingScaled(int i) {
        return this.power * (long)i / 100000L;
    }

    private boolean canEnrich() {
        if (this.power > 0L && this.inputTank.getFill() >= this.inputTank.getTankType().getFluidConsumed() && this.outputTank.getFill() + this.inputTank.getTankType().getFluidProduced() <= this.outputTank.getMaxFill()) {
            ItemStack[] list = this.inputTank.getTankType().getOutput();
            if (this.inputTank.getTankType().getIfHighSpeed() && (this.slots[6] == null || this.slots[6].func_77973_b() != ModItems.upgrade_gc_speed)) {
                return false;
            }
            if (list == null) {
                return false;
            }
            if (list.length < 1) {
                return false;
            }
            if (InventoryUtil.doesArrayHaveSpace(this.slots, 0, 3, list)) {
                return true;
            }
        }
        return false;
    }

    private void enrich() {
        ItemStack[] output = this.inputTank.getTankType().getOutput();
        this.progress = 0;
        this.inputTank.setFill(this.inputTank.getFill() - this.inputTank.getTankType().getFluidConsumed());
        this.outputTank.setFill(this.outputTank.getFill() + this.inputTank.getTankType().getFluidProduced());
        for (int i = 0; i < output.length; i = (int)((byte)(i + 1))) {
            InventoryUtil.tryAddItemToInventory(this.slots, 0, 3, output[i].func_77946_l());
        }
    }

    private void attemptConversion() {
        if (this.inputTank.getFill() < this.inputTank.getMaxFill() && this.tank.getFill() > 0) {
            int fill = Math.min(this.inputTank.getMaxFill() - this.inputTank.getFill(), this.tank.getFill());
            this.tank.setFill(this.tank.getFill() - fill);
            this.inputTank.setFill(this.inputTank.getFill() + fill);
        }
    }

    private boolean attemptTransfer(TileEntity te) {
        if (te instanceof TileEntityMachineGasCent) {
            TileEntityMachineGasCent cent = (TileEntityMachineGasCent)te;
            if (cent.tank.getFill() == 0 && cent.tank.getTankType() == this.tank.getTankType()) {
                if (cent.inputTank.getTankType() != this.outputTank.getTankType() && this.outputTank.getTankType() != GasCentrifugeRecipes.PseudoFluidType.NONE) {
                    cent.inputTank.setTankType(this.outputTank.getTankType());
                    cent.outputTank.setTankType(this.outputTank.getTankType().getOutputType());
                }
                if (cent.inputTank.getFill() < cent.inputTank.getMaxFill() && this.outputTank.getFill() > 0) {
                    int fill = Math.min(cent.inputTank.getMaxFill() - cent.inputTank.getFill(), this.outputTank.getFill());
                    this.outputTank.setFill(this.outputTank.getFill() - fill);
                    cent.inputTank.setFill(cent.inputTank.getFill() + fill);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.progress = data.func_74762_e("progress");
        this.isProgressing = data.func_74767_n("isProgressing");
        this.inputTank.setTankType(GasCentrifugeRecipes.PseudoFluidType.valueOf(data.func_74779_i("inputType")));
        this.outputTank.setTankType(GasCentrifugeRecipes.PseudoFluidType.valueOf(data.func_74779_i("outputType")));
        this.inputTank.setFill(data.func_74762_e("inputFill"));
        this.outputTank.setFill(data.func_74762_e("outputFill"));
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.power = Library.chargeTEFromItems(this.slots, 4, this.power, 100000L);
            this.setTankType(5);
            this.tank.updateTank(this);
            if (fluidConversions.containsValue((Object)this.inputTank.getTankType())) {
                this.attemptConversion();
            }
            if (this.canEnrich()) {
                this.isProgressing = true;
                ++this.progress;
                this.power = this.slots[6] != null && this.slots[6].func_77973_b() == ModItems.upgrade_gc_speed ? (this.power -= 300L) : (this.power -= 200L);
                if (this.power < 0L) {
                    this.power = 0L;
                    this.progress = 0;
                }
                if (this.progress >= this.getProcessingSpeed()) {
                    this.enrich();
                }
            } else {
                this.isProgressing = false;
                this.progress = 0;
            }
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c - dir.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ);
                if (!this.attemptTransfer(te) && this.inputTank.getTankType() == GasCentrifugeRecipes.PseudoFluidType.LEUF6) {
                    ItemStack[] converted = new ItemStack[]{new ItemStack(ModItems.nugget_uranium_fuel, 6), new ItemStack(ModItems.fluorite)};
                    if (this.outputTank.getFill() >= 600 && InventoryUtil.doesArrayHaveSpace(this.slots, 0, 3, converted)) {
                        this.outputTank.setFill(this.outputTank.getFill() - 600);
                        for (ItemStack stack : converted) {
                            InventoryUtil.tryAddItemToInventory(this.slots, 0, 3, stack);
                        }
                    }
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74757_a("isProgressing", this.isProgressing);
            data.func_74768_a("inputFill", this.inputTank.getFill());
            data.func_74768_a("outputFill", this.outputTank.getFill());
            data.func_74778_a("inputType", this.inputTank.getTankType().toString());
            data.func_74778_a("outputType", this.outputTank.getTankType().toString());
            this.networkPack(data, 50);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new LoopedSoundPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            if (!fluidConversions.containsValue((Object)this.inputTank.getTankType())) continue;
            this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z)};
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public int getProcessingSpeed() {
        if (this.slots[6] != null && this.slots[6].func_77973_b() == ModItems.upgrade_gc_speed) {
            return 80;
        }
        return 150;
    }

    public void setTankType(int in) {
        if (this.slots[in] != null && this.slots[in].func_77973_b() instanceof IItemFluidIdentifier) {
            GasCentrifugeRecipes.PseudoFluidType pseudo;
            IItemFluidIdentifier id = (IItemFluidIdentifier)this.slots[in].func_77973_b();
            FluidType newType = id.getType(null, 0, 0, 0, this.slots[in]);
            if (this.tank.getTankType() != newType && (pseudo = fluidConversions.get(newType)) != null) {
                this.inputTank.setTankType(pseudo);
                this.outputTank.setTankType(pseudo.getOutputType());
                this.tank.setTankType(newType);
            }
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setFluidFill(int fill, FluidType type) {
        if (type == this.tank.getTankType()) {
            this.tank.setFill(fill);
        }
    }

    @Override
    public int getFluidFill(FluidType type) {
        return this.tank.getTankType() == type ? this.tank.getFill() : 0;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        return this.tank.getTankType() == type ? this.tank.getMaxFill() : 0;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 1));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineGasCent(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineGasCent(player.field_71071_by, this);
    }

    static {
        fluidConversions.put(Fluids.UF6, GasCentrifugeRecipes.PseudoFluidType.NUF6);
        fluidConversions.put(Fluids.PUF6, GasCentrifugeRecipes.PseudoFluidType.PF6);
        fluidConversions.put(Fluids.WATZ, GasCentrifugeRecipes.PseudoFluidType.MUD);
    }

    public class PseudoFluidTank {
        GasCentrifugeRecipes.PseudoFluidType type;
        int fluid;
        int maxFluid;

        public PseudoFluidTank(GasCentrifugeRecipes.PseudoFluidType type, int maxFluid) {
            this.type = type;
            this.maxFluid = maxFluid;
        }

        public void setFill(int i) {
            this.fluid = i;
        }

        public void setTankType(GasCentrifugeRecipes.PseudoFluidType type) {
            if (this.type.equals((Object)type)) {
                return;
            }
            this.type = type == null ? GasCentrifugeRecipes.PseudoFluidType.NONE : type;
            this.setFill(0);
        }

        public GasCentrifugeRecipes.PseudoFluidType getTankType() {
            return this.type;
        }

        public int getFill() {
            return this.fluid;
        }

        public int getMaxFill() {
            return this.maxFluid;
        }

        public void writeToNBT(NBTTagCompound nbt, String s) {
            nbt.func_74768_a(s, this.fluid);
            nbt.func_74768_a(s + "_max", this.maxFluid);
            nbt.func_74778_a(s + "_type", this.type.toString());
        }

        public void readFromNBT(NBTTagCompound nbt, String s) {
            this.fluid = nbt.func_74762_e(s);
            int max = nbt.func_74762_e(s + "_max");
            if (max > 0) {
                this.maxFluid = nbt.func_74762_e(s + "_max");
            }
            this.type = GasCentrifugeRecipes.PseudoFluidType.valueOf(nbt.func_74779_i(s + "_type"));
        }
    }
}

