/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.container.ContainerMachineDiesel;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.inventory.gui.GUIMachineDiesel;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineDiesel
extends TileEntityMachinePolluting
implements IEnergyGenerator,
IFluidContainer,
IFluidAcceptor,
IFluidStandardTransceiver,
IConfigurableMachine,
IGUIProvider {
    public long power;
    public int soundCycle = 0;
    public long powerCap = maxPower;
    public FluidTank tank = new FluidTank(Fluids.DIESEL, 4000, 0);
    public static long maxPower = 50000L;
    public static int fluidCap = 16000;
    public static HashMap<FT_Combustible.FuelGrade, Double> fuelEfficiency = new HashMap();
    public static boolean shutUp;
    private static final int[] slots_top;
    private static final int[] slots_bottom;
    private static final int[] slots_side;

    public TileEntityMachineDiesel() {
        super(5, 100);
    }

    @Override
    public String getName() {
        return "container.machineDiesel";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0 && FluidContainerRegistry.getFluidContent(stack, this.tank.getTankType()) > 0) {
            return true;
        }
        return i == 2 && stack.func_77973_b() instanceof IBatteryItem;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("powerTime");
        this.powerCap = nbt.func_74763_f("powerCap");
        this.tank.readFromNBT(nbt, "fuel");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74772_a("powerCap", this.powerCap);
        this.tank.writeToNBT(nbt, "fuel");
    }

    @Override
    public int[] func_94128_d(int side) {
        return side == 0 ? slots_bottom : (side == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        if (i == 1 && (stack.func_77973_b() == ModItems.canister_empty || stack.func_77973_b() == ModItems.tank_steel)) {
            return true;
        }
        return i == 2 && stack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)stack.func_77973_b()).getCharge(stack) == ((IBatteryItem)stack.func_77973_b()).getMaxCharge();
    }

    public long getPowerScaled(long i) {
        return this.power * i / this.powerCap;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.sendPower(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
                this.sendSmoke(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            FluidType last = this.tank.getTankType();
            if (this.tank.setType(3, 4, this.slots)) {
                this.unsubscribeToAllAround(last, this);
            }
            this.tank.loadTank(0, 1, this.slots);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            this.subscribeToAllAround(this.tank.getTankType(), this);
            FluidType type = this.tank.getTankType();
            this.powerCap = type == Fluids.NITAN ? maxPower * 10L : maxPower;
            this.power = Library.chargeItemsFromTE(this.slots, 2, this.power, this.powerCap);
            this.generate();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("power", (int)this.power);
            data.func_74768_a("powerCap", (int)this.powerCap);
            this.networkPack(data, 50);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74762_e("power");
        this.powerCap = data.func_74762_e("powerCap");
    }

    public boolean hasAcceptableFuel() {
        return this.getHEFromFuel() > 0L;
    }

    public long getHEFromFuel() {
        return TileEntityMachineDiesel.getHEFromFuel(this.tank.getTankType());
    }

    public static long getHEFromFuel(FluidType type) {
        if (type.hasTrait(FT_Combustible.class)) {
            double efficiency;
            FT_Combustible fuel = type.getTrait(FT_Combustible.class);
            FT_Combustible.FuelGrade grade = fuel.getGrade();
            double d = efficiency = fuelEfficiency.containsKey((Object)grade) ? fuelEfficiency.get((Object)grade) : 0.0;
            if (fuel.getGrade() != FT_Combustible.FuelGrade.LOW) {
                return (long)((double)(fuel.getCombustionEnergy() / 1000L) * efficiency);
            }
        }
        return 0L;
    }

    public void generate() {
        if (this.hasAcceptableFuel() && this.tank.getFill() > 0) {
            if (!shutUp) {
                if (this.soundCycle == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "fireworks.blast", 0.75f * this.getVolume(3), 0.5f);
                }
                ++this.soundCycle;
            }
            if (this.soundCycle >= 3) {
                this.soundCycle = 0;
            }
            this.tank.setFill(this.tank.getFill() - 1);
            if (this.tank.getFill() < 0) {
                this.tank.setFill(0);
            }
            this.pollute(PollutionHandler.PollutionType.SOOT, 0.02f);
            if (this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Leaded.class)) {
                this.pollute(PollutionHandler.PollutionType.HEAVYMETAL, 0.01f);
            }
            this.power = this.power + this.getHEFromFuel() <= this.powerCap ? (this.power += this.getHEFromFuel()) : this.powerCap;
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        return type == this.tank.getTankType() ? this.tank.getMaxFill() : 0;
    }

    @Override
    public int getFluidFill(FluidType type) {
        return type == this.tank.getTankType() ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type == this.tank.getTankType()) {
            this.tank.setFill(i);
        }
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public String getConfigName() {
        return "dieselgen";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "L:powerCap", maxPower);
        fluidCap = IConfigurableMachine.grab(obj, "I:fuelCap", fluidCap);
        if (obj.has("D[:efficiency")) {
            JsonArray array = obj.get("D[:efficiency").getAsJsonArray();
            for (FT_Combustible.FuelGrade grade : FT_Combustible.FuelGrade.values()) {
                fuelEfficiency.put(grade, array.get(grade.ordinal()).getAsDouble());
            }
        }
        shutUp = IConfigurableMachine.grab(obj, "B:shutUp", shutUp);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:powerCap").value(maxPower);
        writer.name("I:fuelCap").value((long)fluidCap);
        String info = "Fuel grades in order: ";
        for (FT_Combustible.FuelGrade grade : FT_Combustible.FuelGrade.values()) {
            info = info + grade.name() + " ";
        }
        info = info.trim();
        writer.name("INFO").value(info);
        writer.name("D[:efficiency").beginArray().setIndent("");
        for (FT_Combustible.FuelGrade grade : FT_Combustible.FuelGrade.values()) {
            double d = fuelEfficiency.containsKey((Object)grade) ? fuelEfficiency.get((Object)grade) : 0.0;
            writer.value(d);
        }
        writer.endArray().setIndent("  ");
        writer.name("B:shutUp").value(shutUp);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineDiesel(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineDiesel(player.field_71071_by, this);
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.getSmokeTanks();
    }

    static {
        fuelEfficiency.put(FT_Combustible.FuelGrade.MEDIUM, 0.5);
        fuelEfficiency.put(FT_Combustible.FuelGrade.HIGH, 0.75);
        fuelEfficiency.put(FT_Combustible.FuelGrade.AERO, 0.1);
        shutUp = false;
        slots_top = new int[]{0};
        slots_bottom = new int[]{1, 2};
        slots_side = new int[]{2};
    }
}

