/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityBlackHole;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionThermo;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.container.ContainerMachineCyclotron;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineCyclotron;
import com.hbm.inventory.recipes.CyclotronRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityMachineCyclotron
extends TileEntityMachineBase
implements IFluidSource,
IFluidAcceptor,
IEnergyUser,
IFluidStandardTransceiver,
IGUIProvider {
    public long power;
    public static final long maxPower = 100000000L;
    public int consumption = 1000000;
    public boolean isOn;
    private int age;
    private int countdown;
    private byte plugs;
    public int progress;
    public static final int duration = 690;
    public FluidTank coolant;
    public FluidTank amat;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();

    public TileEntityMachineCyclotron() {
        super(16);
        this.coolant = new FluidTank(Fluids.COOLANT, 32000, 0);
        this.amat = new FluidTank(Fluids.AMAT, 8000, 1);
    }

    @Override
    public String getName() {
        return "container.cyclotron";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.amat.getTankType());
            }
            this.power = Library.chargeTEFromItems(this.slots, 13, this.power, 100000000L);
            this.coolant.loadTank(11, 12, this.slots);
            this.amat.unloadTank(9, 10, this.slots);
            if (this.isOn) {
                int defConsumption = this.consumption - 100000 * this.getConsumption();
                if (this.canProcess() && this.power >= (long)defConsumption) {
                    this.progress += this.getSpeed();
                    this.power -= (long)defConsumption;
                    if (this.progress >= 690) {
                        this.process();
                        this.progress = 0;
                        this.func_70296_d();
                    }
                    if (this.coolant.getFill() > 0) {
                        this.countdown = 0;
                        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                            this.coolant.setFill(this.coolant.getFill() - 1);
                        }
                    } else if (this.field_145850_b.field_73012_v.nextInt(this.getSafety()) == 0) {
                        ++this.countdown;
                        int chance = 7 - Math.min((int)Math.ceil((double)this.countdown / 200.0), 6);
                        if (this.field_145850_b.field_73012_v.nextInt(chance) == 0) {
                            ExplosionLarge.spawnTracers(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 3.25, (double)this.field_145849_e + 0.5, 1);
                        }
                        if (this.countdown > 1000) {
                            ExplosionThermo.setEntitiesOnFire(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 25);
                            ExplosionThermo.scorchLight(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 7);
                            if (this.countdown % 4 == 0) {
                                ExplosionLarge.spawnBurst(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 3.25, (double)this.field_145849_e + 0.5, 18, 1.0);
                            }
                        } else if (this.countdown > 600) {
                            ExplosionThermo.setEntitiesOnFire(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 10);
                        }
                        if (this.countdown == 1140) {
                            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, "hbm:block.shutdown", 10.0f, 1.0f);
                        }
                        if (this.countdown > 1200) {
                            this.explode();
                        }
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
            this.sendFluid();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74757_a("isOn", this.isOn);
            data.func_74774_a("plugs", this.plugs);
            this.networkPack(data, 25);
            this.coolant.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            this.amat.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.coolant.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private void sendFluid() {
        for (DirPos pos : this.getConPos()) {
            this.sendFluid(this.amat, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z)};
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.isOn = data.func_74767_n("isOn");
        this.power = data.func_74763_f("power");
        this.progress = data.func_74762_e("progress");
        this.plugs = data.func_74771_c("plugs");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        this.isOn = !this.isOn;
    }

    private void explode() {
        ExplosionLarge.explodeFire(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 25.0f, true, false, true);
        int rand = this.field_145850_b.field_73012_v.nextInt(10);
        if (rand < 2) {
            this.field_145850_b.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(this.field_145850_b, (int)((double)BombConfig.fatmanRadius * 1.5), (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5).mute());
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "muke");
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 250.0));
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:weapon.mukeExplosion", 15.0f, 1.0f);
        } else if (rand < 4) {
            EntityBalefire bf = new EntityBalefire(this.field_145850_b).mute();
            bf.field_70165_t = (double)this.field_145851_c + 0.5;
            bf.field_70163_u = (double)this.field_145848_d + 1.5;
            bf.field_70161_v = (double)this.field_145849_e + 0.5;
            bf.destructionRange = (int)((double)BombConfig.fatmanRadius * 1.5);
            this.field_145850_b.func_72838_d((Entity)bf);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "muke");
            data.func_74757_a("balefire", true);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 250.0));
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:weapon.mukeExplosion", 15.0f, 1.0f);
        } else if (rand < 5) {
            EntityBlackHole bl = new EntityBlackHole(this.field_145850_b, 1.5f + this.field_145850_b.field_73012_v.nextFloat());
            bl.field_70165_t = (float)this.field_145851_c + 0.5f;
            bl.field_70163_u = (float)this.field_145848_d + 1.5f;
            bl.field_70161_v = (float)this.field_145849_e + 0.5f;
            this.field_145850_b.func_72838_d((Entity)bl);
        }
    }

    public boolean canProcess() {
        for (int i = 0; i < 3; ++i) {
            ItemStack out;
            Object[] res = CyclotronRecipes.getOutput(this.slots[i + 3], this.slots[i]);
            if (res == null || (out = (ItemStack)res[0]) == null) continue;
            if (this.slots[i + 6] == null) {
                return true;
            }
            if (this.slots[i + 6].func_77973_b() != out.func_77973_b() || this.slots[i + 6].func_77960_j() != out.func_77960_j() || this.slots[i + 6].field_77994_a >= out.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    public void process() {
        for (int i = 0; i < 3; ++i) {
            ItemStack out;
            Object[] res = CyclotronRecipes.getOutput(this.slots[i + 3], this.slots[i]);
            if (res == null || (out = (ItemStack)res[0]) == null) continue;
            if (this.slots[i + 6] == null) {
                this.func_70298_a(i, 1);
                this.func_70298_a(i + 3, 1);
                this.slots[i + 6] = out;
                this.amat.setFill(this.amat.getFill() + (Integer)res[1]);
                continue;
            }
            if (this.slots[i + 6].func_77973_b() != out.func_77973_b() || this.slots[i + 6].func_77960_j() != out.func_77960_j() || this.slots[i + 6].field_77994_a >= out.func_77976_d()) continue;
            this.func_70298_a(i, 1);
            this.func_70298_a(i + 3, 1);
            ++this.slots[i + 6].field_77994_a;
            this.amat.setFill(this.amat.getFill() + (Integer)res[1]);
        }
        if (this.amat.getFill() > this.amat.getMaxFill()) {
            this.amat.setFill(this.amat.getMaxFill());
        }
    }

    public int getSpeed() {
        int speed = 1;
        for (int i = 14; i < 16; ++i) {
            if (this.slots[i] == null) continue;
            if (this.slots[i].func_77973_b() == ModItems.upgrade_speed_1) {
                ++speed;
                continue;
            }
            if (this.slots[i].func_77973_b() == ModItems.upgrade_speed_2) {
                speed += 2;
                continue;
            }
            if (this.slots[i].func_77973_b() != ModItems.upgrade_speed_3) continue;
            speed += 3;
        }
        return Math.min(speed, 4);
    }

    public int getConsumption() {
        int speed = 0;
        for (int i = 14; i < 16; ++i) {
            if (this.slots[i] == null) continue;
            if (this.slots[i].func_77973_b() == ModItems.upgrade_power_1) {
                ++speed;
                continue;
            }
            if (this.slots[i].func_77973_b() == ModItems.upgrade_power_2) {
                speed += 2;
                continue;
            }
            if (this.slots[i].func_77973_b() != ModItems.upgrade_power_3) continue;
            speed += 3;
        }
        return Math.min(speed, 3);
    }

    public int getSafety() {
        int speed = 1;
        for (int i = 14; i < 16; ++i) {
            if (this.slots[i] == null) continue;
            if (this.slots[i].func_77973_b() == ModItems.upgrade_effect_1) {
                ++speed;
                continue;
            }
            if (this.slots[i].func_77973_b() == ModItems.upgrade_effect_2) {
                speed += 2;
                continue;
            }
            if (this.slots[i].func_77973_b() != ModItems.upgrade_effect_3) continue;
            speed += 3;
        }
        return Math.min(speed, 4);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 690;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        if (index == 0) {
            this.coolant.setFill(fill);
        } else if (index == 1) {
            this.amat.setFill(fill);
        }
    }

    @Override
    public void setFluidFill(int fill, FluidType type) {
        if (type == Fluids.COOLANT) {
            this.coolant.setFill(fill);
        } else if (type == Fluids.AMAT) {
            this.amat.setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        if (index == 0) {
            this.coolant.setTankType(type);
        } else if (index == 1) {
            this.amat.setTankType(type);
        }
    }

    @Override
    public int getFluidFill(FluidType type) {
        if (type == Fluids.COOLANT) {
            return this.coolant.getFill();
        }
        if (type == Fluids.AMAT) {
            return this.amat.getFill();
        }
        return 0;
    }

    @Override
    public void fillFluidInit(FluidType type) {
        this.fillFluid(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 3, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 3, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 3, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 3, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidType type) {
        this.list.clear();
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (type == Fluids.COOLANT) {
            return this.coolant.getMaxFill();
        }
        return 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 3));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.coolant.readFromNBT(nbt, "coolant");
        this.amat.readFromNBT(nbt, "amat");
        this.isOn = nbt.func_74767_n("isOn");
        this.countdown = nbt.func_74762_e("countdown");
        this.progress = nbt.func_74762_e("progress");
        this.power = nbt.func_74763_f("power");
        this.plugs = nbt.func_74771_c("plugs");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.coolant.writeToNBT(nbt, "coolant");
        this.amat.writeToNBT(nbt, "amat");
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74768_a("countdown", this.countdown);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74772_a("power", this.power);
        nbt.func_74774_a("plugs", this.plugs);
    }

    public void setPlug(int index) {
        this.plugs = (byte)(this.plugs | 1 << index);
        this.func_70296_d();
    }

    public boolean getPlug(int index) {
        return (this.plugs & 1 << index) > 0;
    }

    public static Item getItemForPlug(int i) {
        switch (i) {
            case 0: {
                return ModItems.powder_balefire;
            }
            case 1: {
                return ModItems.book_of_;
            }
            case 2: {
                return ModItems.diamond_gavel;
            }
            case 3: {
                return ModItems.coin_maskman;
            }
        }
        return null;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && i >= 14 && i <= 15 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.5f, 1.0f);
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.amat};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.coolant};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.amat, this.coolant};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineCyclotron(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineCyclotron(player.field_71071_by, this);
    }
}

