/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.inventory.container.ContainerCrystallizer;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUICrystallizer;
import com.hbm.inventory.recipes.CrystallizerRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCrystallizer
extends TileEntityMachineBase
implements IEnergyUser,
IFluidStandardReceiver,
IGUIProvider {
    public long power;
    public static final long maxPower = 1000000L;
    public static final int demand = 1000;
    public short progress;
    public short duration = (short)600;
    public float angle;
    public float prevAngle;
    public FluidTank tank = new FluidTank(Fluids.ACID, 8000);

    public TileEntityMachineCrystallizer() {
        super(8);
    }

    @Override
    public String getName() {
        return "container.crystallizer";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.power = Library.chargeTEFromItems(this.slots, 1, this.power, 1000000L);
            this.tank.setType(7, this.slots);
            this.tank.loadTank(3, 4, this.slots);
            int i = 0;
            while ((float)i < this.getCycleCount()) {
                if (this.canProcess()) {
                    this.progress = (short)(this.progress + 1);
                    this.power -= (long)this.getPowerRequired();
                    if (this.progress > this.getDuration()) {
                        this.progress = 0;
                        this.processItem();
                        this.func_70296_d();
                    }
                } else {
                    this.progress = 0;
                }
                ++i;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("progress", this.progress);
            data.func_74777_a("duration", this.getDuration());
            data.func_74772_a("power", this.power);
            this.tank.writeToNBT(data, "t");
            this.networkPack(data, 25);
        } else {
            this.prevAngle = this.angle;
            if (this.progress > 0) {
                this.angle += 5.0f * this.getCycleCount();
                if (this.angle >= 360.0f) {
                    this.angle -= 360.0f;
                    this.prevAngle -= 360.0f;
                }
            }
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        if (dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH) {
            return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d + 5, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d + 5, this.field_145849_e, Library.NEG_X)};
        }
        if (dir == ForgeDirection.EAST || dir == ForgeDirection.WEST) {
            return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d + 5, this.field_145849_e - 2, Library.NEG_Z)};
        }
        return new DirPos[0];
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.progress = data.func_74765_d("progress");
        this.duration = data.func_74765_d("duration");
        this.tank.readFromNBT(data, "t");
    }

    private void processItem() {
        CrystallizerRecipes.CrystallizerRecipe result = CrystallizerRecipes.getOutput(this.slots[0], this.tank.getTankType());
        if (result == null) {
            return;
        }
        ItemStack stack = result.output.func_77946_l();
        if (this.slots[2] == null) {
            this.slots[2] = stack;
        } else if (this.slots[2].field_77994_a + stack.field_77994_a <= this.slots[2].func_77976_d()) {
            this.slots[2].field_77994_a += stack.field_77994_a;
        }
        this.tank.setFill(this.tank.getFill() - result.acidAmount);
        float freeChance = this.getFreeChance();
        if (freeChance == 0.0f || freeChance < this.field_145850_b.field_73012_v.nextFloat()) {
            this.func_70298_a(0, result.itemAmount);
        }
    }

    private boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        if (this.power < (long)this.getPowerRequired()) {
            return false;
        }
        CrystallizerRecipes.CrystallizerRecipe result = CrystallizerRecipes.getOutput(this.slots[0], this.tank.getTankType());
        if (result == null) {
            return false;
        }
        if (this.slots[0].field_77994_a < result.itemAmount) {
            return false;
        }
        if (this.tank.getFill() < result.acidAmount) {
            return false;
        }
        ItemStack stack = result.output.func_77946_l();
        if (this.slots[2] != null && (this.slots[2].func_77973_b() != stack.func_77973_b() || this.slots[2].func_77960_j() != stack.func_77960_j())) {
            return false;
        }
        return this.slots[2] == null || this.slots[2].field_77994_a + stack.field_77994_a <= this.slots[2].func_77976_d();
    }

    public int getRequiredAcid(int base) {
        for (int i = 5; i <= 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_effect_1) {
                base *= 3;
            }
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_effect_2) {
                base *= 4;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_effect_3) continue;
            base *= 5;
        }
        return base;
    }

    public float getFreeChance() {
        float chance = 0.0f;
        for (int i = 5; i <= 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_effect_1) {
                chance += 0.05f;
            }
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_effect_2) {
                chance += 0.1f;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_effect_3) continue;
            chance += 0.15f;
        }
        return Math.min(chance, 0.15f);
    }

    public short getDuration() {
        float durationMod = 1.0f;
        CrystallizerRecipes.CrystallizerRecipe result = CrystallizerRecipes.getOutput(this.slots[0], this.tank.getTankType());
        int base = result != null ? result.duration : 600;
        for (int i = 5; i <= 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_speed_1) {
                durationMod -= 0.25f;
            }
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_speed_2) {
                durationMod -= 0.5f;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_speed_3) continue;
            durationMod -= 0.75f;
        }
        return (short)Math.ceil((float)base * Math.max(durationMod, 0.25f));
    }

    public int getPowerRequired() {
        int consumption = 0;
        for (int i = 5; i <= 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_speed_1) {
                consumption += 1000;
            }
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_speed_2) {
                consumption += 2000;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_speed_3) continue;
            consumption += 3000;
        }
        return 1000 + Math.min(consumption, 3000);
    }

    public float getCycleCount() {
        int cycles = 1;
        for (int i = 5; i <= 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_overdrive_1) {
                cycles += 2;
            }
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_overdrive_2) {
                cycles += 4;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_overdrive_3) continue;
            cycles += 6;
        }
        return Math.min(cycles, 4);
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 1000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / this.duration;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tank.writeToNBT(nbt, "tank");
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        CrystallizerRecipes.CrystallizerRecipe recipe = CrystallizerRecipes.getOutput(itemStack, this.tank.getTankType());
        if (i == 0 && recipe != null) {
            return true;
        }
        return i == 1 && itemStack.func_77973_b() instanceof IBatteryItem;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 2;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 2;
        }
        return nArray;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && i >= 5 && i <= 6 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCrystallizer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICrystallizer(player.field_71071_by, this);
    }
}

