/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerCompressor;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUICompressor;
import com.hbm.inventory.recipes.CompressorRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCompressor
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver,
IEnergyUser,
IFluidStandardTransceiver {
    public FluidTank[] tanks = new FluidTank[2];
    public long power;
    public static final long maxPower = 100000L;
    public boolean isOn;
    public int progress;
    public int processTime = 100;
    public static final int processTimeBase = 100;
    public int powerRequirement;
    public static final int powerRequirementBase = 2500;
    public float fanSpin;
    public float prevFanSpin;
    public float piston;
    public float prevPiston;
    public boolean pistonDir;
    private float randSpeed = 0.1f;
    AxisAlignedBB bb = null;

    public TileEntityMachineCompressor() {
        super(4);
        this.tanks[0] = new FluidTank(Fluids.NONE, 16000);
        this.tanks[1] = new FluidTank(Fluids.NONE, 16000).withPressure(1);
    }

    @Override
    public String getName() {
        return "container.machineCompressor";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            this.power = Library.chargeTEFromItems(this.slots, 1, this.power, 100000L);
            this.tanks[0].setType(0, this.slots);
            this.setupTanks();
            UpgradeManager.eval(this.slots, 1, 3);
            int speedLevel = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3);
            int powerLevel = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            int overLevel = UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            CompressorRecipes.CompressorRecipe rec = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), this.tanks[0].getPressure()));
            int timeBase = 100;
            if (rec != null) {
                timeBase = rec.duration;
            }
            this.processTime = timeBase == 100 ? (speedLevel == 3 ? 10 : (speedLevel == 2 ? 20 : (speedLevel == 1 ? 60 : timeBase))) : timeBase / (speedLevel + 1);
            this.powerRequirement = 2500 / (powerLevel + 1);
            this.processTime /= overLevel + 1;
            this.powerRequirement *= overLevel * 2 + 1;
            if (this.processTime <= 0) {
                this.processTime = 1;
            }
            if (this.canProcess()) {
                ++this.progress;
                this.isOn = true;
                this.power -= (long)this.powerRequirement;
                if (this.progress >= this.processTime) {
                    this.progress = 0;
                    this.process();
                    this.markChanged();
                }
            } else {
                this.progress = 0;
                this.isOn = false;
            }
            for (DirPos pos : this.getConPos()) {
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("processTime", this.processTime);
            data.func_74768_a("powerRequirement", this.powerRequirement);
            data.func_74772_a("power", this.power);
            this.tanks[0].writeToNBT(data, "0");
            this.tanks[1].writeToNBT(data, "1");
            data.func_74757_a("isOn", this.isOn);
            this.networkPack(data, 100);
        } else {
            this.prevFanSpin = this.fanSpin;
            this.prevPiston = this.piston;
            if (this.isOn) {
                this.fanSpin += 15.0f;
                if (this.fanSpin >= 360.0f) {
                    this.prevFanSpin -= 360.0f;
                    this.fanSpin -= 360.0f;
                }
                if (this.pistonDir) {
                    this.piston -= this.randSpeed;
                    if (this.piston <= 0.0f) {
                        MainRegistry.proxy.playSoundClient(this.field_145851_c, this.field_145848_d, this.field_145849_e, "hbm:item.boltgun", 0.5f, 0.75f);
                        this.pistonDir = !this.pistonDir;
                    }
                } else {
                    this.piston += 0.05f;
                    if (this.piston >= 1.0f) {
                        this.randSpeed = 0.085f + this.field_145850_b.field_73012_v.nextFloat() * 0.03f;
                        this.pistonDir = !this.pistonDir;
                    }
                }
                this.piston = MathHelper.func_76131_a((float)this.piston, (float)0.0f, (float)1.0f);
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.progress = nbt.func_74762_e("progress");
        this.processTime = nbt.func_74762_e("processTime");
        this.powerRequirement = nbt.func_74762_e("powerRequirement");
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "0");
        this.tanks[1].readFromNBT(nbt, "1");
        this.isOn = nbt.func_74767_n("isOn");
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2, dir.getOpposite())};
    }

    public boolean canProcess() {
        if (this.power <= (long)this.powerRequirement) {
            return false;
        }
        CompressorRecipes.CompressorRecipe recipe = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), this.tanks[0].getPressure()));
        if (recipe == null) {
            return this.tanks[0].getFill() >= 1000 && this.tanks[1].getFill() + 1000 <= this.tanks[1].getMaxFill();
        }
        return this.tanks[0].getFill() > recipe.inputAmount && this.tanks[1].getFill() + recipe.output.fill <= this.tanks[1].getMaxFill();
    }

    public void process() {
        CompressorRecipes.CompressorRecipe recipe = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), this.tanks[0].getPressure()));
        if (recipe == null) {
            this.tanks[0].setFill(this.tanks[0].getFill() - 1000);
            this.tanks[1].setFill(this.tanks[1].getFill() + 1000);
        } else {
            this.tanks[0].setFill(this.tanks[0].getFill() - recipe.inputAmount);
            this.tanks[1].setFill(this.tanks[1].getFill() + recipe.output.fill);
        }
    }

    protected void setupTanks() {
        CompressorRecipes.CompressorRecipe recipe = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), this.tanks[0].getPressure()));
        if (recipe == null) {
            this.tanks[1].withPressure(this.tanks[0].getPressure() + 1).setTankType(this.tanks[0].getTankType());
        } else {
            this.tanks[1].withPressure(recipe.output.pressure).setTankType(recipe.output.type);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.tanks[0].readFromNBT(nbt, "0");
        this.tanks[1].readFromNBT(nbt, "1");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("progress", this.progress);
        this.tanks[0].writeToNBT(nbt, "0");
        this.tanks[1].writeToNBT(nbt, "1");
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCompressor(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICompressor(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        int compression = data.func_74762_e("compression");
        if (compression != this.tanks[0].getPressure()) {
            this.tanks[0].withPressure(compression);
            CompressorRecipes.CompressorRecipe recipe = CompressorRecipes.recipes.get(new Tuple.Pair<FluidType, Integer>(this.tanks[0].getTankType(), compression));
            if (recipe == null) {
                this.tanks[1].withPressure(compression + 1);
            } else {
                this.tanks[1].withPressure(recipe.output.pressure).setTankType(recipe.output.type);
            }
            this.markChanged();
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 9), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

