/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerCombustionEngine;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.inventory.gui.GUICombustionEngine;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemPistons;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCombustionEngine
extends TileEntityMachinePolluting
implements IEnergyGenerator,
IFluidStandardTransceiver,
IControlReceiver,
IGUIProvider {
    public boolean isOn = false;
    public static long maxPower = 2500000L;
    public long power;
    private int playersUsing = 0;
    public int setting = 0;
    public boolean wasOn = false;
    public float doorAngle = 0.0f;
    public float prevDoorAngle = 0.0f;
    private AudioWrapper audio;
    public FluidTank tank = new FluidTank(Fluids.DIESEL, 24000, 0);
    public int tenth = 0;
    AxisAlignedBB bb = null;

    public TileEntityMachineCombustionEngine() {
        super(5, 50);
    }

    @Override
    public String getName() {
        return "container.combustionEngine";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tank.loadTank(0, 1, this.slots);
            if (this.tank.setType(4, this.slots)) {
                this.tenth = 0;
            }
            this.wasOn = false;
            int fill = this.tank.getFill() * 10 + this.tenth;
            if (this.isOn && this.setting > 0 && this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.piston_set && fill > 0 && this.tank.getTankType().hasTrait(FT_Combustible.class)) {
                ItemPistons.EnumPistonType piston = (ItemPistons.EnumPistonType)((Object)EnumUtil.grabEnumSafely(ItemPistons.EnumPistonType.class, this.slots[2].func_77960_j()));
                FT_Combustible trait = this.tank.getTankType().getTrait(FT_Combustible.class);
                double eff = piston.eff[trait.getGrade().ordinal()];
                if (eff > 0.0) {
                    int speed = this.setting * 2;
                    int toBurn = Math.min(fill, speed);
                    this.power = (long)((double)this.power + (double)toBurn * ((double)trait.getCombustionEnergy() / 10000.0) * eff);
                    fill -= toBurn;
                    if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                        this.pollute(PollutionHandler.PollutionType.SOOT, 0.04f * (float)this.setting * 0.1f);
                        if (this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Leaded.class)) {
                            this.pollute(PollutionHandler.PollutionType.HEAVYMETAL, 0.02f * (float)this.setting * 0.1f);
                        }
                    }
                    if (toBurn > 0) {
                        this.wasOn = true;
                    }
                    this.tank.setFill(fill / 10);
                    this.tenth = fill % 10;
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", Math.min(this.power, maxPower));
            this.power = Library.chargeItemsFromTE(this.slots, 3, this.power, this.power);
            for (DirPos pos : this.getConPos()) {
                this.sendPower(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.sendSmoke(pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.power > maxPower) {
                this.power = maxPower;
            }
            data.func_74768_a("playersUsing", this.playersUsing);
            data.func_74768_a("setting", this.setting);
            data.func_74757_a("isOn", this.isOn);
            data.func_74757_a("wasOn", this.wasOn);
            this.tank.writeToNBT(data, "tank");
            this.networkPack(data, 50);
        } else {
            this.prevDoorAngle = this.doorAngle;
            float swingSpeed = this.doorAngle / 10.0f + 3.0f;
            this.doorAngle = this.playersUsing > 0 ? (this.doorAngle += swingSpeed) : (this.doorAngle -= swingSpeed);
            this.doorAngle = MathHelper.func_76131_a((float)this.doorAngle, (float)0.0f, (float)135.0f);
            if (this.wasOn) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 1 + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX * 1 - rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 - rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ, dir.getOpposite())};
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.igeneratorOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.DOWN;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.playersUsing = nbt.func_74762_e("playersUsing");
        this.setting = nbt.func_74762_e("setting");
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.wasOn = nbt.func_74767_n("wasOn");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setting = nbt.func_74762_e("setting");
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.tank.readFromNBT(nbt, "tank");
        this.tenth = nbt.func_74762_e("tenth");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("setting", this.setting);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("isOn", this.isOn);
        this.tank.writeToNBT(nbt, "tank");
        nbt.func_74768_a("tenth", this.tenth);
    }

    @Override
    public void func_70295_k_() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.playersUsing;
        }
    }

    @Override
    public void func_70305_f() {
        if (!this.field_145850_b.field_72995_K) {
            --this.playersUsing;
        }
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCombustionEngine(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICombustionEngine(player.field_71071_by, this);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.getSmokeTanks();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 25.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("turnOn")) {
            boolean bl = this.isOn = !this.isOn;
        }
        if (data.func_74764_b("setting")) {
            this.setting = data.func_74762_e("setting");
        }
        this.markChanged();
    }
}

