/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.machine.MachineCoal;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.container.ContainerMachineCoal;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineCoal;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCoal
extends TileEntityMachinePolluting
implements ISidedInventory,
IEnergyGenerator,
IFluidStandardTransceiver,
IConfigurableMachine,
IGUIProvider {
    public long power;
    public int burnTime;
    public static final long maxPower = 100000L;
    public FluidTank tank = new FluidTank(Fluids.WATER, waterCap, 0);
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{0, 2};
    private static final int[] slots_side = new int[]{0, 2};
    public static int waterCap = 5000;
    public static int genRate = 25;
    public static double fuelMod = 0.5;

    public TileEntityMachineCoal() {
        super(4, 50);
    }

    @Override
    public String getName() {
        return "container.machineCoal";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0 && FluidContainerRegistry.getFluidContent(stack, Fluids.WATER) > 0) {
            return true;
        }
        if (i == 2 && stack.func_77973_b() instanceof IBatteryItem) {
            return true;
        }
        return i == 1 && TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("powerTime");
        this.tank.readFromNBT(nbt, "water");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        this.tank.writeToNBT(nbt, "water");
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i == 0 && (itemStack.func_77973_b() == Items.field_151133_ar || itemStack.func_77973_b() == ModItems.rod_empty || itemStack.func_77973_b() == ModItems.rod_dual_empty || itemStack.func_77973_b() == ModItems.rod_quad_empty)) {
            return true;
        }
        return i == 2 && itemStack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == ((IBatteryItem)itemStack.func_77973_b()).getMaxCharge();
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.sendPower(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
                this.sendSmoke(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            this.subscribeToAllAround(Fluids.WATER, this);
            this.tank.loadTank(0, 3, this.slots);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            this.power = Library.chargeItemsFromTE(this.slots, 2, this.power, 100000L);
            boolean trigger = true;
            if (this.isItemValid() && this.burnTime == 0) {
                trigger = false;
            }
            if (trigger) {
                MachineCoal.updateBlockState(this.burnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.generate();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("burnTime", this.burnTime);
            this.tank.writeToNBT(data, "tank");
            this.networkPack(data, 15);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.tank.readFromNBT(nbt, "tank");
    }

    public void generate() {
        if (this.slots[1] != null && TileEntityFurnace.func_145952_a((ItemStack)this.slots[1]) > 0 && this.burnTime <= 0) {
            this.burnTime = (int)((double)TileEntityFurnace.func_145952_a((ItemStack)this.slots[1]) * fuelMod);
            --this.slots[1].field_77994_a;
            if (this.slots[1].field_77994_a == 0) {
                this.slots[1] = this.slots[1].func_77973_b().func_77668_q() != null ? new ItemStack(this.slots[1].func_77973_b().func_77668_q()) : null;
            }
        }
        if (this.burnTime > 0) {
            --this.burnTime;
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.pollute(PollutionHandler.PollutionType.SOOT, 0.04f);
            }
            if (this.tank.getFill() > 0) {
                this.tank.setFill(this.tank.getFill() - 1);
                this.power += (long)genRate;
                if (this.power > 100000L) {
                    this.power = 100000L;
                }
            }
        }
    }

    public boolean isItemValid() {
        return this.slots[1] != null && TileEntityFurnace.func_145952_a((ItemStack)this.slots[1]) > 0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.getSmokeTanks();
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public String getConfigName() {
        return "combustiongen";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        waterCap = IConfigurableMachine.grab(obj, "I:waterCapacity", waterCap);
        genRate = IConfigurableMachine.grab(obj, "I:powerGen", genRate);
        fuelMod = IConfigurableMachine.grab(obj, "D:burnTimeMod", fuelMod);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:waterCapacity").value((long)waterCap);
        writer.name("I:powerGen").value((long)genRate);
        writer.name("D:burnTimeMod").value(fuelMod);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineCoal(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineCoal(player.field_71071_by, this);
    }
}

