/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidUser;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.recipes.ChemplantRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public abstract class TileEntityMachineChemplantBase
extends TileEntityMachineBase
implements IEnergyUser,
IFluidUser,
IGUIProvider {
    public long power;
    public int[] progress;
    public int[] maxProgress;
    public boolean isProgressing;
    public FluidTank[] tanks;
    int consumption = 100;
    int speed = 100;

    public TileEntityMachineChemplantBase(int scount) {
        super(scount);
        int count = this.getRecipeCount();
        this.progress = new int[count];
        this.maxProgress = new int[count];
        this.tanks = new FluidTank[4 * count];
        for (int i = 0; i < 4 * count; ++i) {
            this.tanks[i] = new FluidTank(Fluids.NONE, this.getTankCapacity(), i);
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            int count = this.getRecipeCount();
            this.isProgressing = false;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
            for (i = 0; i < count; ++i) {
                this.loadItems(i);
                this.unloadItems(i);
            }
            for (i = 0; i < count; ++i) {
                if (!this.canProcess(i)) {
                    this.progress[i] = 0;
                    continue;
                }
                this.isProgressing = true;
                this.process(i);
            }
        }
    }

    protected boolean canProcess(int index) {
        int template = this.getTemplateIndex(index);
        if (this.slots[template] == null || this.slots[template].func_77973_b() != ModItems.chemistry_template) {
            return false;
        }
        ChemplantRecipes.ChemRecipe recipe = ChemplantRecipes.indexMapping.get(this.slots[template].func_77960_j());
        if (recipe == null) {
            return false;
        }
        this.setupTanks(recipe, index);
        if (this.power < (long)this.consumption) {
            return false;
        }
        if (!this.hasRequiredFluids(recipe, index)) {
            return false;
        }
        if (!this.hasSpaceForFluids(recipe, index)) {
            return false;
        }
        if (!this.hasRequiredItems(recipe, index)) {
            return false;
        }
        return this.hasSpaceForItems(recipe, index);
    }

    private void setupTanks(ChemplantRecipes.ChemRecipe recipe, int index) {
        if (recipe.inputFluids[0] != null) {
            this.tanks[index * 4].withPressure(recipe.inputFluids[0].pressure).setTankType(recipe.inputFluids[0].type);
        } else {
            this.tanks[index * 4].setTankType(Fluids.NONE);
        }
        if (recipe.inputFluids[1] != null) {
            this.tanks[index * 4 + 1].withPressure(recipe.inputFluids[1].pressure).setTankType(recipe.inputFluids[1].type);
        } else {
            this.tanks[index * 4 + 1].setTankType(Fluids.NONE);
        }
        if (recipe.outputFluids[0] != null) {
            this.tanks[index * 4 + 2].withPressure(recipe.outputFluids[0].pressure).setTankType(recipe.outputFluids[0].type);
        } else {
            this.tanks[index * 4 + 2].setTankType(Fluids.NONE);
        }
        if (recipe.outputFluids[1] != null) {
            this.tanks[index * 4 + 3].withPressure(recipe.outputFluids[1].pressure).setTankType(recipe.outputFluids[1].type);
        } else {
            this.tanks[index * 4 + 3].setTankType(Fluids.NONE);
        }
    }

    private boolean hasRequiredFluids(ChemplantRecipes.ChemRecipe recipe, int index) {
        if (recipe.inputFluids[0] != null && this.tanks[index * 4].getFill() < recipe.inputFluids[0].fill) {
            return false;
        }
        return recipe.inputFluids[1] == null || this.tanks[index * 4 + 1].getFill() >= recipe.inputFluids[1].fill;
    }

    private boolean hasSpaceForFluids(ChemplantRecipes.ChemRecipe recipe, int index) {
        if (recipe.outputFluids[0] != null && this.tanks[index * 4 + 2].getFill() + recipe.outputFluids[0].fill > this.tanks[index * 4 + 2].getMaxFill()) {
            return false;
        }
        return recipe.outputFluids[1] == null || this.tanks[index * 4 + 3].getFill() + recipe.outputFluids[1].fill <= this.tanks[index * 4 + 3].getMaxFill();
    }

    private boolean hasRequiredItems(ChemplantRecipes.ChemRecipe recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        return InventoryUtil.doesArrayHaveIngredients(this.slots, indices[0], indices[1], recipe.inputs);
    }

    private boolean hasSpaceForItems(ChemplantRecipes.ChemRecipe recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        return InventoryUtil.doesArrayHaveSpace(this.slots, indices[2], indices[3], recipe.outputs);
    }

    protected void process(int index) {
        this.power -= (long)this.consumption;
        int n = index;
        this.progress[n] = this.progress[n] + 1;
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.meteorite_sword_machined) {
            this.slots[0] = new ItemStack(ModItems.meteorite_sword_treated);
        }
        int template = this.getTemplateIndex(index);
        ChemplantRecipes.ChemRecipe recipe = ChemplantRecipes.indexMapping.get(this.slots[template].func_77960_j());
        this.maxProgress[index] = recipe.getDuration() * this.speed / 100;
        if (this.maxProgress[index] <= 0) {
            this.maxProgress[index] = 1;
        }
        if (this.progress[index] >= this.maxProgress[index]) {
            this.consumeFluids(recipe, index);
            this.produceFluids(recipe, index);
            this.consumeItems(recipe, index);
            this.produceItems(recipe, index);
            this.progress[index] = 0;
            this.func_70296_d();
        }
    }

    private void consumeFluids(ChemplantRecipes.ChemRecipe recipe, int index) {
        if (recipe.inputFluids[0] != null) {
            this.tanks[index * 4].setFill(this.tanks[index * 4].getFill() - recipe.inputFluids[0].fill);
        }
        if (recipe.inputFluids[1] != null) {
            this.tanks[index * 4 + 1].setFill(this.tanks[index * 4 + 1].getFill() - recipe.inputFluids[1].fill);
        }
    }

    private void produceFluids(ChemplantRecipes.ChemRecipe recipe, int index) {
        if (recipe.outputFluids[0] != null) {
            this.tanks[index * 4 + 2].setFill(this.tanks[index * 4 + 2].getFill() + recipe.outputFluids[0].fill);
        }
        if (recipe.outputFluids[1] != null) {
            this.tanks[index * 4 + 3].setFill(this.tanks[index * 4 + 3].getFill() + recipe.outputFluids[1].fill);
        }
    }

    private void consumeItems(ChemplantRecipes.ChemRecipe recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (RecipesCommon.AStack in : recipe.inputs) {
            if (in == null) continue;
            InventoryUtil.tryConsumeAStack(this.slots, indices[0], indices[1], in);
        }
    }

    private void produceItems(ChemplantRecipes.ChemRecipe recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (ItemStack out : recipe.outputs) {
            if (out == null) continue;
            InventoryUtil.tryAddItemToInventory(this.slots, indices[2], indices[3], out.func_77946_l());
        }
    }

    private void loadItems(int index) {
        int template = this.getTemplateIndex(index);
        if (this.slots[template] == null || this.slots[template].func_77973_b() != ModItems.chemistry_template) {
            return;
        }
        ChemplantRecipes.ChemRecipe recipe = ChemplantRecipes.indexMapping.get(this.slots[template].func_77960_j());
        if (recipe != null) {
            ChunkCoordinates[] positions = this.getInputPositions();
            int[] indices = this.getSlotIndicesFromIndex(index);
            for (ChunkCoordinates coord : positions) {
                TileEntity te = this.field_145850_b.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
                if (!(te instanceof IInventory)) continue;
                IInventory inv = (IInventory)te;
                ISidedInventory sided = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
                for (RecipesCommon.AStack ingredient : recipe.inputs) {
                    block2: while (!InventoryUtil.doesArrayHaveIngredients(this.slots, indices[0], indices[1], ingredient)) {
                        boolean found = false;
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            int j;
                            ItemStack stack = inv.func_70301_a(i);
                            if (!ingredient.matchesRecipe(stack, true) || sided != null && !sided.func_102008_b(i, stack, 0)) continue;
                            for (j = indices[0]; j <= indices[1]; ++j) {
                                if (this.slots[j] == null || !(this.slots[j].field_77994_a < this.slots[j].func_77976_d() & InventoryUtil.doesStackDataMatch(this.slots[j], stack))) continue;
                                inv.func_70298_a(i, 1);
                                ++this.slots[j].field_77994_a;
                                continue block2;
                            }
                            for (j = indices[0]; j <= indices[1]; ++j) {
                                if (this.slots[j] != null) continue;
                                this.slots[j] = stack.func_77946_l();
                                this.slots[j].field_77994_a = 1;
                                inv.func_70298_a(i, 1);
                                continue block2;
                            }
                        }
                        if (found) continue;
                        return;
                    }
                }
            }
        }
    }

    private void unloadItems(int index) {
        ChunkCoordinates[] positions = this.getOutputPositions();
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (ChunkCoordinates coord : positions) {
            TileEntity te = this.field_145850_b.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
            if (!(te instanceof IInventory)) continue;
            IInventory inv = (IInventory)te;
            for (int i = indices[2]; i <= indices[3]; ++i) {
                int j;
                ItemStack out = this.slots[i];
                if (out == null) continue;
                for (j = 0; j < inv.func_70302_i_(); ++j) {
                    ItemStack target;
                    if (!inv.func_94041_b(j, out) || !InventoryUtil.doesStackDataMatch(out, target = inv.func_70301_a(j)) || target.field_77994_a >= target.func_77976_d() || target.field_77994_a >= inv.func_70297_j_()) continue;
                    this.func_70298_a(i, 1);
                    ++target.field_77994_a;
                    return;
                }
                for (j = 0; j < inv.func_70302_i_(); ++j) {
                    if (!inv.func_94041_b(j, out) || inv.func_70301_a(j) != null || !inv.func_94041_b(j, out)) continue;
                    ItemStack copy = out.func_77946_l();
                    copy.field_77994_a = 1;
                    inv.func_70299_a(j, copy);
                    this.func_70298_a(i, 1);
                    return;
                }
            }
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    public int getMaxFluidFill(FluidType type) {
        int maxFill = 0;
        for (FluidTank tank : this.inTanks()) {
            if (tank.getTankType() != type) continue;
            maxFill += tank.getMaxFill();
        }
        return maxFill;
    }

    protected List<FluidTank> inTanks() {
        ArrayList<FluidTank> inTanks = new ArrayList<FluidTank>();
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidTank tank = this.tanks[i];
            if (tank.index % 4 >= 2) continue;
            inTanks.add(tank);
        }
        return inTanks;
    }

    public int getFluidFillForTransfer(FluidType type, int pressure) {
        int fill = 0;
        for (FluidTank tank : this.outTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            fill += tank.getFill();
        }
        return fill;
    }

    public void transferFluid(int amount, FluidType type, int pressure) {
        int i;
        if (amount <= 0) {
            return;
        }
        ArrayList<FluidTank> send = new ArrayList<FluidTank>();
        for (FluidTank tank : this.outTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            send.add(tank);
        }
        if (send.size() == 0) {
            return;
        }
        int offer = 0;
        ArrayList<Integer> weight = new ArrayList<Integer>();
        for (FluidTank tank : send) {
            int fillWeight = tank.getFill();
            offer += fillWeight;
            weight.add(fillWeight);
        }
        int tracker = amount;
        for (i = 0; i < send.size(); ++i) {
            FluidTank tank = (FluidTank)send.get(i);
            int fillWeight = (Integer)weight.get(i);
            int part = amount * fillWeight / offer;
            tank.setFill(tank.getFill() - part);
            tracker -= part;
        }
        for (i = 0; i < 100 && tracker > 0; ++i) {
            FluidTank tank = (FluidTank)send.get(i % send.size());
            if (tank.getFill() <= 0) continue;
            int total = Math.min(tank.getFill(), tracker);
            tracker -= total;
            tank.setFill(tank.getFill() - total);
        }
    }

    protected List<FluidTank> outTanks() {
        ArrayList<FluidTank> outTanks = new ArrayList<FluidTank>();
        for (int i = 0; i < this.tanks.length; ++i) {
            FluidTank tank = this.tanks[i];
            if (tank.index % 4 <= 1) continue;
            outTanks.add(tank);
        }
        return outTanks;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public long transferFluid(FluidType type, int pressure, long fluid) {
        int fillWeight;
        int amount = (int)fluid;
        if (amount <= 0) {
            return 0L;
        }
        ArrayList<FluidTank> rec = new ArrayList<FluidTank>();
        for (FluidTank tank : this.inTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            rec.add(tank);
        }
        if (rec.size() == 0) {
            return fluid;
        }
        int demand = 0;
        ArrayList<Integer> weight = new ArrayList<Integer>();
        for (FluidTank tank : rec) {
            fillWeight = tank.getMaxFill() - tank.getFill();
            demand += fillWeight;
            weight.add(fillWeight);
        }
        for (int i = 0; i < rec.size() && demand > 0; ++i) {
            FluidTank tank;
            tank = (FluidTank)rec.get(i);
            fillWeight = (Integer)weight.get(i);
            int part = (int)(Math.min((long)amount, (long)demand) * (long)fillWeight / (long)demand);
            tank.setFill(tank.getFill() + part);
            fluid -= (long)part;
        }
        return fluid;
    }

    @Override
    public long getDemand(FluidType type, int pressure) {
        return this.getMaxFluidFill(type) - this.getFluidFillForTransfer(type, pressure);
    }

    @Override
    public long getTotalFluidForSend(FluidType type, int pressure) {
        return this.getFluidFillForTransfer(type, pressure);
    }

    @Override
    public void removeFluidForTransfer(FluidType type, int pressure, long amount) {
        this.transferFluid((int)amount, type, pressure);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74759_k("progress");
        if (this.progress.length == 0) {
            this.progress = new int[this.getRecipeCount()];
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74783_a("progress", this.progress);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    public abstract int getRecipeCount();

    public abstract int getTankCapacity();

    public abstract int getTemplateIndex(int var1);

    public abstract int[] getSlotIndicesFromIndex(int var1);

    public abstract ChunkCoordinates[] getInputPositions();

    public abstract ChunkCoordinates[] getOutputPositions();
}

