/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerCentrifuge;
import com.hbm.inventory.gui.GUIMachineCentrifuge;
import com.hbm.inventory.recipes.CentrifugeRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityMachineCentrifuge
extends TileEntityMachineBase
implements IEnergyUser,
IGUIProvider {
    public int progress;
    public long power;
    public boolean isProgressing;
    public static final int maxPower = 100000;
    public static final int processingSpeed = 200;
    private int audioDuration = 0;
    private AudioWrapper audio;
    private static final int[] slot_io = new int[]{0, 2, 3, 4, 5};
    AxisAlignedBB bb = null;

    public TileEntityMachineCentrifuge() {
        super(8);
    }

    @Override
    public String getName() {
        return "container.centrifuge";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 0;
    }

    @Override
    public int[] func_94128_d(int side) {
        return slot_io;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74765_d("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74777_a("progress", (short)this.progress);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i > 1;
    }

    public int getCentrifugeProgressScaled(int i) {
        return this.progress * i / 200;
    }

    public long getPowerRemainingScaled(int i) {
        return this.power * (long)i / 100000L;
    }

    public boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        ItemStack[] out = CentrifugeRecipes.getOutput(this.slots[0]);
        if (out == null) {
            return false;
        }
        for (int i = 0; i < Math.min(4, out.length); ++i) {
            if (this.slots[i + 2] == null || out[i] == null || this.slots[i + 2].func_77969_a(out[i]) && this.slots[i + 2].field_77994_a + out[i].field_77994_a <= out[i].func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private void processItem() {
        ItemStack[] out = CentrifugeRecipes.getOutput(this.slots[0]);
        for (int i = 0; i < Math.min(4, out.length); ++i) {
            if (out[i] == null) continue;
            if (this.slots[i + 2] == null) {
                this.slots[i + 2] = out[i].func_77946_l();
                continue;
            }
            this.slots[i + 2].field_77994_a += out[i].field_77994_a;
        }
        this.func_70298_a(0, 1);
        this.func_70296_d();
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.power = Library.chargeTEFromItems(this.slots, 1, this.power, 100000L);
            int consumption = 200;
            int speed = 1;
            UpgradeManager.eval(this.slots, 6, 7);
            speed += Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3);
            consumption += Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) * 200;
            speed *= 1 + Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3) * 5;
            consumption += Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3) * 10000;
            consumption /= 1 + Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            if (this.hasPower() && this.isProcessing()) {
                this.power -= (long)consumption;
                if (this.power < 0L) {
                    this.power = 0L;
                }
            }
            this.isProgressing = this.hasPower() && this.canProcess();
            if (this.isProgressing) {
                this.progress += speed;
                if (this.progress >= 200) {
                    this.progress = 0;
                    this.processItem();
                }
            } else {
                this.progress = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74757_a("isProgressing", this.isProgressing);
            this.networkPack(data, 50);
        } else {
            this.audioDuration = this.isProgressing ? (this.audioDuration += 2) : (this.audioDuration -= 3);
            this.audioDuration = MathHelper.func_76125_a((int)this.audioDuration, (int)0, (int)60);
            if (this.audioDuration > 10) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.updatePitch((float)(this.audioDuration - 10) / 100.0f + 0.5f);
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.progress = data.func_74762_e("progress");
        this.isProgressing = data.func_74767_n("isProgressing");
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.centrifugeOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 1));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCentrifuge(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineCentrifuge(player.field_71071_by, this);
    }
}

