/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.inventory.container.ContainerAutocrafter;
import com.hbm.inventory.gui.GUIAutocrafter;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ItemStackUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityMachineAutocrafter
extends TileEntityMachineBase
implements IEnergyUser,
IGUIProvider {
    public static final String MODE_EXACT = "exact";
    public static final String MODE_WILDCARD = "wildcard";
    public String[] modes = new String[9];
    public List<IRecipe> recipes = new ArrayList<IRecipe>();
    public int recipeIndex;
    public int recipeCount;
    protected InventoryCraftingAuto craftingInventory = new InventoryCraftingAuto(3, 3);
    public int[] access = new int[]{10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    public static int consumption = 100;
    public static long maxPower = consumption * 100;
    public long power;

    public TileEntityMachineAutocrafter() {
        super(21);
    }

    public void initPattern(ItemStack stack, int i) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (stack == null) {
            this.modes[i] = null;
            return;
        }
        List<String> names = ItemStackUtil.getOreDictNames(stack);
        if (this.iterateAndCheck(names, i, "ingot")) {
            return;
        }
        if (this.iterateAndCheck(names, i, "block")) {
            return;
        }
        if (this.iterateAndCheck(names, i, "dust")) {
            return;
        }
        if (this.iterateAndCheck(names, i, "nugget")) {
            return;
        }
        if (this.iterateAndCheck(names, i, "plate")) {
            return;
        }
        this.modes[i] = stack.func_77981_g() ? MODE_EXACT : MODE_WILDCARD;
    }

    private boolean iterateAndCheck(List<String> names, int i, String prefix) {
        for (String s : names) {
            if (!s.startsWith(prefix)) continue;
            this.modes[i] = s;
            return true;
        }
        return false;
    }

    public void nextMode(int i) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack stack = this.slots[i];
        if (stack == null) {
            this.modes[i] = null;
            return;
        }
        if (this.modes[i] == null) {
            this.modes[i] = MODE_EXACT;
        } else if (MODE_EXACT.equals(this.modes[i])) {
            this.modes[i] = MODE_WILDCARD;
        } else if (MODE_WILDCARD.equals(this.modes[i])) {
            List<String> names = ItemStackUtil.getOreDictNames(stack);
            this.modes[i] = names.isEmpty() ? MODE_EXACT : names.get(0);
        } else {
            List<String> names = ItemStackUtil.getOreDictNames(stack);
            if (names.size() < 2 || this.modes[i].equals(names.get(names.size() - 1))) {
                this.modes[i] = MODE_EXACT;
            } else {
                for (int j = 0; j < names.size() - 1; ++j) {
                    if (!this.modes[i].equals(names.get(j))) continue;
                    this.modes[i] = names.get(j + 1);
                    return;
                }
            }
        }
    }

    public void nextTemplate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.recipeIndex;
        if (this.recipeIndex >= this.recipes.size()) {
            this.recipeIndex = 0;
        }
        this.slots[9] = !this.recipes.isEmpty() ? this.recipes.get(this.recipeIndex).func_77572_b(this.getTemplateGrid()) : null;
    }

    @Override
    public String getName() {
        return "container.autocrafter";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 20, this.power, maxPower);
            this.updateStandardConnections(this.field_145850_b, this);
            if (!this.recipes.isEmpty()) {
                ItemStack stack;
                IRecipe recipe;
                if (this.power >= (long)consumption && (recipe = this.recipes.get(this.recipeIndex)).func_77569_a(this.getRecipeGrid(), this.field_145850_b) && (stack = recipe.func_77572_b(this.getRecipeGrid())) != null) {
                    boolean didCraft = false;
                    if (this.slots[19] == null) {
                        this.slots[19] = stack.func_77946_l();
                        didCraft = true;
                    } else if (this.slots[19].func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.slots[19]) && this.slots[19].field_77994_a + stack.field_77994_a <= this.slots[19].func_77976_d()) {
                        this.slots[19].field_77994_a += stack.field_77994_a;
                        didCraft = true;
                    }
                    if (didCraft) {
                        for (int i = 10; i < 19; ++i) {
                            ItemStack container;
                            ItemStack ingredient = this.func_70301_a(i);
                            if (ingredient == null) continue;
                            this.func_70298_a(i, 1);
                            if (this.slots[i] != null || !ingredient.func_77973_b().hasContainerItem(ingredient) || (container = ingredient.func_77973_b().getContainerItem(ingredient)) != null && container.func_77984_f() && container.func_77960_j() > container.func_77958_k()) continue;
                            this.func_70299_a(i, container);
                        }
                        this.power -= (long)consumption;
                    }
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            for (int i = 0; i < 9; ++i) {
                if (this.modes[i] == null) continue;
                data.func_74778_a("mode" + i, this.modes[i]);
            }
            data.func_74768_a("count", this.recipeCount);
            data.func_74768_a("rec", this.recipeIndex);
            this.networkPack(data, 15);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.modes = new String[9];
        for (int i = 0; i < 9; ++i) {
            if (!data.func_74764_b("mode" + i)) continue;
            this.modes[i] = data.func_74779_i("mode" + i);
        }
        this.recipeCount = data.func_74762_e("count");
        this.recipeIndex = data.func_74762_e("rec");
    }

    public void updateTemplateGrid() {
        this.recipes = this.getMatchingRecipes(this.getTemplateGrid());
        this.recipeCount = this.recipes.size();
        this.recipeIndex = 0;
        this.slots[9] = !this.recipes.isEmpty() ? this.recipes.get(this.recipeIndex).func_77572_b(this.getTemplateGrid()) : null;
    }

    public List<IRecipe> getMatchingRecipes(InventoryCrafting grid) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (Object o : CraftingManager.func_77594_a().func_77592_b()) {
            IRecipe recipe = (IRecipe)o;
            if (!recipe.func_77569_a(grid, this.field_145850_b)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    @Override
    public int[] func_94128_d(int side) {
        return this.access;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        if (i == 19) {
            return true;
        }
        if (i > 9 && i < 19) {
            ItemStack filter = this.slots[i - 10];
            String mode = this.modes[i - 10];
            if (filter == null || mode == null || mode.isEmpty()) {
                return true;
            }
            return !this.isValidForFilter(filter, mode, stack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.field_77994_a > 1 && stack.func_77973_b().hasContainerItem(stack)) {
            return false;
        }
        if (slot < 10 || slot > 18) {
            return false;
        }
        if (this.slots[slot - 10] == null) {
            return false;
        }
        ArrayList<Integer> validSlots = new ArrayList<Integer>();
        for (int i = 0; i < 9; ++i) {
            ItemStack filter = this.slots[i];
            String mode = this.modes[i];
            if (filter == null || mode == null || mode.isEmpty() || !this.isValidForFilter(filter, mode, stack)) continue;
            validSlots.add(i + 10);
            if (i + 10 != slot || this.slots[slot] != null) continue;
            return true;
        }
        if (!validSlots.contains(slot)) {
            return false;
        }
        int size = this.slots[slot].field_77994_a;
        for (Integer i : validSlots) {
            ItemStack valid = this.slots[i];
            if (valid == null) {
                return false;
            }
            if (!valid.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)valid, (ItemStack)stack) || valid.field_77994_a >= size) continue;
            return false;
        }
        return !stack.func_77973_b().hasContainerItem(stack);
    }

    private boolean isValidForFilter(ItemStack filter, String mode, ItemStack input) {
        switch (mode) {
            case "exact": {
                return input.func_77969_a(filter) && ItemStack.func_77970_a((ItemStack)input, (ItemStack)filter);
            }
            case "wildcard": {
                return input.func_77973_b() == filter.func_77973_b() && ItemStack.func_77970_a((ItemStack)input, (ItemStack)filter);
            }
        }
        List<String> keys = ItemStackUtil.getOreDictNames(input);
        return keys.contains(mode);
    }

    public InventoryCrafting getTemplateGrid() {
        this.craftingInventory.loadIventory(this.slots, 0);
        return this.craftingInventory;
    }

    public InventoryCrafting getRecipeGrid() {
        this.craftingInventory.loadIventory(this.slots, 10);
        return this.craftingInventory;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        for (int i = 0; i < 9; ++i) {
            if (!nbt.func_74764_b("mode" + i)) continue;
            this.modes[i] = nbt.func_74779_i("mode" + i);
        }
        this.recipes = this.getMatchingRecipes(this.getTemplateGrid());
        this.recipeCount = this.recipes.size();
        this.recipeIndex = nbt.func_74762_e("rec");
        this.slots[9] = !this.recipes.isEmpty() ? this.recipes.get(this.recipeIndex).func_77572_b(this.getTemplateGrid()) : null;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        for (int i = 0; i < 9; ++i) {
            if (this.modes[i] == null) continue;
            nbt.func_74778_a("mode" + i, this.modes[i]);
        }
        nbt.func_74768_a("rec", this.recipeIndex);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerAutocrafter(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIAutocrafter(player.field_71071_by, this);
    }

    public static class InventoryCraftingAuto
    extends InventoryCrafting {
        public InventoryCraftingAuto(int width, int height) {
            super((Container)new ContainerBlank(), width, height);
        }

        public void loadIventory(ItemStack[] slots, int start) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.func_70299_a(i, slots[start + i]);
            }
        }

        public static class ContainerBlank
        extends Container {
            public void func_75130_a(IInventory inventory) {
            }

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }
    }
}

