/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.AssemblerRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemAssemblyTemplate;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.storage.TileEntityCrateTemplate;
import com.hbm.util.InventoryUtil;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public abstract class TileEntityMachineAssemblerBase
extends TileEntityMachineBase
implements IEnergyUser,
IGUIProvider {
    public long power;
    public int[] progress;
    public int[] maxProgress;
    public boolean isProgressing;
    public boolean[] needsTemplateSwitch;
    int consumption = 100;
    int speed = 100;

    public TileEntityMachineAssemblerBase(int scount) {
        super(scount);
        int count = this.getRecipeCount();
        this.progress = new int[count];
        this.maxProgress = new int[count];
        this.needsTemplateSwitch = new boolean[count];
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            int count = this.getRecipeCount();
            this.isProgressing = false;
            this.power = Library.chargeTEFromItems(this.slots, this.getPowerSlot(), this.power, this.getMaxPower());
            for (i = 0; i < count; ++i) {
                this.unloadItems(i);
                this.loadItems(i);
            }
            for (i = 0; i < count; ++i) {
                if (!this.canProcess(i)) {
                    this.progress[i] = 0;
                    continue;
                }
                this.isProgressing = true;
                this.process(i);
            }
        }
    }

    protected boolean canProcess(int index) {
        int template = this.getTemplateIndex(index);
        if (this.slots[template] == null || this.slots[template].func_77973_b() != ModItems.assembly_template) {
            return false;
        }
        List<RecipesCommon.AStack> recipe = AssemblerRecipes.getRecipeFromTempate(this.slots[template]);
        ItemStack output = AssemblerRecipes.getOutputFromTempate(this.slots[template]);
        if (recipe == null) {
            return false;
        }
        if (this.power < (long)this.consumption) {
            return false;
        }
        if (!this.hasRequiredItems(recipe, index)) {
            return false;
        }
        return this.hasSpaceForItems(output, index);
    }

    private boolean hasRequiredItems(List<RecipesCommon.AStack> recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        return InventoryUtil.doesArrayHaveIngredients(this.slots, indices[0], indices[1], recipe.toArray(new RecipesCommon.AStack[0]));
    }

    private boolean hasSpaceForItems(ItemStack recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        return InventoryUtil.doesArrayHaveSpace(this.slots, indices[2], indices[2], new ItemStack[]{recipe});
    }

    protected void process(int index) {
        this.power -= (long)this.consumption;
        int n = index;
        this.progress[n] = this.progress[n] + 1;
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.meteorite_sword_alloyed) {
            this.slots[0] = new ItemStack(ModItems.meteorite_sword_machined);
        }
        int template = this.getTemplateIndex(index);
        List<RecipesCommon.AStack> recipe = AssemblerRecipes.getRecipeFromTempate(this.slots[template]);
        ItemStack output = AssemblerRecipes.getOutputFromTempate(this.slots[template]);
        int time = ItemAssemblyTemplate.getProcessTime(this.slots[template]);
        this.maxProgress[index] = time * this.speed / 100;
        if (this.progress[index] >= this.maxProgress[index]) {
            this.consumeItems(recipe, index);
            this.produceItems(output, index);
            this.progress[index] = 0;
            this.needsTemplateSwitch[index] = true;
            this.func_70296_d();
        }
    }

    private void consumeItems(List<RecipesCommon.AStack> recipe, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (RecipesCommon.AStack in : recipe) {
            if (in == null) continue;
            InventoryUtil.tryConsumeAStack(this.slots, indices[0], indices[1], in);
        }
    }

    private void produceItems(ItemStack out, int index) {
        int[] indices = this.getSlotIndicesFromIndex(index);
        if (out != null) {
            InventoryUtil.tryAddItemToInventory(this.slots, indices[2], indices[2], out.func_77946_l());
        }
    }

    private void loadItems(int index) {
        int template = this.getTemplateIndex(index);
        ChunkCoordinates[] positions = this.getInputPositions();
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (ChunkCoordinates coord : positions) {
            List<RecipesCommon.AStack> recipe;
            boolean noTemplate;
            TileEntity te = this.field_145850_b.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
            if (!(te instanceof IInventory)) continue;
            IInventory inv = (IInventory)te;
            ISidedInventory sided = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
            boolean templateCrate = te instanceof TileEntityCrateTemplate;
            if (templateCrate && this.slots[template] == null) {
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack == null || stack.func_77973_b() != ModItems.assembly_template || sided != null && !sided.func_102008_b(i, stack, 0)) continue;
                    this.slots[template] = stack.func_77946_l();
                    sided.func_70299_a(i, null);
                    this.needsTemplateSwitch[index] = false;
                    break;
                }
            }
            boolean bl = noTemplate = this.slots[template] == null || this.slots[template].func_77973_b() != ModItems.assembly_template;
            if (noTemplate || (recipe = AssemblerRecipes.getRecipeFromTempate(this.slots[template])) == null) continue;
            for (RecipesCommon.AStack ingredient : recipe) {
                block3: while (!InventoryUtil.doesArrayHaveIngredients(this.slots, indices[0], indices[1], ingredient)) {
                    boolean found = false;
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        int j;
                        ItemStack stack = inv.func_70301_a(i);
                        if (!ingredient.matchesRecipe(stack, true) || sided != null && !sided.func_102008_b(i, stack, 0)) continue;
                        found = true;
                        for (j = indices[0]; j <= indices[1]; ++j) {
                            if (this.slots[j] == null || !(this.slots[j].field_77994_a < this.slots[j].func_77976_d() & InventoryUtil.doesStackDataMatch(this.slots[j], stack))) continue;
                            inv.func_70298_a(i, 1);
                            ++this.slots[j].field_77994_a;
                            continue block3;
                        }
                        for (j = indices[0]; j <= indices[1]; ++j) {
                            if (this.slots[j] != null) continue;
                            this.slots[j] = stack.func_77946_l();
                            this.slots[j].field_77994_a = 1;
                            inv.func_70298_a(i, 1);
                            continue block3;
                        }
                    }
                    if (found) continue;
                    return;
                }
            }
        }
    }

    private void unloadItems(int index) {
        ChunkCoordinates[] positions = this.getOutputPositions();
        int[] indices = this.getSlotIndicesFromIndex(index);
        for (ChunkCoordinates coord : positions) {
            int j;
            TileEntity te = this.field_145850_b.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
            if (!(te instanceof IInventory)) continue;
            IInventory inv = (IInventory)te;
            int i = indices[2];
            ItemStack out = this.slots[i];
            int template = this.getTemplateIndex(index);
            if (this.needsTemplateSwitch[index] && te instanceof TileEntityCrateTemplate && this.slots[template] != null) {
                out = this.slots[template];
                i = template;
            }
            if (out == null) continue;
            for (j = 0; j < inv.func_70302_i_(); ++j) {
                ItemStack target;
                if (!inv.func_94041_b(j, out) || !InventoryUtil.doesStackDataMatch(out, target = inv.func_70301_a(j)) || target.field_77994_a >= target.func_77976_d() || target.field_77994_a >= inv.func_70297_j_()) continue;
                this.func_70298_a(i, 1);
                ++target.field_77994_a;
                return;
            }
            for (j = 0; j < inv.func_70302_i_(); ++j) {
                if (!inv.func_94041_b(j, out) || inv.func_70301_a(j) != null || !inv.func_94041_b(j, out)) continue;
                ItemStack copy = out.func_77946_l();
                copy.field_77994_a = 1;
                inv.func_70299_a(j, copy);
                this.func_70298_a(i, 1);
                return;
            }
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    public abstract int getRecipeCount();

    public abstract int getTemplateIndex(int var1);

    public abstract int[] getSlotIndicesFromIndex(int var1);

    public abstract ChunkCoordinates[] getInputPositions();

    public abstract ChunkCoordinates[] getOutputPositions();

    public abstract int getPowerSlot();
}

