/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerMachineAssembler;
import com.hbm.inventory.gui.GUIMachineAssembler;
import com.hbm.inventory.recipes.AssemblerRecipes;
import com.hbm.items.machine.ItemAssemblyTemplate;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.machine.TileEntityMachineAssemblerBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineAssembler
extends TileEntityMachineAssemblerBase {
    public int recipe = -1;
    Random rand = new Random();
    private AudioWrapper audio;

    public TileEntityMachineAssembler() {
        super(18);
    }

    @Override
    public String getName() {
        return "container.assembler";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0 && itemStack.func_77973_b() instanceof IBatteryItem) {
            return true;
        }
        return i == 1;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.func_145832_p() < 12) {
                int meta = this.func_145832_p();
                if (meta == 2 || meta == 14) {
                    meta = 4;
                } else if (meta == 4 || meta == 13) {
                    meta = 3;
                } else if (meta == 3 || meta == 15) {
                    meta = 5;
                } else if (meta == 5 || meta == 12) {
                    meta = 2;
                }
                ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.machine_assembler, dir.ordinal() + 10, 3);
                MultiblockHandlerXR.fillSpace(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((BlockDummyable)ModBlocks.machine_assembler).getDimensions(), ModBlocks.machine_assembler, dir);
                NBTTagCompound data = new NBTTagCompound();
                this.func_145841_b(data);
                this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_145839_a(data);
                return;
            }
            this.updateConnections();
            this.consumption = 100;
            this.speed = 100;
            UpgradeManager.eval(this.slots, 1, 3);
            int speedLevel = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3);
            int powerLevel = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            int overLevel = UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            this.speed -= speedLevel * 25;
            this.consumption += speedLevel * 300;
            this.speed += powerLevel * 5;
            this.consumption -= powerLevel * 30;
            this.speed /= overLevel + 1;
            this.consumption *= overLevel + 1;
            int rec = -1;
            if (AssemblerRecipes.getOutputFromTempate(this.slots[4]) != null) {
                RecipesCommon.ComparableStack comp = ItemAssemblyTemplate.readType(this.slots[4]);
                rec = AssemblerRecipes.recipeList.indexOf(comp);
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74783_a("progress", this.progress);
            data.func_74783_a("maxProgress", this.maxProgress);
            data.func_74757_a("isProgressing", this.isProgressing);
            data.func_74768_a("recipe", rec);
            this.networkPack(data, 150);
        } else {
            float volume = this.getVolume(2);
            if (this.isProgressing && volume > 0.0f) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.updateVolume(volume);
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                    this.audio.updateVolume(volume);
                }
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74759_k("progress");
        this.maxProgress = nbt.func_74759_k("maxProgress");
        this.isProgressing = nbt.func_74767_n("isProgressing");
        this.recipe = nbt.func_74762_e("recipe");
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.assemblerOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f);
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 3 + dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3 + dir.offsetZ, rot), new DirPos(this.field_145851_c - rot.offsetX * 2 + dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2 + dir.offsetZ, rot.getOpposite())};
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public int getRecipeCount() {
        return 1;
    }

    @Override
    public int getTemplateIndex(int index) {
        return 4;
    }

    @Override
    public int[] getSlotIndicesFromIndex(int index) {
        return new int[]{6, 17, 5};
    }

    @Override
    public ChunkCoordinates[] getInputPositions() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new ChunkCoordinates[]{new ChunkCoordinates(this.field_145851_c - dir.offsetX * 3 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 3 + rot.offsetZ)};
    }

    @Override
    public ChunkCoordinates[] getOutputPositions() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return new ChunkCoordinates[]{new ChunkCoordinates(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2)};
    }

    @Override
    public int getPowerSlot() {
        return 0;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(2.0, 1.0, 2.0);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public int countMufflers() {
        int count = 0;
        for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
            for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                if (this.field_145850_b.func_147439_a(x, this.field_145848_d - 1, z) != ModBlocks.muffler) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineAssembler(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineAssembler(player.field_71071_by, this);
    }
}

