/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineArcFurnace;
import com.hbm.inventory.container.ContainerMachineArcFurnace;
import com.hbm.inventory.gui.GUIMachineArcFurnace;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class TileEntityMachineArcFurnace
extends TileEntityLoadedBase
implements ISidedInventory,
IEnergyUser,
IGUIProvider {
    private ItemStack[] slots = new ItemStack[6];
    public int dualCookTime;
    public long power;
    public static final long maxPower = 50000L;
    public static final int processingSpeed = 20;
    private static final int[] slots_io = new int[]{0, 1, 2, 3, 4, 5};
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.arcFurnace";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 2 || i == 3 || i == 4) {
            return itemStack.func_77973_b() == ModItems.arc_electrode || itemStack.func_77973_b() == ModItems.arc_electrode_desh;
        }
        if (i == 0) {
            return FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null;
        }
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.dualCookTime = nbt.func_74762_e("cookTime");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74768_a("cookTime", this.dualCookTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int side) {
        return slots_io;
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i == 1) {
            return true;
        }
        if (i == 2 || i == 3 || i == 4) {
            return itemStack.func_77973_b() == ModItems.arc_electrode_burnt;
        }
        return false;
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.dualCookTime * i / 20;
    }

    public long getPowerRemainingScaled(long i) {
        return this.power * i / 50000L;
    }

    public boolean hasPower() {
        return this.power >= 250L;
    }

    public boolean isProcessing() {
        return this.dualCookTime > 0;
    }

    private boolean hasElectrodes() {
        return !(this.slots[2] == null || this.slots[3] == null || this.slots[4] == null || this.slots[2].func_77973_b() != ModItems.arc_electrode && this.slots[2].func_77973_b() != ModItems.arc_electrode_desh || this.slots[3].func_77973_b() != ModItems.arc_electrode && this.slots[3].func_77973_b() != ModItems.arc_electrode_desh || this.slots[4].func_77973_b() != ModItems.arc_electrode && this.slots[4].func_77973_b() != ModItems.arc_electrode_desh);
    }

    public boolean canProcess() {
        if (!this.hasElectrodes()) {
            return false;
        }
        if (this.slots[0] == null) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
        if (itemStack == null) {
            return false;
        }
        if (this.slots[1] == null) {
            return true;
        }
        if (!this.slots[1].func_77969_a(itemStack)) {
            return false;
        }
        if (this.slots[1].field_77994_a < this.func_70297_j_() && this.slots[1].field_77994_a < this.slots[1].func_77976_d()) {
            return true;
        }
        return this.slots[1].field_77994_a < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            int i;
            ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
            if (this.slots[1] == null) {
                this.slots[1] = itemStack.func_77946_l();
            } else if (this.slots[1].func_77969_a(itemStack)) {
                this.slots[1].field_77994_a += itemStack.field_77994_a;
            }
            for (i = 0; i < 1; ++i) {
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = new ItemStack(this.slots[i].func_77973_b().func_77664_n());
                } else {
                    --this.slots[i].field_77994_a;
                }
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
            for (i = 2; i < 5; ++i) {
                if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.arc_electrode) continue;
                if (this.slots[i].func_77960_j() < this.slots[i].func_77958_k()) {
                    this.slots[i].func_77964_b(this.slots[i].func_77960_j() + 1);
                    continue;
                }
                this.slots[i] = new ItemStack(ModItems.arc_electrode_burnt);
            }
        }
    }

    public void func_145845_h() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            this.updateStandardConnections(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.hasPower() && this.canProcess()) {
                ++this.dualCookTime;
                this.power -= 250L;
                if (this.power < 0L) {
                    this.power = 0L;
                }
                if (this.dualCookTime == 20) {
                    this.dualCookTime = 0;
                    this.processItem();
                    flag1 = true;
                }
            } else {
                this.dualCookTime = 0;
            }
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.dualCookTime == 0) {
                trigger = false;
            }
            if (trigger) {
                flag1 = true;
                MachineArcFurnace.updateBlockState(this.dualCookTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) == ModBlocks.machine_arc_furnace_off) {
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (this.hasElectrodes() && meta <= 5) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta + 4, 2);
                }
                if (!this.hasElectrodes() && meta > 5) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta - 4, 2);
                }
            }
            this.power = Library.chargeTEFromItems(this.slots, 5, this.power, 50000L);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.dualCookTime, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 50000L;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineArcFurnace(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineArcFurnace(player.field_71071_by, this);
    }
}

