/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IHeatSource;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.container.ContainerFirebox;
import com.hbm.inventory.gui.GUIFirebox;
import com.hbm.module.ModuleBurnTime;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.machine.TileEntityFireboxBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class TileEntityHeaterOven
extends TileEntityFireboxBase
implements IConfigurableMachine {
    public static int baseHeat = 500;
    public static double timeMult = 0.125;
    public static int maxHeatEnergy = 500000;
    public static double heatEff = 0.5;
    public static ModuleBurnTime burnModule = new ModuleBurnTime().setLigniteTimeMod(1.25).setCoalTimeMod(1.25).setCokeTimeMod(1.25).setSolidTimeMod(1.5).setRocketTimeMod(1.5).setBalefireTimeMod(0.5).setLigniteHeatMod(2.0).setCoalHeatMod(2.0).setCokeHeatMod(2.0).setSolidHeatMod(3.0).setRocketHeatMod(5.0).setBalefireHeatMod(15.0);
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation texture;

    @Override
    public String getName() {
        return "container.heaterOven";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tryPullHeat();
        }
        super.func_145845_h();
    }

    protected void tryPullHeat() {
        TileEntity con = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int toPull = Math.max(Math.min(source.getHeatStored(), this.getMaxHeat() - this.heatEnergy), 0);
            this.heatEnergy = (int)((double)this.heatEnergy + (double)toPull * heatEff);
            source.useUpHeat(toPull);
        }
    }

    @Override
    public ModuleBurnTime getModule() {
        return burnModule;
    }

    @Override
    public int getBaseHeat() {
        return baseHeat;
    }

    @Override
    public double getTimeMult() {
        return timeMult;
    }

    @Override
    public int getMaxHeat() {
        return maxHeatEnergy;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFirebox(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (this.texture == null) {
            this.texture = new ResourceLocation("hbm:textures/gui/machine/gui_heating_oven.png");
        }
        return new GUIFirebox(player.field_71071_by, this, this.texture);
    }

    @Override
    public String getConfigName() {
        return "heatingoven";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        baseHeat = IConfigurableMachine.grab(obj, "I:baseHeat", baseHeat);
        timeMult = IConfigurableMachine.grab(obj, "D:burnTimeMult", timeMult);
        heatEff = IConfigurableMachine.grab(obj, "D:heatPullEff", heatEff);
        maxHeatEnergy = IConfigurableMachine.grab(obj, "I:heatCap", maxHeatEnergy);
        if (obj.has("burnModule")) {
            burnModule.readIfPresent(obj.get("M:burnModule").getAsJsonObject());
        }
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:baseHeat").value((long)baseHeat);
        writer.name("D:burnTimeMult").value(timeMult);
        writer.name("D:heatPullEff").value(heatEff);
        writer.name("I:heatCap").value((long)maxHeatEnergy);
        writer.name("M:burnModule").beginObject();
        burnModule.writeConfig(writer);
        writer.endObject();
    }
}

