/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IHeatSource;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerOilburner;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.inventory.gui.GUIOilburner;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityHeaterOilburner
extends TileEntityMachinePolluting
implements IGUIProvider,
IFluidStandardTransceiver,
IHeatSource,
IControlReceiver {
    public boolean isOn = false;
    public FluidTank tank = new FluidTank(Fluids.HEATINGOIL, 16000);
    public int setting = 1;
    public int heatEnergy;
    public static final int maxHeatEnergy = 100000;
    AxisAlignedBB bb = null;

    public TileEntityHeaterOilburner() {
        super(3, 100);
    }

    @Override
    public String getName() {
        return "container.heaterOilburner";
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tank.loadTank(0, 1, this.slots);
            this.tank.setType(2, this.slots);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.sendSmoke(pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            boolean shouldCool = true;
            if (this.isOn && this.heatEnergy < 100000 && this.tank.getTankType().hasTrait(FT_Flammable.class)) {
                FT_Flammable type = this.tank.getTankType().getTrait(FT_Flammable.class);
                int burnRate = this.setting;
                int toBurn = Math.min(burnRate, this.tank.getFill());
                this.tank.setFill(this.tank.getFill() - toBurn);
                int heat = (int)(type.getHeatEnergy() / 1000L);
                this.heatEnergy += heat * toBurn;
                if (this.field_145850_b.func_82737_E() % 20L == 0L && toBurn > 0) {
                    this.pollute(PollutionHandler.PollutionType.SOOT, 0.04f * (float)burnRate * 0.5f);
                    if (this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Leaded.class)) {
                        this.pollute(PollutionHandler.PollutionType.HEAVYMETAL, 0.02f * (float)burnRate * 0.5f);
                    }
                }
                shouldCool = false;
            }
            if (this.heatEnergy >= 100000) {
                shouldCool = false;
            }
            if (shouldCool) {
                this.heatEnergy = Math.max(this.heatEnergy - Math.max(this.heatEnergy / 1000, 1), 0);
            }
            NBTTagCompound data = new NBTTagCompound();
            this.tank.writeToNBT(data, "tank");
            data.func_74757_a("isOn", this.isOn);
            data.func_74768_a("h", this.heatEnergy);
            data.func_74774_a("s", (byte)this.setting);
            this.networkPack(data, 25);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.tank.readFromNBT(nbt, "tank");
        this.isOn = nbt.func_74767_n("isOn");
        this.heatEnergy = nbt.func_74762_e("h");
        this.setting = nbt.func_74771_c("s");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "tank");
        this.isOn = nbt.func_74767_n("isOn");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
        this.setting = nbt.func_74771_c("setting");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "tank");
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74768_a("heatEnergy", this.heatEnergy);
        nbt.func_74774_a("setting", (byte)this.setting);
    }

    public void toggleSetting() {
        ++this.setting;
        if (this.setting > 10) {
            this.setting = 1;
        }
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerOilburner(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIOilburner(player.field_71071_by, this);
    }

    @Override
    public int getHeatStored() {
        return this.heatEnergy;
    }

    @Override
    public void useUpHeat(int heat) {
        this.heatEnergy = Math.max(0, this.heatEnergy - heat);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 256.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toggle")) {
            this.isOn = !this.isOn;
        }
        this.markChanged();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.getSmokeTanks();
    }
}

