/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IHeatSource;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerHeaterHeatex;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.inventory.gui.GUIHeaterHeatex;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHeaterHeatex
extends TileEntityMachineBase
implements IHeatSource,
INBTPacketReceiver,
IFluidStandardTransceiver,
IGUIProvider,
IControlReceiver {
    public FluidTank[] tanks = new FluidTank[2];
    public int amountToCool = 1;
    public int tickDelay = 1;
    public int heatEnergy;
    AxisAlignedBB bb = null;

    public TileEntityHeaterHeatex() {
        super(1);
        this.tanks[0] = new FluidTank(Fluids.COOLANT_HOT, 24000, 0);
        this.tanks[1] = new FluidTank(Fluids.COOLANT, 24000, 1);
    }

    @Override
    public String getName() {
        return "container.heaterHeatex";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tanks[0].setType(0, this.slots);
            this.setupTanks();
            this.updateConnections();
            this.heatEnergy = (int)((double)this.heatEnergy * 0.999);
            NBTTagCompound data = new NBTTagCompound();
            this.tanks[0].writeToNBT(data, "0");
            this.tryConvert();
            this.tanks[1].writeToNBT(data, "1");
            data.func_74768_a("heat", this.heatEnergy);
            data.func_74768_a("toCool", this.amountToCool);
            data.func_74768_a("delay", this.tickDelay);
            INBTPacketReceiver.networkPack(this, data, 25);
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[1].getFill() <= 0) continue;
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.tanks[0].readFromNBT(nbt, "0");
        this.tanks[1].readFromNBT(nbt, "1");
        this.heatEnergy = nbt.func_74762_e("heat");
        this.amountToCool = nbt.func_74762_e("toCool");
        this.tickDelay = nbt.func_74762_e("delay");
    }

    protected void setupTanks() {
        FT_Coolable trait;
        if (this.tanks[0].getTankType().hasTrait(FT_Coolable.class) && (trait = this.tanks[0].getTankType().getTrait(FT_Coolable.class)).getEfficiency(FT_Coolable.CoolingType.HEATEXCHANGER) > 0.0) {
            this.tanks[1].setTankType(trait.coolsTo);
            return;
        }
        this.tanks[0].setTankType(Fluids.NONE);
        this.tanks[1].setTankType(Fluids.NONE);
    }

    protected void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    protected void tryConvert() {
        if (!this.tanks[0].getTankType().hasTrait(FT_Coolable.class)) {
            return;
        }
        if (this.tickDelay < 1) {
            this.tickDelay = 1;
        }
        if (this.field_145850_b.func_82737_E() % (long)this.tickDelay != 0L) {
            return;
        }
        FT_Coolable trait = this.tanks[0].getTankType().getTrait(FT_Coolable.class);
        int inputOps = this.tanks[0].getFill() / trait.amountReq;
        int outputOps = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / trait.amountProduced;
        int opCap = this.amountToCool;
        int ops = Math.min(inputOps, Math.min(outputOps, opCap));
        this.tanks[0].setFill(this.tanks[0].getFill() - trait.amountReq * ops);
        this.tanks[1].setFill(this.tanks[1].getFill() + trait.amountProduced * ops);
        this.heatEnergy = (int)((double)this.heatEnergy + (double)(trait.heatEnergy * ops) * trait.getEfficiency(FT_Coolable.CoolingType.HEATEXCHANGER));
        this.markChanged();
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ, dir.getOpposite())};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "0");
        this.tanks[1].readFromNBT(nbt, "1");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
        this.amountToCool = nbt.func_74762_e("toCool");
        this.tickDelay = nbt.func_74762_e("delay");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "0");
        this.tanks[1].writeToNBT(nbt, "1");
        nbt.func_74768_a("heatEnergy", this.heatEnergy);
        nbt.func_74768_a("toCool", this.amountToCool);
        nbt.func_74768_a("delay", this.tickDelay);
    }

    @Override
    public int getHeatStored() {
        return this.heatEnergy;
    }

    @Override
    public void useUpHeat(int heat) {
        this.heatEnergy = Math.max(0, this.heatEnergy - heat);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        ForgeDirection facing = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return dir == facing || dir == facing.getOpposite();
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerHeaterHeatex(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIHeaterHeatex(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 16.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toCool")) {
            this.amountToCool = Math.max(data.func_74762_e("toCool"), 1);
        }
        if (data.func_74764_b("delay")) {
            this.tickDelay = Math.max(data.func_74762_e("delay"), 1);
        }
        this.markChanged();
    }
}

