/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.container.ContainerFirebox;
import com.hbm.inventory.gui.GUIFirebox;
import com.hbm.module.ModuleBurnTime;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.machine.TileEntityFireboxBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class TileEntityHeaterFirebox
extends TileEntityFireboxBase
implements IConfigurableMachine {
    public static int baseHeat = 100;
    public static double timeMult = 1.0;
    public static int maxHeatEnergy = 100000;
    public static ModuleBurnTime burnModule = new ModuleBurnTime().setLigniteTimeMod(1.25).setCoalTimeMod(1.25).setCokeTimeMod(1.25).setSolidTimeMod(1.5).setRocketTimeMod(1.5).setBalefireTimeMod(0.5).setLigniteHeatMod(2.0).setCoalHeatMod(2.0).setCokeHeatMod(2.0).setSolidHeatMod(3.0).setRocketHeatMod(5.0).setBalefireHeatMod(15.0);
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation texture;

    @Override
    public String getName() {
        return "container.heaterFirebox";
    }

    @Override
    public ModuleBurnTime getModule() {
        return burnModule;
    }

    @Override
    public int getBaseHeat() {
        return baseHeat;
    }

    @Override
    public double getTimeMult() {
        return timeMult;
    }

    @Override
    public int getMaxHeat() {
        return maxHeatEnergy;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFirebox(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (this.texture == null) {
            this.texture = new ResourceLocation("hbm:textures/gui/machine/gui_firebox.png");
        }
        return new GUIFirebox(player.field_71071_by, this, this.texture);
    }

    @Override
    public String getConfigName() {
        return "firebox";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        baseHeat = IConfigurableMachine.grab(obj, "I:baseHeat", baseHeat);
        timeMult = IConfigurableMachine.grab(obj, "D:burnTimeMult", timeMult);
        maxHeatEnergy = IConfigurableMachine.grab(obj, "I:heatCap", maxHeatEnergy);
        if (obj.has("burnModule")) {
            burnModule.readIfPresent(obj.get("M:burnModule").getAsJsonObject());
        }
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:baseHeat").value((long)baseHeat);
        writer.name("D:burnTimeMult").value(timeMult);
        writer.name("I:heatCap").value((long)maxHeatEnergy);
        writer.name("M:burnModule").beginObject();
        burnModule.writeConfig(writer);
        writer.endObject();
    }
}

