/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import api.hbm.tile.IHeatSource;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHeaterElectric
extends TileEntityLoadedBase
implements IHeatSource,
IEnergyUser,
INBTPacketReceiver {
    public long power;
    public int heatEnergy;
    public boolean isOn;
    protected int setting = 0;
    private AudioWrapper audio;
    AxisAlignedBB bb = null;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3, dir);
            }
            this.heatEnergy = (int)((double)this.heatEnergy * 0.999);
            this.tryPullHeat();
            this.isOn = false;
            if (this.setting > 0 && this.power >= this.getConsumption()) {
                this.power -= this.getConsumption();
                this.heatEnergy += this.getHeatGen();
                this.isOn = true;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("s", (byte)this.setting);
            data.func_74768_a("h", this.heatEnergy);
            data.func_74757_a("o", this.isOn);
            INBTPacketReceiver.networkPack(this, data, 25);
        } else if (this.isOn) {
            if (this.audio == null) {
                this.audio = this.createAudioLoop();
                this.audio.startSound();
            } else if (!this.audio.isPlaying()) {
                this.audio = this.rebootAudio(this.audio);
            }
            this.audio.keepAlive();
        } else if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.electricHum", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.25f, 7.5f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.setting = nbt.func_74771_c("s");
        this.heatEnergy = nbt.func_74762_e("h");
        this.isOn = nbt.func_74767_n("o");
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.setting = nbt.func_74762_e("setting");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("setting", this.setting);
        nbt.func_74768_a("heatEnergy", this.heatEnergy);
    }

    protected void tryPullHeat() {
        TileEntity con = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            this.heatEnergy = (int)((double)this.heatEnergy + (double)source.getHeatStored() * 0.85);
            source.useUpHeat(source.getHeatStored());
        }
    }

    public void toggleSetting() {
        ++this.setting;
        if (this.setting > 10) {
            this.setting = 0;
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    public long getConsumption() {
        return (long)(Math.pow(this.setting, 1.4) * 200.0);
    }

    @Override
    public long getMaxPower() {
        return this.getConsumption() * 20L;
    }

    public int getHeatGen() {
        return this.setting * 100;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public int getHeatStored() {
        return this.heatEnergy;
    }

    @Override
    public void useUpHeat(int heat) {
        this.heatEnergy = Math.max(0, this.heatEnergy - heat);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

