/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerFurnaceIron;
import com.hbm.inventory.gui.GUIFurnaceIron;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.module.ModuleBurnTime;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFurnaceIron
extends TileEntityMachineBase
implements IGUIProvider {
    public int maxBurnTime;
    public int burnTime;
    public boolean wasOn = false;
    public int progress;
    public int processingTime;
    public static final int baseTime = 200;
    public ModuleBurnTime burnModule = new ModuleBurnTime().setLigniteTimeMod(1.25).setCoalTimeMod(1.25).setCokeTimeMod(1.5).setSolidTimeMod(2.0).setRocketTimeMod(2.0).setBalefireTimeMod(2.0);
    AxisAlignedBB bb = null;

    public TileEntityFurnaceIron() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.furnaceIron";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            UpgradeManager.eval(this.slots, 4, 4);
            this.processingTime = 200 - 100 * Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3) / 3;
            this.wasOn = false;
            if (this.burnTime <= 0) {
                for (int i = 1; i < 3; ++i) {
                    int fuel;
                    if (this.slots[i] == null || (fuel = this.burnModule.getBurnTime(this.slots[i])) <= 0) continue;
                    this.maxBurnTime = this.burnTime = fuel;
                    --this.slots[i].field_77994_a;
                    if (this.slots[i].field_77994_a != 0) break;
                    this.slots[i] = this.slots[i].func_77973_b().getContainerItem(this.slots[i]);
                    break;
                }
            }
            if (this.canSmelt()) {
                this.wasOn = true;
                ++this.progress;
                --this.burnTime;
                if (this.progress % 15 == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "fire.fire", 1.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
                }
                if (this.progress >= this.processingTime) {
                    ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
                    if (this.slots[3] == null) {
                        this.slots[3] = result.func_77946_l();
                    } else {
                        this.slots[3].field_77994_a += result.field_77994_a;
                    }
                    this.func_70298_a(0, 1);
                    this.progress = 0;
                    this.func_70296_d();
                }
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.04f);
                }
            } else {
                this.progress = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("maxBurnTime", this.maxBurnTime);
            data.func_74768_a("burnTime", this.burnTime);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("processingTime", this.processingTime);
            data.func_74757_a("wasOn", this.wasOn);
            this.networkPack(data, 50);
        } else if (this.progress > 0) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            double offset = this.progress % 2 == 0 ? 1.0 : 0.5;
            this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 - (double)dir.offsetX * offset - (double)rot.offsetX * 0.1875, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5 - (double)dir.offsetZ * offset - (double)rot.offsetZ * 0.1875, 0.0, 0.01, 0.0);
            if (this.progress % 5 == 0) {
                double rand = this.field_145850_b.field_73012_v.nextDouble();
                this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 0.25 + (double)rot.offsetX * rand, (double)this.field_145848_d + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.25, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 0.25 + (double)rot.offsetZ * rand, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.maxBurnTime = nbt.func_74762_e("maxBurnTime");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.progress = nbt.func_74762_e("progress");
        this.processingTime = nbt.func_74762_e("processingTime");
        this.wasOn = nbt.func_74767_n("wasOn");
    }

    public boolean canSmelt() {
        if (this.burnTime <= 0) {
            return false;
        }
        if (this.slots[0] == null) {
            return false;
        }
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
        if (result == null) {
            return false;
        }
        if (this.slots[3] == null) {
            return true;
        }
        if (!result.func_77969_a(this.slots[3])) {
            return false;
        }
        return result.field_77994_a + this.slots[3].field_77994_a <= this.slots[3].func_77976_d();
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{0, 1, 2, 3};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0) {
            return FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null;
        }
        if (i < 3) {
            return this.burnModule.getBurnTime(itemStack) > 0;
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.maxBurnTime = nbt.func_74762_e("maxBurnTime");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("maxBurnTime", this.maxBurnTime);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("progress", this.progress);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFurnaceIron(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFurnaceIron(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

