/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.ICrucibleAcceptor;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityFoundryBase
extends TileEntity
implements ICrucibleAcceptor {
    public NTMMaterial type;
    protected NTMMaterial lastType;
    public int amount;
    protected int lastAmount;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            if (this.shouldClientReRender() && this.lastType != this.type || this.lastAmount != this.amount) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.lastType = this.type;
                this.lastAmount = this.amount;
            }
        } else if (this.lastType != this.type || this.lastAmount != this.amount) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.lastType = this.type;
            this.lastAmount = this.amount;
        }
    }

    protected boolean shouldClientReRender() {
        return true;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = Mats.matById.get(nbt.func_74762_e("type"));
        this.amount = nbt.func_74762_e("amount");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.type == null) {
            nbt.func_74768_a("type", -1);
        } else {
            nbt.func_74768_a("type", this.type.id);
        }
        nbt.func_74768_a("amount", this.amount);
    }

    public abstract int getCapacity();

    public boolean standardCheck(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        if (this.type != null && this.type != stack.material && this.amount > 0) {
            return false;
        }
        return this.amount < this.getCapacity();
    }

    public Mats.MaterialStack standardAdd(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        this.type = stack.material;
        if (stack.amount + this.amount <= this.getCapacity()) {
            this.amount += stack.amount;
            return null;
        }
        int required = this.getCapacity() - this.amount;
        this.amount = this.getCapacity();
        stack.amount -= required;
        return stack;
    }

    @Override
    public boolean canAcceptPartialFlow(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        return this.standardCheck(world, x, y, z, side, stack);
    }

    @Override
    public Mats.MaterialStack flow(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        return this.standardAdd(world, x, y, z, side, stack);
    }

    @Override
    public boolean canAcceptPartialPour(World world, int x, int y, int z, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        if (side != ForgeDirection.UP) {
            return false;
        }
        return this.standardCheck(world, x, y, z, side, stack);
    }

    @Override
    public Mats.MaterialStack pour(World world, int x, int y, int z, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        return this.standardAdd(world, x, y, z, side, stack);
    }
}

