/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityCloudFleijaRainbow;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.inventory.container.ContainerCore;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUICore;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCatalyst;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ArmorUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityCore
extends TileEntityMachineBase
implements IGUIProvider {
    public int field;
    public int heat;
    public int color;
    public FluidTank[] tanks = new FluidTank[2];
    private boolean lastTickValid = false;
    public boolean meltdownTick = false;
    AxisAlignedBB bb = null;

    public TileEntityCore() {
        super(3);
        this.tanks[0] = new FluidTank(Fluids.DEUTERIUM, 128000, 0);
        this.tanks[1] = new FluidTank(Fluids.TRITIUM, 128000, 1);
    }

    @Override
    public String getName() {
        return "container.dfcCore";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int chunkX = this.field_145851_c >> 4;
            int chunkZ = this.field_145849_e >> 4;
            this.meltdownTick = false;
            boolean bl = this.lastTickValid = this.field_145850_b.func_72863_F().func_73149_a(chunkX, chunkZ) && this.field_145850_b.func_72863_F().func_73149_a(chunkX + 1, chunkZ + 1) && this.field_145850_b.func_72863_F().func_73149_a(chunkX + 1, chunkZ - 1) && this.field_145850_b.func_72863_F().func_73149_a(chunkX - 1, chunkZ + 1) && this.field_145850_b.func_72863_F().func_73149_a(chunkX - 1, chunkZ - 1);
            if (this.lastTickValid && this.heat > 0 && this.heat >= this.field) {
                int fill = this.tanks[0].getFill() + this.tanks[1].getFill();
                int max = this.tanks[0].getMaxFill() + this.tanks[1].getMaxFill();
                int mod = this.heat * 10;
                int size = Math.max(Math.min(fill * mod / max, 1000), 50);
                boolean canExplode = true;
                Iterator<Map.Entry<EntityNukeExplosionMK3.ATEntry, Long>> it = EntityNukeExplosionMK3.at.entrySet().iterator();
                while (it.hasNext()) {
                    Vec3 vec;
                    Map.Entry<EntityNukeExplosionMK3.ATEntry, Long> next = it.next();
                    if (next.getValue() < this.field_145850_b.func_82737_E()) {
                        it.remove();
                        continue;
                    }
                    EntityNukeExplosionMK3.ATEntry entry = next.getKey();
                    if (entry.dim != this.field_145850_b.field_73011_w.field_76574_g || !((vec = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5 - (double)entry.x), (double)((double)this.field_145848_d + 0.5 - (double)entry.y), (double)((double)this.field_145849_e + 0.5 - (double)entry.z))).func_72433_c() < 300.0)) continue;
                    canExplode = false;
                    break;
                }
                if (canExplode) {
                    EntityNukeExplosionMK3 ex = new EntityNukeExplosionMK3(this.field_145850_b);
                    ex.field_70165_t = (double)this.field_145851_c + 0.5;
                    ex.field_70163_u = (double)this.field_145848_d + 0.5;
                    ex.field_70161_v = (double)this.field_145849_e + 0.5;
                    ex.destructionRange = size;
                    ex.speed = BombConfig.blastSpeed;
                    ex.coefficient = 1.0f;
                    ex.waste = false;
                    this.field_145850_b.func_72838_d((Entity)ex);
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.explode", 100000.0f, 1.0f);
                    EntityCloudFleijaRainbow cloud = new EntityCloudFleijaRainbow(this.field_145850_b, size);
                    cloud.field_70165_t = this.field_145851_c;
                    cloud.field_70163_u = this.field_145848_d;
                    cloud.field_70161_v = this.field_145849_e;
                    this.field_145850_b.func_72838_d((Entity)cloud);
                } else {
                    this.meltdownTick = true;
                    ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 100.0f);
                }
            }
            this.color = this.slots[0] != null && this.slots[2] != null && this.slots[0].func_77973_b() instanceof ItemCatalyst && this.slots[2].func_77973_b() instanceof ItemCatalyst ? this.calcAvgHex(((ItemCatalyst)this.slots[0].func_77973_b()).getColor(), ((ItemCatalyst)this.slots[2].func_77973_b()).getColor()) : 0;
            if (this.heat > 0) {
                this.radiation();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("tank0", this.tanks[0].getTankType().ordinal());
            data.func_74768_a("tank1", this.tanks[1].getTankType().ordinal());
            data.func_74768_a("fill0", this.tanks[0].getFill());
            data.func_74768_a("fill1", this.tanks[1].getFill());
            data.func_74768_a("field", this.field);
            data.func_74768_a("heat", this.heat);
            data.func_74768_a("color", this.color);
            data.func_74757_a("melt", this.meltdownTick);
            this.networkPack(data, 250);
            this.heat = 0;
            if (this.lastTickValid && this.field > 0) {
                --this.field;
            }
            this.func_70296_d();
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.tanks[0].setTankType(Fluids.fromID(data.func_74762_e("tank0")));
        this.tanks[1].setTankType(Fluids.fromID(data.func_74762_e("tank1")));
        this.tanks[0].setFill(data.func_74762_e("fill0"));
        this.tanks[1].setFill(data.func_74762_e("fill1"));
        this.field = data.func_74762_e("field");
        this.heat = data.func_74762_e("heat");
        this.color = data.func_74762_e("color");
        this.meltdownTick = data.func_74767_n("melt");
    }

    private void radiation() {
        double scale = this.meltdownTick ? 5.0 : 3.0;
        double range = this.meltdownTick ? 50.0 : 10.0;
        List list = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(range, range, range));
        for (Entity e : list) {
            if (e instanceof EntityPlayer && ArmorUtil.checkForHazmat((EntityLivingBase)((EntityPlayer)e)) || Library.isObstructed(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5 + 6.0, (double)this.field_145849_e + 0.5, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) continue;
            e.func_70097_a(ModDamageSource.ams, 1000.0f);
            e.func_70015_d(3);
        }
        List list2 = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(scale, scale, scale));
        for (Entity e : list2) {
            if (e instanceof EntityPlayer && ArmorUtil.checkForHaz2((EntityLivingBase)((EntityPlayer)e))) continue;
            e.func_70097_a(ModDamageSource.amsCore, 10000.0f);
        }
    }

    public int getFieldScaled(int i) {
        return this.field * i / 100;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 100;
    }

    public boolean isReady() {
        if (!this.lastTickValid) {
            return false;
        }
        if (this.getCore() == 0) {
            return false;
        }
        if (this.color == 0) {
            return false;
        }
        return !(this.getFuelEfficiency(this.tanks[0].getTankType()) <= 0.0f) && !(this.getFuelEfficiency(this.tanks[1].getTankType()) <= 0.0f);
    }

    public long burn(long joules) {
        if (!this.isReady()) {
            return joules;
        }
        int demand = (int)Math.ceil((double)joules / 1000.0);
        if (this.tanks[0].getFill() < demand || this.tanks[1].getFill() < demand) {
            return joules;
        }
        this.heat += (int)Math.ceil((double)joules / 10000.0);
        this.tanks[0].setFill(this.tanks[0].getFill() - demand);
        this.tanks[1].setFill(this.tanks[1].getFill() - demand);
        return (long)((float)(joules * (long)this.getCore()) * this.getFuelEfficiency(this.tanks[0].getTankType()) * this.getFuelEfficiency(this.tanks[1].getTankType()));
    }

    public float getFuelEfficiency(FluidType type) {
        if (type == Fluids.HYDROGEN) {
            return 1.0f;
        }
        if (type == Fluids.DEUTERIUM) {
            return 1.5f;
        }
        if (type == Fluids.TRITIUM) {
            return 1.7f;
        }
        if (type == Fluids.OXYGEN) {
            return 1.2f;
        }
        if (type == Fluids.ACID) {
            return 1.4f;
        }
        if (type == Fluids.XENON) {
            return 1.5f;
        }
        if (type == Fluids.SAS3) {
            return 2.0f;
        }
        if (type == Fluids.BALEFIRE) {
            return 2.5f;
        }
        if (type == Fluids.AMAT) {
            return 2.2f;
        }
        if (type == Fluids.ASCHRAB) {
            return 2.7f;
        }
        return 0.0f;
    }

    public int getCore() {
        if (this.slots[1] == null) {
            return 0;
        }
        if (this.slots[1].func_77973_b() == ModItems.ams_core_sing) {
            return 500;
        }
        if (this.slots[1].func_77973_b() == ModItems.ams_core_wormhole) {
            return 650;
        }
        if (this.slots[1].func_77973_b() == ModItems.ams_core_eyeofharmony) {
            return 800;
        }
        if (this.slots[1].func_77973_b() == ModItems.ams_core_thingy) {
            return 2500;
        }
        return 0;
    }

    private int calcAvgHex(int h1, int h2) {
        int r1 = (h1 & 0xFF0000) >> 16;
        int g1 = (h1 & 0xFF00) >> 8;
        int b1 = (h1 & 0xFF) >> 0;
        int r2 = (h2 & 0xFF0000) >> 16;
        int g2 = (h2 & 0xFF00) >> 8;
        int b2 = (h2 & 0xFF) >> 0;
        int r = (r1 + r2) / 2 << 16;
        int g = (g1 + g2) / 2 << 8;
        int b = (b1 + b2) / 2 << 0;
        return r | g | b;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "fuel1");
        this.tanks[1].readFromNBT(nbt, "fuel2");
        this.field = nbt.func_74762_e("field");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "fuel1");
        this.tanks[1].writeToNBT(nbt, "fuel2");
        nbt.func_74768_a("field", this.field);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - 4.0), (double)((double)this.field_145848_d + 0.5 - 4.0), (double)((double)this.field_145849_e + 0.5 - 4.0), (double)((double)this.field_145851_c + 0.5 + 5.0), (double)((double)this.field_145848_d + 0.5 + 5.0), (double)((double)this.field_145849_e + 0.5 + 5.0));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCore(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICore(player.field_71071_by, this);
    }
}

