/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.lib.Library;
import com.hbm.saveddata.TomSaveData;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCondenser
extends TileEntityLoadedBase
implements IFluidAcceptor,
IFluidSource,
IFluidStandardTransceiver,
INBTPacketReceiver {
    public int age = 0;
    public FluidTank[] tanks;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();
    public int waterTimer = 0;

    public TileEntityCondenser() {
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.SPENTSTEAM, 100, 0);
        this.tanks[1] = new FluidTank(Fluids.WATER, 100, 1);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 2) {
                this.age = 0;
            }
            if (this.waterTimer > 0) {
                --this.waterTimer;
            }
            int convert = Math.min(this.tanks[0].getFill(), this.tanks[1].getMaxFill() - this.tanks[1].getFill());
            this.tanks[0].setFill(this.tanks[0].getFill() - convert);
            if (convert > 0) {
                this.waterTimer = 20;
            }
            int light = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if ((double)TomSaveData.forWorld((World)this.field_145850_b).fire > 1.0E-5 && light > 7) {
                this.tanks[1].setFill(this.tanks[1].getFill() - convert);
            } else {
                this.tanks[1].setFill(this.tanks[1].getFill() + convert);
            }
            this.subscribeToAllAround(this.tanks[0].getTankType(), this);
            this.sendFluidToAll(this.tanks[1], this);
            this.fillFluidInit(this.tanks[1].getTankType());
            NBTTagCompound data = new NBTTagCompound();
            this.tanks[0].writeToNBT(data, "0");
            this.tanks[1].writeToNBT(data, "1");
            data.func_74774_a("timer", (byte)this.waterTimer);
            INBTPacketReceiver.networkPack(this, data, 150);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.tanks[0].readFromNBT(nbt, "0");
        this.tanks[1].readFromNBT(nbt, "1");
        this.waterTimer = nbt.func_74771_c("timer");
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
    }

    @Override
    public void fillFluidInit(FluidType type) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.fillFluid(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, this.getTact(), type);
        }
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age == 0;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidType type) {
        this.list.clear();
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }
}

