/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.lib.Library;
import com.hbm.packet.NBTPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChungus
extends TileEntityLoadedBase
implements IFluidAcceptor,
IFluidSource,
IEnergyGenerator,
INBTPacketReceiver,
IFluidStandardTransceiver {
    public long power;
    public static final long maxPower = 100000000000L;
    private int turnTimer;
    public float rotor;
    public float lastRotor;
    public float fanAcceleration = 0.0f;
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks = new FluidTank[2];

    public TileEntityChungus() {
        this.tanks[0] = new FluidTank(Fluids.STEAM, 1000000000, 0);
        this.tanks[1] = new FluidTank(Fluids.SPENTSTEAM, 1000000000, 1);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            FT_Coolable trait;
            double eff;
            boolean operational = false;
            FluidType in = this.tanks[0].getTankType();
            boolean valid = false;
            if (in.hasTrait(FT_Coolable.class) && (eff = (trait = in.getTrait(FT_Coolable.class)).getEfficiency(FT_Coolable.CoolingType.TURBINE) * 0.85) > 0.0) {
                this.tanks[1].setTankType(trait.coolsTo);
                int inputOps = this.tanks[0].getFill() / trait.amountReq;
                int outputOps = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / trait.amountProduced;
                int ops = Math.min(inputOps, outputOps);
                this.tanks[0].setFill(this.tanks[0].getFill() - ops * trait.amountReq);
                this.tanks[1].setFill(this.tanks[1].getFill() + ops * trait.amountProduced);
                this.power = (long)((double)this.power + (double)(ops * trait.heatEnergy) * eff);
                valid = true;
                boolean bl = operational = ops > 0;
            }
            if (!valid) {
                this.tanks[1].setTankType(Fluids.NONE);
            }
            if (this.power > 100000000000L) {
                this.power = 100000000000L;
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            this.sendPower(this.field_145850_b, this.field_145851_c - dir.offsetX * 11, this.field_145848_d, this.field_145849_e - dir.offsetZ * 11, dir.getOpposite());
            for (DirPos pos : this.getConPos()) {
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.power > 100000000000L) {
                this.power = 100000000000L;
            }
            --this.turnTimer;
            if (operational) {
                this.turnTimer = 25;
            }
            this.fillFluidInit(this.tanks[1].getTankType());
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("type", this.tanks[0].getTankType().getID());
            data.func_74768_a("operational", this.turnTimer);
            this.networkPack(data, 150);
        } else {
            this.lastRotor = this.rotor;
            this.rotor += this.fanAcceleration;
            if (this.rotor >= 360.0f) {
                this.rotor -= 360.0f;
                this.lastRotor -= 360.0f;
            }
            if (this.turnTimer > 0) {
                this.fanAcceleration = Math.max(0.0f, Math.min(25.0f, this.fanAcceleration += 0.1f));
                Random rand = this.field_145850_b.field_73012_v;
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                ForgeDirection side = dir.getRotation(ForgeDirection.UP);
                for (int i = 0; i < 10; ++i) {
                    this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * (rand.nextDouble() + 1.25) + rand.nextGaussian() * (double)side.offsetX * 0.65, (double)this.field_145848_d + 2.5 + rand.nextGaussian() * 0.65, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * (rand.nextDouble() + 1.25) + rand.nextGaussian() * (double)side.offsetZ * 0.65, (double)(-dir.offsetX) * 0.2, 0.0, (double)(-dir.offsetZ) * 0.2);
                }
            }
            if (this.turnTimer < 0) {
                this.fanAcceleration = Math.max(0.0f, Math.min(25.0f, this.fanAcceleration -= 0.1f));
            }
        }
    }

    public void onLeverPull(FluidType previous) {
        for (DirPos pos : this.getConPos()) {
            this.tryUnsubscribe(previous, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 5, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 5, dir), new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ * 3, rot.getOpposite())};
    }

    public void networkPack(NBTTagCompound nbt, int range) {
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new NBTPacket(nbt, this.field_145851_c, this.field_145848_d, this.field_145849_e), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)range));
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.turnTimer = data.func_74762_e("operational");
        this.tanks[0].setTankType(Fluids.fromID(data.func_74762_e("type")));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.power = nbt.func_74763_f("power");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        nbt.func_74772_a("power", this.power);
    }

    @Override
    public void fillFluidInit(FluidType type) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        dir = dir.getRotation(ForgeDirection.UP);
        this.fillFluid(this.field_145851_c + dir.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3, this.getTact(), type);
        this.fillFluid(this.field_145851_c + dir.offsetX * -3, this.field_145848_d, this.field_145849_e + dir.offsetZ * -3, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.field_145850_b.func_82737_E() % 2L == 0L;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type == this.tanks[0].getTankType()) {
            this.tanks[0].setFill(i);
        } else if (type == this.tanks[1].getTankType()) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidType type) {
        if (type == this.tanks[0].getTankType()) {
            return this.tanks[0].getFill();
        }
        if (type == this.tanks[1].getTankType()) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (type == this.tanks[0].getTankType()) {
            return this.tanks[0].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        return this.list2;
    }

    @Override
    public void clearFluidList(FluidType type) {
        this.list2.clear();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP && dir != ForgeDirection.DOWN && dir != ForgeDirection.UNKNOWN;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000000000L;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }
}

