/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidUser;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChimneyBrick
extends TileEntityLoadedBase
implements IFluidUser,
INBTPacketReceiver {
    public int onTicks;
    AxisAlignedBB bb = null;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                FluidType[] types;
                for (FluidType type : types = new FluidType[]{Fluids.SMOKE, Fluids.SMOKE_LEADED, Fluids.SMOKE_POISON}) {
                    this.trySubscribe(type, this.field_145850_b, this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X);
                    this.trySubscribe(type, this.field_145850_b, this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X);
                    this.trySubscribe(type, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z);
                    this.trySubscribe(type, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z);
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("onTicks", this.onTicks);
            INBTPacketReceiver.networkPack(this, data, 150);
            if (this.onTicks > 0) {
                --this.onTicks;
            }
        } else if (this.onTicks > 0 && this.field_145850_b.func_82737_E() % 2L == 0L) {
            NBTTagCompound fx = new NBTTagCompound();
            fx.func_74778_a("type", "tower");
            fx.func_74776_a("lift", 10.0f);
            fx.func_74776_a("base", 0.5f);
            fx.func_74776_a("max", 3.0f);
            fx.func_74768_a("life", 250 + this.field_145850_b.field_73012_v.nextInt(50));
            fx.func_74768_a("color", 0x404040);
            fx.func_74780_a("posX", (double)this.field_145851_c + 0.5);
            fx.func_74780_a("posY", (double)(this.field_145848_d + 12));
            fx.func_74780_a("posZ", (double)this.field_145849_e + 0.5);
            MainRegistry.proxy.effectNT(fx);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.onTicks = nbt.func_74762_e("onTicks");
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return !(dir != ForgeDirection.NORTH && dir != ForgeDirection.SOUTH && dir != ForgeDirection.EAST && dir != ForgeDirection.WEST || type != Fluids.SMOKE && type != Fluids.SMOKE_LEADED && type != Fluids.SMOKE_POISON);
    }

    @Override
    public long transferFluid(FluidType type, int pressure, long fluid) {
        this.onTicks = 20;
        fluid = (long)((double)fluid * 0.25);
        if (type == Fluids.SMOKE) {
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, (float)fluid / 100.0f);
        }
        if (type == Fluids.SMOKE_LEADED) {
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.HEAVYMETAL, (float)fluid / 100.0f);
        }
        if (type == Fluids.SMOKE_POISON) {
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.POISON, (float)fluid / 100.0f);
        }
        return 0L;
    }

    @Override
    public long getDemand(FluidType type, int pressure) {
        return 1000000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[0];
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 13), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

