/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.container.ContainerAshpit;
import com.hbm.inventory.gui.GUIAshpit;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityAshpit
extends TileEntityMachineBase
implements IGUIProvider {
    private int playersUsing = 0;
    public float doorAngle = 0.0f;
    public float prevDoorAngle = 0.0f;
    public boolean isFull;
    public int ashLevelWood;
    public int ashLevelCoal;
    public int ashLevelMisc;
    AxisAlignedBB bb = null;

    public TileEntityAshpit() {
        super(5);
    }

    @Override
    public void func_70295_k_() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.playersUsing;
        }
    }

    @Override
    public void func_70305_f() {
        if (!this.field_145850_b.field_72995_K) {
            --this.playersUsing;
        }
    }

    @Override
    public String getName() {
        return "container.ashpit";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int threshold = 2000;
            if (this.processAsh(this.ashLevelWood, ItemEnums.EnumAshType.WOOD, threshold)) {
                this.ashLevelWood -= threshold;
            }
            if (this.processAsh(this.ashLevelCoal, ItemEnums.EnumAshType.COAL, threshold)) {
                this.ashLevelCoal -= threshold;
            }
            if (this.processAsh(this.ashLevelMisc, ItemEnums.EnumAshType.MISC, threshold)) {
                this.ashLevelMisc -= threshold;
            }
            this.isFull = false;
            for (int i = 0; i < 5; ++i) {
                if (this.slots[i] == null) continue;
                this.isFull = true;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("playersUsing", this.playersUsing);
            data.func_74757_a("isFull", this.isFull);
            this.networkPack(data, 50);
        } else {
            this.prevDoorAngle = this.doorAngle;
            float swingSpeed = this.doorAngle / 10.0f + 3.0f;
            this.doorAngle = this.playersUsing > 0 ? (this.doorAngle += swingSpeed) : (this.doorAngle -= swingSpeed);
            this.doorAngle = MathHelper.func_76131_a((float)this.doorAngle, (float)0.0f, (float)135.0f);
        }
    }

    protected boolean processAsh(int level, ItemEnums.EnumAshType type, int threshold) {
        if (level >= threshold) {
            for (int i = 0; i < 5; ++i) {
                if (this.slots[i] == null) {
                    this.slots[i] = OreDictManager.DictFrame.fromOne(ModItems.powder_ash, (Enum)type);
                    this.ashLevelWood -= threshold;
                    return true;
                }
                if (this.slots[i].field_77994_a >= this.slots[i].func_77976_d() || this.slots[i].func_77973_b() != ModItems.powder_ash || this.slots[i].func_77960_j() != type.ordinal()) continue;
                ++this.slots[i].field_77994_a;
                return true;
            }
        }
        return false;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.playersUsing = nbt.func_74762_e("playersUsing");
        this.isFull = nbt.func_74767_n("isFull");
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{0, 1, 2, 3, 4};
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ashLevelWood = nbt.func_74762_e("ashLevelWood");
        this.ashLevelCoal = nbt.func_74762_e("ashLevelCoal");
        this.ashLevelMisc = nbt.func_74762_e("ashLevelMisc");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("ashLevelWood", this.ashLevelWood);
        nbt.func_74768_a("ashLevelCoal", this.ashLevelCoal);
        nbt.func_74768_a("ashLevelMisc", this.ashLevelMisc);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerAshpit(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIAshpit(player.field_71071_by, this);
    }
}

