/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.explosion.ExplosionLarge;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.inventory.container.ContainerAMSLimiter;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIAMSLimiter;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.util.ParticleUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityAMSLimiter
extends TileEntity
implements ISidedInventory,
IFluidContainer,
IFluidAcceptor,
IGUIProvider {
    private ItemStack[] slots;
    public long power = 0L;
    public static final long maxPower = 10000000L;
    public int efficiency = 0;
    public static final int maxEfficiency = 100;
    public int heat = 0;
    public static final int maxHeat = 2500;
    public int age = 0;
    public int warning = 0;
    public int mode = 0;
    public boolean locked = false;
    public FluidTank tank;
    Random rand = new Random();
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0};
    private static final int[] slots_side = new int[]{0};
    private String customName;

    public TileEntityAMSLimiter() {
        this.slots = new ItemStack[4];
        this.tank = new FluidTank(Fluids.COOLANT, 8000, 0);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.amsLimiter";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.tank.readFromNBT(nbt, "coolant");
        this.efficiency = nbt.func_74762_e("efficiency");
        this.heat = nbt.func_74762_e("heat");
        this.locked = nbt.func_74767_n("locked");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tank.writeToNBT(nbt, "coolant");
        nbt.func_74768_a("efficiency", this.efficiency);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74757_a("locked", this.locked);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.locked) {
                this.tank.setType(0, 1, this.slots);
                this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
                if (this.power > 0L) {
                    this.efficiency = Math.round(this.calcEffect(this.power, this.heat - 1250) * 100.0f);
                    this.power = (long)((double)this.power - Math.ceil((double)this.power * 0.025));
                    this.warning = 0;
                } else {
                    this.efficiency = 0;
                    this.warning = 1;
                }
                if (this.tank.getTankType() == Fluids.CRYOGEL) {
                    if (this.tank.getFill() >= 5) {
                        int i;
                        if (this.heat > 0) {
                            this.tank.setFill(this.tank.getFill() - 5);
                        }
                        if (this.heat <= 1250) {
                            if (this.efficiency > 0) {
                                this.heat += this.efficiency;
                            } else {
                                for (i = 0; i < 10; ++i) {
                                    if (this.heat <= 0) continue;
                                    --this.heat;
                                }
                            }
                        }
                        for (i = 0; i < 10; ++i) {
                            if (this.heat <= 1250) continue;
                            --this.heat;
                        }
                    } else {
                        this.heat += this.efficiency;
                    }
                } else if (this.tank.getTankType() == Fluids.COOLANT) {
                    if (this.tank.getFill() >= 5) {
                        int i;
                        if (this.heat > 0) {
                            this.tank.setFill(this.tank.getFill() - 5);
                        }
                        if (this.heat <= 625) {
                            if (this.efficiency > 0) {
                                this.heat += this.efficiency;
                            } else {
                                for (i = 0; i < 5; ++i) {
                                    if (this.heat <= 0) continue;
                                    --this.heat;
                                }
                            }
                        }
                        for (i = 0; i < 5; ++i) {
                            if (this.heat <= 625) continue;
                            --this.heat;
                        }
                    } else {
                        this.heat += this.efficiency;
                    }
                } else if (this.tank.getTankType() == Fluids.WATER) {
                    if (this.tank.getFill() >= 15) {
                        int i;
                        if (this.heat > 0) {
                            this.tank.setFill(this.tank.getFill() - 15);
                        }
                        if ((double)this.heat <= 2125.0) {
                            if (this.efficiency > 0) {
                                this.heat += this.efficiency;
                            } else {
                                for (i = 0; i < 2; ++i) {
                                    if (this.heat <= 0) continue;
                                    --this.heat;
                                }
                            }
                        }
                        for (i = 0; i < 2; ++i) {
                            if (!((double)this.heat > 2125.0)) continue;
                            --this.heat;
                        }
                    } else {
                        this.heat += this.efficiency;
                    }
                } else {
                    this.heat += this.efficiency;
                    this.warning = 2;
                }
                this.mode = 0;
                if (this.slots[2] != null) {
                    if (this.slots[2].func_77973_b() == ModItems.ams_focus_limiter) {
                        this.mode = 1;
                    } else if (this.slots[2].func_77973_b() == ModItems.ams_focus_booster) {
                        this.mode = 2;
                    } else {
                        this.efficiency = 0;
                        this.warning = 2;
                    }
                } else {
                    this.efficiency = 0;
                    this.warning = 2;
                }
                if (this.tank.getFill() <= 5 || (double)this.heat > 2250.0) {
                    this.warning = 2;
                }
                if (this.heat > 2500) {
                    this.heat = 2500;
                    this.locked = true;
                    ExplosionLarge.spawnShock(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5, 24, 3.0);
                    ExplosionLarge.spawnBurst(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5, 24, 3.0);
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:entity.oldExplosion", 10.0f, 1.0f);
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.shutdown", 10.0f, 1.0f);
                }
                this.power = Library.chargeTEFromItems(this.slots, 3, this.power, 10000000L);
            } else {
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                double pos = this.rand.nextDouble() * 2.5;
                double off = 0.25;
                if (meta == 2) {
                    ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + 0.5 + off, (double)this.field_145848_d + 5.5, (double)this.field_145849_e + 0.5 - pos, 0.0, 0.0, 0.0);
                }
                if (meta == 3) {
                    ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + 0.5 - off, (double)this.field_145848_d + 5.5, (double)this.field_145849_e + 0.5 + pos, 0.0, 0.0, 0.0);
                }
                if (meta == 4) {
                    ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + 0.5 - pos, (double)this.field_145848_d + 5.5, (double)this.field_145849_e + 0.5 - off, 0.0, 0.0, 0.0);
                }
                if (meta == 5) {
                    ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + 0.5 + pos, (double)this.field_145848_d + 5.5, (double)this.field_145849_e + 0.5 + off, 0.0, 0.0, 0.0);
                }
                this.efficiency = 0;
                this.power = 0L;
                this.warning = 3;
            }
            this.tank.setTankType(Fluids.CRYOGEL);
            this.tank.setFill(this.tank.getMaxFill());
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.locked ? 1 : 0, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 250.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.efficiency, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 250.0));
        }
    }

    private float gauss(float a, float x) {
        double amplifier = 0.1;
        return (float)(1.0 / Math.sqrt((double)a * Math.PI) * Math.pow(Math.E, -1.0 * Math.pow(x, 2.0) / amplifier));
    }

    private float calcEffect(float a, float x) {
        return (float)((double)this.gauss(1.0f / a, x / 2500.0f) * Math.sqrt(Math.PI * 2) / (Math.sqrt(2.0) * Math.sqrt(1.0E7)));
    }

    public long getPowerScaled(long i) {
        return this.power * i / 10000000L;
    }

    public int getEfficiencyScaled(int i) {
        return this.efficiency * i / 100;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 2500;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            this.tank.setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            return this.tank.getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            return this.tank.getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tank.setTankType(type);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerAMSLimiter(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIAMSLimiter(player.field_71071_by, this);
    }
}

