/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import api.hbm.energy.IEnergyUser;
import api.hbm.item.IDesignatorItem;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.bomb.LaunchPad;
import com.hbm.inventory.container.ContainerLaunchPadTier1;
import com.hbm.inventory.gui.GUILaunchPadTier1;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEMissilePacket;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityLaunchPad
extends TileEntityLoadedBase
implements ISidedInventory,
IEnergyUser,
SimpleComponent,
IGUIProvider {
    public ItemStack[] slots = new ItemStack[3];
    public long power;
    public final long maxPower = 100000L;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0, 1, 2};
    private static final int[] slots_side = new int[]{0};
    public int state = 0;
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.launchPad";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        nbt.func_74772_a("power", this.power);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 2, this.power, 100000L);
            this.updateConnections();
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEMissilePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.slots[0]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 250.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    private void updateConnections() {
        this.trySubscribe(this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X);
        this.trySubscribe(this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X);
        this.trySubscribe(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z);
        this.trySubscribe(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z);
        this.trySubscribe(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public long transferPower(long power) {
        this.power += power;
        if (this.power > this.getMaxPower()) {
            long overshoot = this.power - this.getMaxPower();
            this.power = this.getMaxPower();
            return overshoot;
        }
        return 0L;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP && dir != ForgeDirection.UNKNOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public String getComponentName() {
        return "launch_pad";
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoords(Context context, Arguments args) {
        if (this.slots[1] != null && this.slots[1].func_77973_b() instanceof IDesignatorItem) {
            if (this.slots[1].field_77990_d == null) {
                return new Object[]{false};
            }
            int xCoord2 = this.slots[1].field_77990_d.func_74762_e("xCoord");
            int zCoord2 = this.slots[1].field_77990_d.func_74762_e("zCoord");
            return new Object[]{xCoord2, zCoord2};
        }
        return new Object[]{false, "Designator not found"};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setCoords(Context context, Arguments args) {
        if (this.slots[1] != null && this.slots[1].func_77973_b() instanceof IDesignatorItem) {
            this.slots[1].field_77990_d = new NBTTagCompound();
            this.slots[1].field_77990_d.func_74768_a("xCoord", args.checkInteger(0));
            this.slots[1].field_77990_d.func_74768_a("zCoord", args.checkInteger(1));
            return new Object[]{true};
        }
        return new Object[]{false, "Designator not found"};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] launch(Context context, Arguments args) {
        ((LaunchPad)ModBlocks.launch_pad).explode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return new Object[0];
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerLaunchPadTier1(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUILaunchPadTier1(player.field_71071_by, this);
    }
}

