/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidConnector;
import api.hbm.tile.IHeatSource;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.tileentity.TileEntityProxyBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityProxyCombo
extends TileEntityProxyBase
implements IEnergyUser,
IFluidAcceptor,
ISidedInventory,
IFluidConnector,
IHeatSource {
    TileEntity tile;
    boolean inventory;
    boolean power;
    boolean fluid;
    boolean heat;

    public TileEntityProxyCombo() {
    }

    public TileEntityProxyCombo(boolean inventory, boolean power, boolean fluid) {
        this.inventory = inventory;
        this.power = power;
        this.fluid = fluid;
    }

    public TileEntityProxyCombo inventory() {
        this.inventory = true;
        return this;
    }

    public TileEntityProxyCombo power() {
        this.power = true;
        return this;
    }

    public TileEntityProxyCombo fluid() {
        this.fluid = true;
        return this;
    }

    public TileEntityProxyCombo heatSource() {
        this.heat = true;
        return this;
    }

    public TileEntity getTile() {
        if (this.tile == null || this.tile.func_145837_r()) {
            this.tile = this.getTE();
        }
        return this.tile;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        if (!this.fluid) {
            return;
        }
        if (this.getTile() instanceof IFluidContainer) {
            ((IFluidContainer)this.getTile()).setFillForSync(fill, index);
        }
    }

    @Override
    public void setFluidFill(int fill, FluidType type) {
        if (!this.fluid) {
            return;
        }
        if (this.getTile() instanceof IFluidContainer) {
            ((IFluidContainer)this.getTile()).setFluidFill(fill, type);
        }
    }

    @Override
    public int getFluidFillForReceive(FluidType type) {
        if (!this.fluid) {
            return 0;
        }
        if (this.getTile() instanceof IFluidAcceptor) {
            return ((IFluidAcceptor)this.getTile()).getFluidFillForReceive(type);
        }
        return 0;
    }

    @Override
    public int getMaxFluidFillForReceive(FluidType type) {
        if (!this.fluid) {
            return 0;
        }
        if (this.getTile() instanceof IFluidAcceptor) {
            return ((IFluidAcceptor)this.getTile()).getMaxFluidFillForReceive(type);
        }
        return 0;
    }

    @Override
    public void receiveFluid(int amount, FluidType type) {
        if (!this.fluid) {
            return;
        }
        if (this.getTile() instanceof IFluidAcceptor) {
            ((IFluidAcceptor)this.getTile()).receiveFluid(amount, type);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        if (!this.fluid) {
            return;
        }
        if (this.getTile() instanceof IFluidContainer) {
            ((IFluidContainer)this.getTile()).setTypeForSync(type, index);
        }
    }

    @Override
    public int getFluidFill(FluidType type) {
        if (!this.fluid) {
            return 0;
        }
        if (this.getTile() instanceof IFluidContainer) {
            return ((IFluidContainer)this.getTile()).getFluidFill(type);
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (!this.fluid) {
            return 0;
        }
        if (this.getTile() instanceof IFluidAcceptor) {
            return ((IFluidAcceptor)this.getTile()).getMaxFluidFill(type);
        }
        return 0;
    }

    @Override
    public void setPower(long i) {
        if (!this.power) {
            return;
        }
        if (this.getTile() instanceof IEnergyUser) {
            ((IEnergyUser)this.getTile()).setPower(i);
        }
    }

    @Override
    public long getPower() {
        if (!this.power) {
            return 0L;
        }
        if (this.getTile() instanceof IEnergyConnector) {
            return ((IEnergyConnector)this.getTile()).getPower();
        }
        return 0L;
    }

    @Override
    public long getMaxPower() {
        if (!this.power) {
            return 0L;
        }
        if (this.getTile() instanceof IEnergyConnector) {
            return ((IEnergyConnector)this.getTile()).getMaxPower();
        }
        return 0L;
    }

    @Override
    public long transferPower(long power) {
        if (!this.power) {
            return power;
        }
        if (this.getTile() instanceof IEnergyConnector) {
            return ((IEnergyConnector)this.getTile()).transferPower(power);
        }
        return power;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        if (!this.power) {
            return false;
        }
        if (this.getTile() instanceof IEnergyConnector) {
            return ((IEnergyConnector)this.getTile()).canConnect(dir);
        }
        return true;
    }

    public int func_70302_i_() {
        if (!this.inventory) {
            return 0;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int slot) {
        if (!this.inventory) {
            return null;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70301_a(slot);
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70298_a(i, j);
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (!this.inventory) {
            return null;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70304_b(slot);
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.inventory) {
            return;
        }
        if (this.getTile() instanceof ISidedInventory) {
            ((ISidedInventory)this.getTile()).func_70299_a(slot, stack);
        }
    }

    public String func_145825_b() {
        if (!this.inventory) {
            return null;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_145825_b();
        }
        return null;
    }

    public boolean func_145818_k_() {
        if (!this.inventory) {
            return false;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_145818_k_();
        }
        return false;
    }

    public int func_70297_j_() {
        if (!this.inventory) {
            return 0;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70297_j_();
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (!this.inventory) {
            return false;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_70300_a(player);
        }
        return false;
    }

    public void func_70295_k_() {
        if (!this.inventory) {
            return;
        }
        if (this.getTile() instanceof ISidedInventory) {
            ((ISidedInventory)this.getTile()).func_70295_k_();
        }
    }

    public void func_70305_f() {
        if (!this.inventory) {
            return;
        }
        if (this.getTile() instanceof ISidedInventory) {
            ((ISidedInventory)this.getTile()).func_70305_f();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!this.inventory) {
            return false;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_94041_b(slot, stack);
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        if (!this.inventory) {
            return new int[0];
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_94128_d(side);
        }
        return new int[0];
    }

    public boolean func_102007_a(int i, ItemStack stack, int j) {
        if (!this.inventory) {
            return false;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_102007_a(i, stack, j);
        }
        return false;
    }

    public boolean func_102008_b(int i, ItemStack stack, int j) {
        if (!this.inventory) {
            return false;
        }
        if (this.getTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getTile()).func_102008_b(i, stack, j);
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory = nbt.func_74767_n("inv");
        this.power = nbt.func_74767_n("power");
        this.fluid = nbt.func_74767_n("fluid");
        this.heat = nbt.func_74767_n("heat");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("inv", this.inventory);
        nbt.func_74757_a("power", this.power);
        nbt.func_74757_a("fluid", this.fluid);
        nbt.func_74757_a("heat", this.heat);
    }

    @Override
    public long transferFluid(FluidType type, int pressure, long fluid) {
        if (!this.fluid) {
            return fluid;
        }
        if (this.getTile() instanceof IFluidConnector) {
            return ((IFluidConnector)this.getTile()).transferFluid(type, pressure, fluid);
        }
        return fluid;
    }

    @Override
    public long getDemand(FluidType type, int pressure) {
        if (!this.fluid) {
            return 0L;
        }
        if (this.getTile() instanceof IFluidConnector) {
            return ((IFluidConnector)this.getTile()).getDemand(type, pressure);
        }
        return 0L;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        if (!this.fluid) {
            return false;
        }
        if (this.getTile() instanceof IFluidConnector) {
            return ((IFluidConnector)this.getTile()).canConnect(type, dir);
        }
        return true;
    }

    @Override
    public int getHeatStored() {
        if (!this.heat) {
            return 0;
        }
        if (this.getTile() instanceof IHeatSource) {
            return ((IHeatSource)this.getTile()).getHeatStored();
        }
        return 0;
    }

    @Override
    public void useUpHeat(int heat) {
        if (!this.heat) {
            return;
        }
        if (this.getTile() instanceof IHeatSource) {
            ((IHeatSource)this.getTile()).useUpHeat(heat);
        }
    }
}

