/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.Vertex;
import net.minecraftforge.client.model.obj.WavefrontObject;

public class ObjUtil {
    private static int red;
    private static int green;
    private static int blue;
    private static boolean hasColor;

    public static void renderWithIcon(WavefrontObject model, IIcon icon, Tessellator tes, float rot, boolean shadow) {
        ObjUtil.renderWithIcon(model, icon, tes, rot, 0.0f, shadow);
    }

    public static void renderWithIcon(WavefrontObject model, IIcon icon, Tessellator tes, float rot, float pitch, boolean shadow) {
        for (GroupObject go : model.groupObjects) {
            for (Face f : go.faces) {
                Vertex n = f.faceNormal;
                Vec3 normal = Vec3.func_72443_a((double)n.x, (double)n.y, (double)n.z);
                normal.func_72446_c(pitch);
                normal.func_72442_b(rot);
                tes.func_78375_b((float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c);
                if (shadow) {
                    float brightness = ((float)normal.field_72448_b + 0.7f) * 0.9f - (float)Math.abs(normal.field_72450_a) * 0.1f + (float)Math.abs(normal.field_72449_c) * 0.1f;
                    if (brightness < 0.45f) {
                        brightness = 0.45f;
                    }
                    tes.func_78386_a(brightness, brightness, brightness);
                }
                for (int i = 0; i < f.vertices.length; ++i) {
                    Vertex v = f.vertices[i];
                    Vec3 vec = Vec3.func_72443_a((double)v.x, (double)v.y, (double)v.z);
                    vec.func_72446_c(pitch);
                    vec.func_72442_b(rot);
                    float x = (float)vec.field_72450_a;
                    float y = (float)vec.field_72448_b;
                    float z = (float)vec.field_72449_c;
                    TextureCoordinate t = f.textureCoordinates[i];
                    tes.func_78374_a((double)x, (double)y, (double)z, (double)icon.func_94214_a((double)(t.u * 16.0f)), (double)icon.func_94207_b((double)(t.v * 16.0f)));
                    if (i % 3 != 2) continue;
                    tes.func_78374_a((double)x, (double)y, (double)z, (double)icon.func_94214_a((double)(t.u * 16.0f)), (double)icon.func_94207_b((double)(t.v * 16.0f)));
                }
            }
        }
    }

    public static void renderPartWithIcon(WavefrontObject model, String name, IIcon icon, Tessellator tes, float rot, boolean shadow) {
        ObjUtil.renderPartWithIcon(model, name, icon, tes, rot, 0.0f, shadow);
    }

    public static void renderPartWithIcon(WavefrontObject model, String name, IIcon icon, Tessellator tes, float rot, float pitch, boolean shadow) {
        GroupObject go = null;
        for (GroupObject obj : model.groupObjects) {
            if (!obj.name.equals(name)) continue;
            go = obj;
        }
        if (go == null) {
            return;
        }
        for (Face f : go.faces) {
            Vertex n = f.faceNormal;
            Vec3 normal = Vec3.func_72443_a((double)n.x, (double)n.y, (double)n.z);
            normal.func_72446_c(pitch);
            normal.func_72442_b(rot);
            tes.func_78375_b((float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c);
            if (shadow || hasColor) {
                float brightness = 1.0f;
                if (shadow && (brightness = (float)normal.field_72448_b * 0.3f + 0.7f - (float)Math.abs(normal.field_72450_a) * 0.1f + (float)Math.abs(normal.field_72449_c) * 0.1f) < 0.45f) {
                    brightness = 0.45f;
                }
                if (hasColor) {
                    tes.func_78376_a((int)((float)red * brightness), (int)((float)green * brightness), (int)((float)blue * brightness));
                } else {
                    tes.func_78386_a(brightness, brightness, brightness);
                }
            }
            for (int i = 0; i < f.vertices.length; ++i) {
                Vertex v = f.vertices[i];
                Vec3 vec = Vec3.func_72443_a((double)v.x, (double)v.y, (double)v.z);
                vec.func_72446_c(pitch);
                vec.func_72442_b(rot);
                float x = (float)vec.field_72450_a;
                float y = (float)vec.field_72448_b;
                float z = (float)vec.field_72449_c;
                TextureCoordinate t = f.textureCoordinates[i];
                tes.func_78374_a((double)x, (double)y, (double)z, (double)icon.func_94214_a((double)t.u * 16.0), (double)icon.func_94207_b((double)t.v * 16.0));
                if (i % 3 != 2) continue;
                tes.func_78374_a((double)x, (double)y, (double)z, (double)icon.func_94214_a((double)t.u * 16.0), (double)icon.func_94207_b((double)t.v * 16.0));
            }
        }
    }

    public static void setColor(int color) {
        red = (color & 0xFF0000) >> 16;
        green = (color & 0xFF00) >> 8;
        blue = color & 0xFF;
        hasColor = true;
    }

    public static void setColor(int r, int g, int b) {
        red = r;
        green = g;
        blue = b;
        hasColor = true;
    }

    public static void clearColor() {
        hasColor = false;
    }

    static {
        hasColor = false;
    }
}

