/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.handler.MissileStruct;
import com.hbm.items.weapon.ItemMissile;
import com.hbm.render.util.MissilePart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MissileMultipart {
    public MissilePart warhead;
    public MissilePart fuselage;
    public MissilePart fins;
    public MissilePart thruster;

    public double getHeight() {
        double height = 0.0;
        if (this.warhead != null && this.warhead.type == ItemMissile.PartType.WARHEAD) {
            height += this.warhead.height;
        }
        if (this.fuselage != null && this.fuselage.type == ItemMissile.PartType.FUSELAGE) {
            height += this.fuselage.height;
        }
        if (this.thruster != null && this.thruster.type == ItemMissile.PartType.THRUSTER) {
            height += this.thruster.height;
        }
        return height;
    }

    public static MissileMultipart loadFromStruct(MissileStruct struct) {
        if (struct == null) {
            return null;
        }
        MissileMultipart multipart = new MissileMultipart();
        multipart.warhead = MissilePart.getPart(struct.warhead);
        multipart.fuselage = MissilePart.getPart(struct.fuselage);
        multipart.fins = MissilePart.getPart(struct.fins);
        multipart.thruster = MissilePart.getPart(struct.thruster);
        return multipart;
    }
}

