/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.ModBlocks;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.tileentity.IItemRendererProvider;
import com.hbm.tileentity.machine.TileEntitySteamEngine;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderSteamEngine
extends TileEntitySpecialRenderer
implements IItemRendererProvider {
    public void func_147500_a(TileEntity tile, double x, double y, double z, float interp) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glEnable((int)2896);
        switch (tile.func_145832_p() - 10) {
            case 3: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        TileEntitySteamEngine engine = (TileEntitySteamEngine)tile;
        float angle = engine.lastRotor + (engine.rotor - engine.lastRotor) * interp;
        GL11.glTranslated((double)2.0, (double)0.0, (double)0.0);
        this.renderCommon(angle);
        GL11.glPopMatrix();
    }

    private void renderCommon(double rot) {
        GL11.glDisable((int)2884);
        GL11.glShadeModel((int)7425);
        this.func_147499_a(ResourceManager.steam_engine_tex);
        ResourceManager.steam_engine.renderPart("Base");
        GL11.glPushMatrix();
        GL11.glTranslated((double)2.0, (double)1.375, (double)0.0);
        GL11.glRotated((double)rot, (double)0.0, (double)0.0, (double)-1.0);
        GL11.glTranslated((double)-2.0, (double)-1.375, (double)0.0);
        ResourceManager.steam_engine.renderPart("Flywheel");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.375, (double)-0.5);
        GL11.glRotated((double)(rot * 2.0), (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-1.375, (double)0.5);
        ResourceManager.steam_engine.renderPart("Shaft");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        double sin = Math.sin(rot * Math.PI / 180.0) * 0.25 - 0.25;
        double cos = Math.cos(rot * Math.PI / 180.0) * 0.25;
        double ang = Math.acos(cos / 1.875);
        GL11.glTranslated((double)sin, (double)cos, (double)0.0);
        GL11.glTranslated((double)2.25, (double)1.375, (double)0.0);
        GL11.glRotated((double)(ang * 180.0 / Math.PI - 90.0), (double)0.0, (double)0.0, (double)-1.0);
        GL11.glTranslated((double)-2.25, (double)-1.375, (double)0.0);
        ResourceManager.steam_engine.renderPart("Transmission");
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        double cath = Math.sqrt(3.515625 - cos * cos);
        GL11.glTranslated((double)(1.875 - cath + sin), (double)0.0, (double)0.0);
        ResourceManager.steam_engine.renderPart("Piston");
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)2884);
    }

    @Override
    public Item getItemForRenderer() {
        return Item.func_150898_a((Block)ModBlocks.machine_steam_engine);
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glTranslated((double)0.0, (double)-1.5, (double)0.0);
                double scale = 2.0;
                GL11.glScaled((double)scale, (double)scale, (double)scale);
            }

            @Override
            public void renderCommonWithStack(ItemStack item) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                boolean cog = item.func_77960_j() != 1;
                RenderSteamEngine.this.renderCommon(cog ? (double)(System.currentTimeMillis() % 3600L) * 0.1 : 0.0);
            }
        };
    }
}

