/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.generic.BlockLoot;
import com.hbm.items.ModItems;
import com.hbm.main.ResourceManager;
import com.hbm.render.model.ModelFatman;
import com.hbm.render.model.ModelLeverAction;
import com.hbm.util.Tuple;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderLoot
extends TileEntitySpecialRenderer {
    protected ModelFatman launcher;
    protected ModelLeverAction shotgun;

    public void func_147500_a(TileEntity te, double x, double y, double z, float interp) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)2896);
        RenderHelper.func_74519_b();
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)te;
        for (Tuple.Quartet<ItemStack, Double, Double, Double> item : loot.items) {
            ItemStack stack = item.getW();
            GL11.glPushMatrix();
            GL11.glTranslated((double)item.getX(), (double)item.getY(), (double)item.getZ());
            if (stack.func_77973_b() == ModItems.ammo_nuke) {
                this.renderNuke();
            } else if (stack.func_77973_b() == ModItems.gun_fatman || stack.func_77973_b() == ModItems.gun_proto || stack.func_77973_b() == ModItems.gun_mirv) {
                this.renderLauncher();
            } else if (stack.func_77973_b() == ModItems.gun_lever_action) {
                this.renderShotgun();
            } else {
                this.renderStandardItem(item.getW());
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void renderNuke() {
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glTranslated((double)1.0, (double)0.5, (double)1.0);
        GL11.glShadeModel((int)7425);
        this.func_147499_a(ResourceManager.mini_nuke_tex);
        ResourceManager.projectiles.renderPart("MiniNuke");
        GL11.glShadeModel((int)7424);
    }

    private void renderLauncher() {
        if (this.launcher == null) {
            this.launcher = new ModelFatman();
        }
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)3.0, (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)0.5, (double)-0.3751, (double)-0.625);
        this.func_147499_a(new ResourceLocation("hbm:textures/models/FatmanLauncher.png"));
        this.launcher.render(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, new ItemStack(ModItems.gun_fatman));
    }

    private void renderShotgun() {
        if (this.shotgun == null) {
            this.shotgun = new ModelLeverAction();
        }
        GL11.glScaled((double)0.25, (double)0.25, (double)0.25);
        GL11.glTranslated((double)3.0, (double)0.0625, (double)2.0);
        GL11.glRotated((double)-25.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        this.func_147499_a(new ResourceLocation("hbm:textures/models/ModelLeverAction.png"));
        this.shotgun.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
    }

    private void renderStandardItem(ItemStack stack) {
        GL11.glTranslated((double)0.25, (double)0.0, (double)0.25);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        this.func_147499_a(TextureMap.field_110576_c);
        for (int i = 0; i < stack.func_77973_b().getRenderPasses(stack.func_77960_j()); ++i) {
            IIcon icon = stack.func_77973_b().getIcon(stack, i);
            float f14 = icon.func_94209_e();
            float f15 = icon.func_94212_f();
            float f4 = icon.func_94206_g();
            float f5 = icon.func_94210_h();
            int k1 = stack.func_77973_b().func_82790_a(stack, i);
            float f10 = (float)(k1 >> 16 & 0xFF) / 255.0f;
            float f11 = (float)(k1 >> 8 & 0xFF) / 255.0f;
            float f12 = (float)(k1 & 0xFF) / 255.0f;
            GL11.glColor4f((float)(1.0f * f10), (float)(1.0f * f11), (float)(1.0f * f12), (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)f15, (float)f4, (float)f14, (float)f5, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
        }
    }
}

