/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.animloader.AnimatedModel;
import com.hbm.animloader.Animation;
import com.hbm.animloader.AnimationWrapper;
import com.hbm.render.loader.WavefrontObjDisplayList;
import com.hbm.tileentity.DoorDecl;
import com.hbm.tileentity.TileEntityDoorGeneric;
import java.nio.DoubleBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class RenderDoorGeneric
extends TileEntitySpecialRenderer {
    private static DoubleBuffer buf = null;
    private static final float[] tran = new float[3];
    private static final float[] orig = new float[3];
    private static final float[] rot = new float[3];

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTicks) {
        TileEntityDoorGeneric te = (TileEntityDoorGeneric)tile;
        if (buf == null) {
            buf = GLAllocation.func_74524_c((int)32).asDoubleBuffer();
        }
        DoorDecl door = te.getDoorType();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        switch (te.func_145832_p() - 10) {
            case 2: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)360.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        door.doOffsetTransform();
        double[][] clip = door.getClippingPlanes();
        for (int i = 0; i < clip.length; ++i) {
            GL11.glEnable((int)(12288 + i));
            buf.put(clip[i]);
            buf.rewind();
            GL11.glClipPlane((int)(12288 + i), (DoubleBuffer)buf);
        }
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2896);
        AnimatedModel animModel = door.getAnimatedModel();
        if (animModel != null) {
            Animation anim = door.getAnim();
            this.func_147499_a(door.getTextureForPart(te.getSkinIndex(), ""));
            long time = System.currentTimeMillis();
            long startTime = te.state > 1 ? te.animStartTime : time;
            boolean reverse = te.state == 1 || te.state == 2;
            AnimationWrapper w = new AnimationWrapper(startTime, anim).onEnd(new AnimationWrapper.EndResult(AnimationWrapper.EndType.STAY));
            if (reverse) {
                w.reverse();
            }
            animModel.controller.setAnim(w);
            animModel.renderAnimated(System.currentTimeMillis());
        } else {
            WavefrontObjDisplayList model = door.getModel();
            long ms = System.currentTimeMillis() - te.animStartTime;
            float openTicks = MathHelper.func_76131_a((float)(te.state == 2 || te.state == 0 ? (float)((long)(door.timeToOpen() * 50) - ms) : (float)ms), (float)0.0f, (float)(door.timeToOpen() * 50)) * 0.02f;
            for (Pair<String, Integer> p : model.nameToCallList) {
                if (!door.doesRender((String)p.getLeft(), false)) continue;
                GL11.glPushMatrix();
                this.func_147499_a(door.getTextureForPart(te.getSkinIndex(), (String)p.getLeft()));
                this.doPartTransform(door, (String)p.getLeft(), openTicks, false);
                GL11.glCallList((int)((Integer)p.getRight()));
                for (String name : door.getChildren((String)p.getLeft())) {
                    if (!door.doesRender(name, true)) continue;
                    GL11.glPushMatrix();
                    this.func_147499_a(door.getTextureForPart(te.getSkinIndex(), name));
                    this.doPartTransform(door, name, openTicks, true);
                    model.renderPart(name);
                    GL11.glPopMatrix();
                }
                GL11.glPopMatrix();
            }
        }
        for (int i = 0; i < clip.length; ++i) {
            GL11.glDisable((int)(12288 + i));
        }
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
    }

    public void doPartTransform(DoorDecl door, String name, float openTicks, boolean child) {
        door.getTranslation(name, openTicks, child, tran);
        door.getOrigin(name, orig);
        door.getRotation(name, openTicks, rot);
        GL11.glTranslated((double)orig[0], (double)orig[1], (double)orig[2]);
        if (rot[0] != 0.0f) {
            GL11.glRotated((double)rot[0], (double)1.0, (double)0.0, (double)0.0);
        }
        if (rot[1] != 0.0f) {
            GL11.glRotated((double)rot[1], (double)0.0, (double)1.0, (double)0.0);
        }
        if (rot[2] != 0.0f) {
            GL11.glRotated((double)rot[2], (double)0.0, (double)0.0, (double)1.0);
        }
        GL11.glTranslated((double)(-orig[0] + tran[0]), (double)(-orig[1] + tran[1]), (double)(-orig[2] + tran[2]));
    }
}

