/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.item;

import com.hbm.items.weapon.ItemMissile;
import com.hbm.render.util.MissilePart;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderMissilePart
implements IItemRenderer {
    MissilePart part;

    public ItemRenderMissilePart() {
    }

    public ItemRenderMissilePart(MissilePart part) {
        this.part = part;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case ENTITY: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.part == null) {
            return;
        }
        GL11.glPushMatrix();
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
            }
            case ENTITY: {
                double s = 0.4;
                GL11.glScaled((double)s, (double)s, (double)s);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.part.texture);
                this.part.model.renderAll();
                break;
            }
            case INVENTORY: {
                double height = this.part.guiheight;
                if (height == 0.0) {
                    height = 4.0;
                }
                double size = 10.0;
                double scale = size / height;
                GL11.glTranslated((double)(height / 2.0 * scale), (double)0.0, (double)0.0);
                GL11.glRotated((double)135.0, (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotated((double)145.0, (double)1.0, (double)0.0, (double)0.0);
                if (this.part.type == ItemMissile.PartType.WARHEAD) {
                    GL11.glTranslated((double)0.0, (double)(height / 8.0 * scale), (double)0.0);
                }
                if (this.part.type == ItemMissile.PartType.FUSELAGE) {
                    GL11.glTranslated((double)0.0, (double)(height / 4.0 * scale), (double)0.0);
                }
                GL11.glTranslated((double)3.5, (double)14.0, (double)0.0);
                GL11.glScaled((double)(-scale), (double)(-scale), (double)(-scale));
                GL11.glRotatef((float)(System.currentTimeMillis() / 25L % 360L), (float)0.0f, (float)-1.0f, (float)0.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.part.texture);
                this.part.model.renderAll();
                break;
            }
        }
        GL11.glPopMatrix();
    }
}

