/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.anim;

import com.hbm.render.anim.BusAnimationKeyframe;
import java.util.ArrayList;
import java.util.List;

public class BusAnimationSequence {
    private List<BusAnimationKeyframe> keyframes = new ArrayList<BusAnimationKeyframe>();
    public EnumTransformation transformationType;

    public BusAnimationSequence addKeyframe(BusAnimationKeyframe keyframe) {
        this.keyframes.add(keyframe);
        return this;
    }

    public double[] getTransformation(int millis) {
        BusAnimationKeyframe frame = this.getFrameAtTime(millis);
        if (frame == null) {
            return null;
        }
        if (frame.interpolationType == BusAnimationKeyframe.InterpolationType.NONE) {
            return frame.toArray();
        }
        double[] previous = new double[]{0.0, 0.0, 0.0};
        BusAnimationKeyframe lastFrame = this.getPreviousFrame(frame);
        if (lastFrame != null) {
            previous = lastFrame.toArray();
        }
        int frameTime = millis - this.getStartingTime(frame);
        double interpolation = (double)frameTime / (double)frame.duration;
        double interX = (frame.x - previous[0]) * interpolation + previous[0];
        double interY = (frame.y - previous[1]) * interpolation + previous[1];
        double interZ = (frame.z - previous[2]) * interpolation + previous[2];
        return new double[]{interX, interY, interZ};
    }

    public BusAnimationKeyframe getFrameAtTime(int millis) {
        int time = 0;
        for (BusAnimationKeyframe frame : this.keyframes) {
            if (millis >= (time += frame.duration)) continue;
            return frame;
        }
        return null;
    }

    public BusAnimationKeyframe getPreviousFrame(BusAnimationKeyframe frame) {
        int index = this.keyframes.indexOf(frame);
        if (index == 0) {
            return null;
        }
        return this.keyframes.get(index - 1);
    }

    public int getStartingTime(BusAnimationKeyframe start) {
        int time = 0;
        for (BusAnimationKeyframe frame : this.keyframes) {
            if (frame == start) break;
            time += frame.duration;
        }
        return time;
    }

    public int getTotalTime() {
        int time = 0;
        for (BusAnimationKeyframe frame : this.keyframes) {
            time += frame.duration;
        }
        return time;
    }

    public static enum EnumTransformation {
        UNDEFINED,
        ROTATION,
        TRANSLATION,
        SCALE;

    }
}

