/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.main.ResourceManager;
import com.hbm.particle.SpentCasing;
import com.hbm.util.Tuple;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ParticleSpentCasing
extends EntityFX {
    public static final Random rand = new Random();
    private static float dScale = 0.05f;
    private static float smokeJitter = 0.001f;
    private int maxSmokeGen = 120;
    private double smokeLift = 0.5;
    private int nodeLife = 30;
    private final List<Tuple.Pair<Vec3, Double>> smokeNodes = new ArrayList<Tuple.Pair<Vec3, Double>>();
    private final TextureManager textureManager;
    private final SpentCasing config;
    private boolean isSmoking;
    private float momentumPitch;
    private float momentumYaw;
    private boolean onGroundPreviously = false;
    private double maxHeight;
    private boolean setupDeltas = false;
    private double prevRenderX;
    private double prevRenderY;
    private double prevRenderZ;

    public ParticleSpentCasing(TextureManager textureManager, World world, double x, double y, double z, double mx, double my, double mz, float momentumPitch, float momentumYaw, SpentCasing config) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.textureManager = textureManager;
        this.momentumPitch = momentumPitch;
        this.momentumYaw = momentumYaw;
        this.config = config;
        this.field_70547_e = config.getMaxAge();
        this.isSmoking = rand.nextFloat() < config.getSmokeChance();
        this.maxSmokeGen = config.getSmokeDuration();
        this.smokeLift = config.getSmokeLift();
        this.nodeLife = config.getSmokeNodeLife();
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.field_70159_w = mx;
        this.field_70181_x = my;
        this.field_70179_y = mz;
        this.field_70545_g = 8.0f;
        this.maxHeight = y;
    }

    public int func_70537_b() {
        return 3;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70181_x > 0.0 && this.field_70163_u > this.maxHeight) {
            this.maxHeight = this.field_70163_u;
        }
        if (!this.onGroundPreviously && this.field_70122_E) {
            this.tryPlayBounceSound();
        }
        if (!this.onGroundPreviously && this.field_70122_E) {
            this.onGroundPreviously = true;
            this.field_70181_x = Math.log10(this.maxHeight - this.field_70163_u + 2.0);
            this.momentumPitch = (float)rand.nextGaussian() * this.config.getBouncePitch();
            this.momentumYaw = (float)rand.nextGaussian() * this.config.getBounceYaw();
            this.maxHeight = this.field_70163_u;
        } else if (this.onGroundPreviously && !this.field_70122_E) {
            this.onGroundPreviously = false;
        }
        if (this.field_70546_d > this.maxSmokeGen && !this.smokeNodes.isEmpty()) {
            this.smokeNodes.clear();
        }
        if (this.isSmoking && this.field_70546_d <= this.maxSmokeGen) {
            for (Tuple.Pair<Vec3, Double> pair : this.smokeNodes) {
                Vec3 node = pair.getKey();
                node.field_72450_a += rand.nextGaussian() * (double)smokeJitter;
                node.field_72449_c += rand.nextGaussian() * (double)smokeJitter;
                node.field_72448_b += this.smokeLift * (double)dScale;
                pair.value = Math.max(0.0, (Double)pair.value - 1.0 / (double)this.nodeLife);
            }
            if (this.field_70546_d < this.maxSmokeGen || this.field_70171_ac) {
                this.smokeNodes.add(new Tuple.Pair<Vec3, Double>(Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), this.smokeNodes.isEmpty() ? 0.0 : 1.0));
            }
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        if (this.field_70122_E) {
            this.field_70125_A = 0.0f;
        } else {
            this.field_70125_A += this.momentumPitch;
            this.field_70177_z += this.momentumYaw;
        }
    }

    public void func_70539_a(Tessellator tessellator, float interp, float x, float y, float z, float tx, float tz) {
        GL11.glPushMatrix();
        RenderHelper.func_74519_b();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)32826);
        GL11.glDepthMask((boolean)true);
        double pX = this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)interp;
        double pY = this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)interp;
        double pZ = this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)interp;
        if (!this.setupDeltas) {
            this.prevRenderX = pX;
            this.prevRenderY = pY;
            this.prevRenderZ = pZ;
            this.setupDeltas = true;
        }
        int brightness = this.field_70170_p.func_72802_i(MathHelper.func_76128_c((double)pX), MathHelper.func_76128_c((double)pY), MathHelper.func_76128_c((double)pZ), 0);
        int lX = brightness % 65536;
        int lY = brightness / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lX / 1.0f), (float)((float)lY / 1.0f));
        this.textureManager.func_110577_a(ResourceManager.casings_tex);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        double dX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)interp;
        double dY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)interp;
        double dZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)interp;
        GL11.glTranslated((double)(pX - dX), (double)(pY - dY - (double)(this.field_70131_O / 4.0f) + (double)this.config.getScaleY() * 0.01), (double)(pZ - dZ));
        GL11.glScalef((float)dScale, (float)dScale, (float)dScale);
        GL11.glRotatef((float)(180.0f - this.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_70125_A), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)this.config.getScaleX(), (float)this.config.getScaleY(), (float)this.config.getScaleZ());
        int index = 0;
        for (String name : this.config.getType().partNames) {
            int col = this.config.getColors()[index];
            Color color = new Color(col);
            GL11.glColor3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
            ResourceManager.casings.renderPart(name);
            ++index;
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(pX - dX), (double)(pY - dY - (double)(this.field_70131_O / 4.0f)), (double)(pZ - dZ));
        if (!this.smokeNodes.isEmpty()) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            float scale = this.config.getScaleX() * 0.5f * dScale;
            Vec3 vec = Vec3.func_72443_a((double)scale, (double)0.0, (double)0.0);
            float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * interp;
            vec.func_72442_b((float)Math.toRadians(-yaw));
            double deltaX = this.prevRenderX - pX;
            double deltaY = this.prevRenderY - pY;
            double deltaZ = this.prevRenderZ - pZ;
            for (Tuple.Pair<Vec3, Double> pair : this.smokeNodes) {
                Vec3 pos = pair.getKey();
                double mult = 1.0;
                pos.field_72450_a += deltaX * mult;
                pos.field_72448_b += deltaY * mult;
                pos.field_72449_c += deltaZ * mult;
            }
            for (int i = 0; i < this.smokeNodes.size() - 1; ++i) {
                Tuple.Pair<Vec3, Double> node = this.smokeNodes.get(i);
                Tuple.Pair<Vec3, Double> past = this.smokeNodes.get(i + 1);
                Vec3 nodeLoc = node.getKey();
                Vec3 pastLoc = past.getKey();
                float nodeAlpha = node.getValue().floatValue();
                float pastAlpha = past.getValue().floatValue();
                double timeAlpha = 1.0 - (double)this.field_70546_d / (double)this.maxSmokeGen;
                nodeAlpha = (float)((double)nodeAlpha * timeAlpha);
                pastAlpha = (float)((double)pastAlpha * timeAlpha);
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, nodeAlpha);
                tessellator.func_78377_a(nodeLoc.field_72450_a, nodeLoc.field_72448_b, nodeLoc.field_72449_c);
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
                tessellator.func_78377_a(nodeLoc.field_72450_a + vec.field_72450_a, nodeLoc.field_72448_b, nodeLoc.field_72449_c + vec.field_72449_c);
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
                tessellator.func_78377_a(pastLoc.field_72450_a + vec.field_72450_a, pastLoc.field_72448_b, pastLoc.field_72449_c + vec.field_72449_c);
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, pastAlpha);
                tessellator.func_78377_a(pastLoc.field_72450_a, pastLoc.field_72448_b, pastLoc.field_72449_c);
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, nodeAlpha);
                tessellator.func_78377_a(nodeLoc.field_72450_a, nodeLoc.field_72448_b, nodeLoc.field_72449_c);
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
                tessellator.func_78377_a(nodeLoc.field_72450_a - vec.field_72450_a, nodeLoc.field_72448_b, nodeLoc.field_72449_c - vec.field_72449_c);
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
                tessellator.func_78377_a(pastLoc.field_72450_a - vec.field_72450_a, pastLoc.field_72448_b, pastLoc.field_72449_c - vec.field_72449_c);
                tessellator.func_78369_a(1.0f, 1.0f, 1.0f, pastAlpha);
                tessellator.func_78377_a(pastLoc.field_72450_a, pastLoc.field_72448_b, pastLoc.field_72449_c);
            }
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2884);
            tessellator.func_78381_a();
            GL11.glEnable((int)2884);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)518, (float)0.1f);
        }
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        this.prevRenderX = pX;
        this.prevRenderY = pY;
        this.prevRenderZ = pZ;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float p_70070_1_) {
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, 0, j = MathHelper.func_76128_c((double)this.field_70161_v))) {
            double d0 = (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * 0.66;
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - (double)this.field_70129_M + d0));
            return this.field_70170_p.func_72802_i(i, k, j, 0);
        }
        return 0;
    }

    private void tryPlayBounceSound() {
        String sound = this.config.getSound();
        if (sound != null && !sound.isEmpty()) {
            this.field_70170_p.func_72956_a((Entity)this, sound, 2.0f, 1.0f);
        }
    }
}

