/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.interfaces.IAnimatedDoor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;

public class TEDoorAnimationPacket
implements IMessage {
    public int x;
    public int y;
    public int z;
    public byte state;
    public byte skinIndex;
    public byte texture;

    public TEDoorAnimationPacket() {
    }

    public TEDoorAnimationPacket(int x, int y, int z, byte state) {
        this(x, y, z, state, 0, -1);
    }

    public TEDoorAnimationPacket(int x, int y, int z, byte state, byte skinIndex, byte tex) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.state = state;
        this.skinIndex = skinIndex;
        this.texture = tex;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.state = buf.readByte();
        this.skinIndex = buf.readByte();
        if (buf.readableBytes() == 1) {
            this.texture = buf.readByte();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.state);
        buf.writeByte((int)this.skinIndex);
        if (this.texture != -1) {
            buf.writeByte((int)this.texture);
        }
    }

    public static class Handler
    implements IMessageHandler<TEDoorAnimationPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(TEDoorAnimationPacket m, MessageContext ctx) {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(m.x, m.y, m.z);
            if (te instanceof IAnimatedDoor) {
                ((IAnimatedDoor)te).handleNewState(m.state);
                ((IAnimatedDoor)te).setSkinIndex(m.skinIndex);
                ((IAnimatedDoor)te).setTextureState(m.texture);
            }
            return null;
        }
    }
}

