/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.interfaces.IControlReceiver;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;

public class NBTControlPacket
implements IMessage {
    PacketBuffer buffer;
    int x;
    int y;
    int z;

    public NBTControlPacket() {
    }

    public NBTControlPacket(NBTTagCompound nbt, int x, int y, int z) {
        this.buffer = new PacketBuffer(Unpooled.buffer());
        this.x = x;
        this.y = y;
        this.z = z;
        try {
            this.buffer.func_150786_a(nbt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        if (this.buffer == null) {
            this.buffer = new PacketBuffer(Unpooled.buffer());
        }
        this.buffer.writeBytes(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        if (this.buffer == null) {
            this.buffer = new PacketBuffer(Unpooled.buffer());
        }
        buf.writeBytes((ByteBuf)this.buffer);
    }

    public static class Handler
    implements IMessageHandler<NBTControlPacket, IMessage> {
        public IMessage onMessage(NBTControlPacket m, MessageContext ctx) {
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            if (p.field_70170_p == null) {
                return null;
            }
            TileEntity te = p.field_70170_p.func_147438_o(m.x, m.y, m.z);
            try {
                IControlReceiver tile;
                NBTTagCompound nbt = m.buffer.func_150793_b();
                if (nbt != null && te instanceof IControlReceiver && (tile = (IControlReceiver)te).hasPermission((EntityPlayer)p)) {
                    tile.receiveControl((EntityPlayer)p, nbt);
                    tile.receiveControl(nbt);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

