/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.chunk.Chunk;

public class BiomeSyncPacket
implements IMessage {
    int chunkX;
    int chunkZ;
    byte blockX;
    byte blockZ;
    byte biome;
    byte[] biomeArray;

    public BiomeSyncPacket() {
    }

    public BiomeSyncPacket(int chunkX, int chunkZ, byte[] biomeArray) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.biomeArray = biomeArray;
    }

    public BiomeSyncPacket(int blockX, int blockZ, byte biome) {
        this.chunkX = blockX << 4;
        this.chunkZ = blockZ << 4;
        this.blockX = (byte)(blockX & 0xF);
        this.blockZ = (byte)(blockZ & 0xF);
        this.biome = biome;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.chunkX);
        buf.writeInt(this.chunkZ);
        if (this.biomeArray == null) {
            buf.writeBoolean(false);
            buf.writeByte((int)this.biome);
            buf.writeByte((int)this.blockX);
            buf.writeByte((int)this.blockZ);
        } else {
            buf.writeBoolean(true);
            for (int i = 0; i < 256; ++i) {
                buf.writeByte((int)this.biomeArray[i]);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.chunkX = buf.readInt();
        this.chunkZ = buf.readInt();
        if (!buf.readBoolean()) {
            this.biome = buf.readByte();
            this.blockX = buf.readByte();
            this.blockZ = buf.readByte();
        } else {
            buf.writeBoolean(true);
            this.biomeArray = new byte[256];
            for (int i = 0; i < 256; ++i) {
                this.biomeArray[i] = buf.readByte();
            }
        }
    }

    public static class Handler
    implements IMessageHandler<BiomeSyncPacket, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(BiomeSyncPacket m, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (!world.func_72863_F().func_73149_a(m.chunkX, m.chunkZ)) {
                return null;
            }
            Chunk chunk = world.func_72964_e(m.chunkX, m.chunkZ);
            if (m.biomeArray == null) {
                chunk.func_76605_m()[(m.blockZ & 0xF) << 4 | m.blockX & 0xF] = m.biome;
            } else {
                for (int i = 0; i < 256; ++i) {
                    chunk.func_76605_m()[i] = m.biomeArray[i];
                }
            }
            return null;
        }
    }
}

