/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.inventory.container.ContainerAnvil;
import com.hbm.inventory.recipes.anvil.AnvilRecipes;
import com.hbm.util.AchievementHandler;
import com.hbm.util.InventoryUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class AnvilCraftPacket
implements IMessage {
    int recipeIndex;
    int mode;

    public AnvilCraftPacket() {
    }

    public AnvilCraftPacket(AnvilRecipes.AnvilConstructionRecipe recipe, int mode) {
        this.recipeIndex = AnvilRecipes.getConstruction().indexOf(recipe);
        this.mode = mode;
    }

    public void fromBytes(ByteBuf buf) {
        this.recipeIndex = buf.readInt();
        this.mode = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.recipeIndex);
        buf.writeInt(this.mode);
    }

    public static class Handler
    implements IMessageHandler<AnvilCraftPacket, IMessage> {
        public IMessage onMessage(AnvilCraftPacket m, MessageContext ctx) {
            if (m.recipeIndex < 0 || m.recipeIndex >= AnvilRecipes.getConstruction().size()) {
                return null;
            }
            EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
            if (!(p.field_71070_bA instanceof ContainerAnvil)) {
                return null;
            }
            ContainerAnvil anvil = (ContainerAnvil)p.field_71070_bA;
            AnvilRecipes.AnvilConstructionRecipe recipe = AnvilRecipes.getConstruction().get(m.recipeIndex);
            if (!recipe.isTierValid(anvil.tier)) {
                return null;
            }
            int count = m.mode == 1 ? (recipe.output.size() > 1 ? 64 : recipe.output.get((int)0).stack.func_77976_d() / recipe.output.get((int)0).stack.field_77994_a) : 1;
            for (int i = 0; i < count && InventoryUtil.doesPlayerHaveAStacks((EntityPlayer)p, recipe.input, true); ++i) {
                InventoryUtil.giveChanceStacksToPlayer((EntityPlayer)p, recipe.output);
                AchievementHandler.fire((EntityPlayer)p, recipe.output.get((int)0).stack);
            }
            p.field_71069_bz.func_75142_b();
            return null;
        }
    }
}

