/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.gununified;

import api.hbm.energy.IBatteryItem;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.interfaces.IHoldableWeapon;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.packet.GunAnimationPacket;
import com.hbm.packet.GunButtonPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import com.hbm.util.BobMathUtil;
import com.hbm.util.ChatBuilder;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Mouse;

public class ItemEnergyGunBase
extends ItemGunBase
implements IBatteryItem {
    public ItemEnergyGunBase(GunConfiguration config) {
        super(config);
    }

    public ItemEnergyGunBase(GunConfiguration config, GunConfiguration alt) {
        super(config, alt);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add("Energy Stored: " + BobMathUtil.getShortNumber(this.getCharge(stack)) + "/" + BobMathUtil.getShortNumber(this.mainConfig.maxCharge) + "HE");
        list.add("Charge rate: " + BobMathUtil.getShortNumber(this.mainConfig.chargeRate) + "HE/t");
        this.addAdditionalInformation(stack, list);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void updateClient(ItemStack stack, World world, EntityPlayer entity, int slot, boolean isCurrentItem) {
        if (!world.field_72995_K) {
            return;
        }
        boolean clickLeft = Mouse.isButtonDown((int)0);
        boolean clickRight = Mouse.isButtonDown((int)1);
        boolean left = this.m1;
        boolean right = this.m2;
        if (isCurrentItem) {
            if (left && right) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 0));
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 1));
                this.m1 = false;
                this.m2 = false;
            }
            if (left && !clickLeft) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 0));
                this.m1 = false;
                this.endActionClient(stack, world, entity, true);
            }
            if (right && !clickRight) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 1));
                this.m2 = false;
                this.endActionClient(stack, world, entity, false);
            }
        }
    }

    @Override
    protected void updateServer(ItemStack stack, World world, EntityPlayer player, int slot, boolean isCurrentItem) {
        if (ItemEnergyGunBase.getDelay(stack) > 0 && isCurrentItem) {
            ItemEnergyGunBase.setDelay(stack, ItemEnergyGunBase.getDelay(stack) - 1);
        }
        if (ItemEnergyGunBase.getIsMouseDown(stack) && player.func_70694_bm() != stack) {
            ItemEnergyGunBase.setIsMouseDown(stack, false);
        }
        if (ItemEnergyGunBase.getIsAltDown(stack) && !isCurrentItem) {
            ItemEnergyGunBase.setIsAltDown(stack, false);
        }
        if (GeneralConfig.enableGuns && this.mainConfig.firingMode == 1 && ItemEnergyGunBase.getIsMouseDown(stack) && this.tryShoot(stack, world, player, isCurrentItem)) {
            this.fire(stack, world, player);
            ItemEnergyGunBase.setDelay(stack, this.getConfig((ItemStack)stack).firingRate);
        }
    }

    @Override
    protected boolean tryShoot(ItemStack stack, World world, EntityPlayer player, boolean main) {
        if (main && ItemEnergyGunBase.getDelay(stack) == 0) {
            return (long)this.getConfig((ItemStack)stack).dischargePerShot <= this.getCharge(stack);
        }
        return false;
    }

    @Override
    protected void fire(ItemStack stack, World world, EntityPlayer player) {
        BulletConfiguration config = this.getConfig(stack);
        int bullets = config.bulletsMin;
        for (int k = 0; k < this.mainConfig.roundsPerCycle; ++k) {
            if (config.bulletsMax > config.bulletsMin) {
                bullets += world.field_73012_v.nextInt(config.bulletsMax - config.bulletsMin);
            }
            for (int i = 0; i < bullets; ++i) {
                this.spawnProjectile(world, player, stack, BulletConfigSyncingUtil.getKey(config));
            }
            this.setCharge(stack, this.getCharge(stack) - (long)config.dischargePerShot);
        }
        world.func_72956_a((Entity)player, this.mainConfig.firingSound, 1.0f, this.mainConfig.firingPitch);
    }

    @Override
    protected void spawnProjectile(World world, EntityPlayer player, ItemStack stack, int config) {
        EntityBulletBaseNT bullet = new EntityBulletBaseNT(world, config, (EntityLivingBase)player);
        world.func_72838_d((Entity)bullet);
        if (this.mainConfig.animations.containsKey((Object)HbmAnimations.AnimType.CYCLE) && player instanceof EntityPlayerMP) {
            PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.CYCLE.ordinal()), (EntityPlayerMP)player);
        }
    }

    @Override
    public void startAction(ItemStack stack, World world, EntityPlayer player, boolean main) {
        if (this.mainConfig.firingMode == 0 && main && this.tryShoot(stack, world, player, main)) {
            this.fire(stack, world, player);
            ItemEnergyGunBase.setDelay(stack, this.mainConfig.rateOfFire);
        }
        if (!main && stack.func_77973_b() instanceof ItemEnergyGunBase) {
            byte mode;
            byte by = mode = stack.func_77942_o() ? stack.func_77978_p().func_74771_c("mode") : (byte)0;
            if (!stack.func_77942_o()) {
                stack.field_77990_d = new NBTTagCompound();
            }
            if ((mode = (byte)(mode + 1)) >= this.mainConfig.config.size()) {
                mode = 0;
            }
            stack.func_77978_p().func_74774_a("mode", mode);
            if (!world.field_72995_K) {
                BulletConfiguration config = BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(mode));
                player.func_145747_a((IChatComponent)ChatBuilder.start("").nextTranslation("weapon.elecGun.modeChange").color(EnumChatFormatting.WHITE).nextTranslation(" ").nextTranslation(config.modeName).color(config.chatColour).flush());
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.getMaxCharge();
    }

    @Override
    public void chargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemEnergyGunBase) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") + i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void setCharge(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemEnergyGunBase) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void dischargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemEnergyGunBase) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") - i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", ((ItemEnergyGunBase)stack.func_77973_b()).mainConfig.maxCharge - i);
            }
        }
    }

    @Override
    public long getCharge(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemEnergyGunBase) {
            if (stack.func_77942_o()) {
                return stack.field_77990_d.func_74763_f("charge");
            }
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", ((ItemEnergyGunBase)stack.func_77973_b()).mainConfig.maxCharge);
            return stack.field_77990_d.func_74763_f("charge");
        }
        return 0L;
    }

    @Override
    public long getMaxCharge() {
        return this.mainConfig.maxCharge;
    }

    @Override
    public long getChargeRate() {
        return this.mainConfig.chargeRate;
    }

    @Override
    public long getDischargeRate() {
        return 0L;
    }

    public BulletConfiguration getConfig(ItemStack stack) {
        byte mode = 0;
        if (stack.func_77942_o()) {
            mode = stack.func_77978_p().func_74771_c("mode");
        }
        return BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(mode));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        ItemStack stack = new ItemStack(item);
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74772_a("charge", ((ItemEnergyGunBase)item).getMaxCharge());
        list.add(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Pre event, RenderGameOverlayEvent.ElementType type, EntityPlayer player, ItemStack stack) {
        if (type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && GeneralConfig.enableCrosshairs) {
            event.setCanceled(true);
            if (!this.mainConfig.hasSights || !player.func_70093_af()) {
                RenderScreenOverlay.renderCustomCrosshairs(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, ((IHoldableWeapon)player.func_70694_bm().func_77973_b()).getCrosshair());
            } else {
                RenderScreenOverlay.renderCustomCrosshairs(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, RenderScreenOverlay.Crosshair.NONE);
            }
        }
    }
}

