/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import api.hbm.fluid.IFillableItem;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ISyncButtons;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;

public class ItemPlasmaSpear
extends Item
implements IFillableItem,
ISyncButtons {
    public static final int maxFuel = 3000;

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getFill(stack) < 3000;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getFill(stack) / 3000.0;
    }

    public int getFill(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            this.setFill(stack, 3000);
            return 3000;
        }
        return stack.field_77990_d.func_74762_e("fuel");
    }

    public void setFill(ItemStack stack, int fill) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("fuel", fill);
    }

    public static ItemStack getEmptyTool(Item item) {
        ItemPlasmaSpear tool = (ItemPlasmaSpear)item;
        ItemStack stack = new ItemStack(item);
        tool.setFill(stack, 0);
        return stack;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74757_a("melee", !stack.field_77990_d.func_74767_n("melee"));
        world.func_72956_a((Entity)player, "random.orb", 0.25f, 1.25f);
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return stack.func_77942_o() && !stack.field_77990_d.func_74767_n("melee");
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (!(entityLiving instanceof EntityPlayerMP)) {
            return false;
        }
        if (this.getFill(stack) <= 0) {
            return false;
        }
        if (stack.func_77942_o() && stack.field_77990_d.func_74767_n("melee")) {
            return true;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("type", "anim");
        nbt.func_74778_a("mode", "lSwing");
        PacketDispatcher.wrapper.sendTo((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), (EntityPlayerMP)entityLiving);
        return false;
    }

    @Override
    public boolean canReceiveMouse(EntityPlayer player, ItemStack stack, MouseEvent event, int button, boolean buttonstate) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74767_n("melee")) {
            return false;
        }
        if (button == 0) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    @Override
    public void receiveMouse(EntityPlayer player, ItemStack stack, int button, boolean buttonstate) {
        Vec3 start = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e() - (double)player.field_70129_M), (double)player.field_70161_v);
        Vec3 look = player.func_70040_Z();
        Vec3 end = start.func_72441_c(look.field_72450_a * 100.0, look.field_72448_b * 100.0, look.field_72449_c * 100.0);
        List targets = player.field_70170_p.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)Math.min(start.field_72450_a, end.field_72450_a), (double)Math.min(start.field_72448_b, end.field_72448_b), (double)Math.min(start.field_72449_c, end.field_72449_c), (double)Math.max(start.field_72450_a, end.field_72450_a), (double)Math.max(start.field_72448_b, end.field_72448_b), (double)Math.max(start.field_72449_c, end.field_72449_c)));
        for (Entity target : targets) {
            AxisAlignedBB aabb = target.field_70121_D;
            MovingObjectPosition hitMop = aabb.func_72327_a(start, end);
            if (hitMop == null) continue;
            target.func_70097_a(new EntityDamageSource("laser", (Entity)player).func_76348_h(), 15.0f);
        }
    }

    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        return type == Fluids.SCHRABIDIC;
    }

    @Override
    public int tryFill(FluidType type, int amount, ItemStack stack) {
        int fill = this.getFill(stack);
        int toFill = 3000 - fill;
        toFill = Math.min(toFill, amount);
        toFill = Math.min(toFill, 10);
        this.setFill(stack, fill + toFill);
        return amount - toFill;
    }

    @Override
    public boolean providesFluid(FluidType type, ItemStack stack) {
        return false;
    }

    @Override
    public int tryEmpty(FluidType type, int amount, ItemStack stack) {
        return 0;
    }
}

