/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.handler.GunConfiguration;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.GunAnimationPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.sound.AudioWrapper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemGunGauss
extends ItemGunBase {
    private AudioWrapper chargeLoop;

    public ItemGunGauss(GunConfiguration config, GunConfiguration alt) {
        super(config, alt);
    }

    @Override
    public void endAction(ItemStack stack, World world, EntityPlayer player, boolean main) {
        if (ItemGunGauss.getHasShot(stack)) {
            world.func_72956_a((Entity)player, "hbm:weapon.sparkShoot", 2.0f, 1.0f);
            ItemGunGauss.setHasShot(stack, false);
        }
        if (!main && ItemGunGauss.getStored(stack) > 0) {
            EntityBulletBaseNT bullet = new EntityBulletBaseNT(world, this.altConfig.config.get(0), (EntityLivingBase)player);
            bullet.overrideDamage = (float)Math.max(ItemGunGauss.getStored(stack), 1) * 10.0f;
            world.func_72838_d((Entity)bullet);
            world.func_72956_a((Entity)player, "hbm:weapon.tauShoot", 0.5f, 0.75f);
            ItemGunGauss.setItemWear(stack, ItemGunGauss.getItemWear(stack) + ItemGunGauss.getCharge(stack) * 2);
            ItemGunGauss.setCharge(stack, 0);
            if (player instanceof EntityPlayerMP) {
                PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.CYCLE.ordinal()), (EntityPlayerMP)player);
            }
        }
    }

    @Override
    public void endActionClient(ItemStack stack, World world, EntityPlayer player, boolean main) {
        if (this.chargeLoop != null) {
            this.chargeLoop.stopSound();
            this.chargeLoop = null;
        }
    }

    @Override
    protected void altFire(ItemStack stack, World world, EntityPlayer player) {
        ItemGunGauss.setCharge(stack, 1);
    }

    @Override
    public void startActionClient(ItemStack stack, World world, EntityPlayer player, boolean main) {
        if (!main && ItemGunGauss.getItemWear(stack) < this.mainConfig.durability && player.field_71071_by.func_146028_b(ModItems.gun_xvl1456_ammo)) {
            this.chargeLoop = MainRegistry.proxy.getLoopedSound("hbm:weapon.tauChargeLoop2", (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, 1.0f, 5.0f, 0.75f);
            world.func_72956_a((Entity)player, "hbm:weapon.tauChargeLoop2", 1.0f, 0.75f);
            if (this.chargeLoop != null) {
                this.chargeLoop.startSound();
            }
        }
    }

    @Override
    protected void updateServer(ItemStack stack, World world, EntityPlayer player, int slot, boolean isCurrentItem) {
        super.updateServer(stack, world, player, slot, isCurrentItem);
        if (ItemGunGauss.getIsAltDown(stack) && ItemGunGauss.getItemWear(stack) < this.mainConfig.durability) {
            int c = ItemGunGauss.getCharge(stack);
            if (c > 200) {
                ItemGunGauss.setCharge(stack, 0);
                ItemGunGauss.setItemWear(stack, this.mainConfig.durability);
                player.func_70097_a(ModDamageSource.tauBlast, 1000.0f);
                world.func_72885_a((Entity)player, player.field_70165_t, player.field_70163_u + (double)player.eyeHeight, player.field_70161_v, 5.0f, true, true);
                return;
            }
            if (c > 0) {
                ItemGunGauss.setCharge(stack, c + 1);
                if (c % 10 == 1 && c < 140 && c > 2) {
                    if (player.field_71071_by.func_146028_b(ModItems.gun_xvl1456_ammo)) {
                        player.field_71071_by.func_146026_a(ModItems.gun_xvl1456_ammo);
                        ItemGunGauss.setStored(stack, ItemGunGauss.getStored(stack) + 1);
                    } else {
                        ItemGunGauss.setCharge(stack, 0);
                        ItemGunGauss.setStored(stack, 0);
                    }
                }
            } else {
                ItemGunGauss.setStored(stack, 0);
            }
        } else {
            ItemGunGauss.setCharge(stack, 0);
            ItemGunGauss.setStored(stack, 0);
        }
    }

    @Override
    protected void updateClient(ItemStack stack, World world, EntityPlayer player, int slot, boolean isCurrentItem) {
        super.updateClient(stack, world, player, slot, isCurrentItem);
        if (this.chargeLoop != null) {
            if (!this.chargeLoop.isPlaying()) {
                this.chargeLoop = this.rebootAudio(this.chargeLoop, player);
            }
            this.chargeLoop.updatePosition((float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v);
            this.chargeLoop.updatePitch(1.0f + (float)ItemGunGauss.getCharge(stack) * 0.01f);
        }
    }

    public AudioWrapper rebootAudio(AudioWrapper wrapper, EntityPlayer player) {
        wrapper.stopSound();
        AudioWrapper audio = MainRegistry.proxy.getLoopedSound("hbm:weapon.tauChargeLoop2", (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, wrapper.getVolume(), wrapper.getRange(), wrapper.getPitch());
        audio.startSound();
        return audio;
    }

    @Override
    protected void spawnProjectile(World world, EntityPlayer player, ItemStack stack, int config) {
        super.spawnProjectile(world, player, stack, config);
        ItemGunGauss.setHasShot(stack, true);
    }

    public static void setHasShot(ItemStack stack, boolean b) {
        ItemGunGauss.writeNBT(stack, "hasShot", b ? 1 : 0);
    }

    public static boolean getHasShot(ItemStack stack) {
        return ItemGunGauss.readNBT(stack, "hasShot") == 1;
    }

    public static void setCharge(ItemStack stack, int i) {
        ItemGunGauss.writeNBT(stack, "gauss_charge", i);
    }

    public static int getCharge(ItemStack stack) {
        return ItemGunGauss.readNBT(stack, "gauss_charge");
    }

    public static void setStored(ItemStack stack, int i) {
        ItemGunGauss.writeNBT(stack, "gauss_stored", i);
    }

    public static int getStored(ItemStack stack) {
        return ItemGunGauss.readNBT(stack, "gauss_stored");
    }
}

