/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import api.hbm.fluid.IFillableItem;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.projectile.EntityChemical;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.GunEnergyFactory;
import com.hbm.interfaces.IHoldableWeapon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.packet.GunAnimationPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ItemGunChemthrower
extends ItemGunBase
implements IFillableItem {
    public static final int transferSpeed = 50;

    public ItemGunChemthrower() {
        super(GunEnergyFactory.getChemConfig());
    }

    @Override
    protected void fire(ItemStack stack, World world, EntityPlayer player) {
        if (!this.hasAmmo(stack, player, true)) {
            return;
        }
        int bullets = 1;
        for (int i = 0; i < bullets; ++i) {
            this.spawnProjectile(world, player, stack, 0);
        }
        this.useUpAmmo(player, stack, true);
        player.field_71069_bz.func_75142_b();
        int wear = (int)Math.ceil(10.0f / (1.0f + (float)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack)));
        ItemGunChemthrower.setItemWear(stack, ItemGunChemthrower.getItemWear(stack) + wear);
    }

    @Override
    public boolean hasAmmo(ItemStack stack, EntityPlayer player, boolean main) {
        return ItemGunChemthrower.getMag(stack) >= 0 + this.getConsumption(stack);
    }

    @Override
    public void useUpAmmo(EntityPlayer player, ItemStack stack, boolean main) {
        if (!main && this.altConfig == null) {
            return;
        }
        GunConfiguration config = this.mainConfig;
        if (!main) {
            config = this.altConfig;
        }
        if (this.hasInfinity(stack, config)) {
            return;
        }
        ItemGunChemthrower.setMag(stack, ItemGunChemthrower.getMag(stack) - this.getConsumption(stack));
    }

    @Override
    public boolean canReload(ItemStack stack, World world, EntityPlayer player) {
        return false;
    }

    @Override
    protected void spawnProjectile(World world, EntityPlayer player, ItemStack stack, int config) {
        EntityChemical chem = new EntityChemical(world, (EntityLivingBase)player);
        chem.setFluid(this.getFluidType(stack));
        world.func_72838_d((Entity)chem);
        if (player instanceof EntityPlayerMP) {
            PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.CYCLE.ordinal()), (EntityPlayerMP)player);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add("Ammo: " + ItemGunChemthrower.getMag(stack) + " / " + this.mainConfig.ammoCap + "mB");
        list.add("Ammo Type: " + I18n.func_135052_a((String)this.getFluidType(stack).getUnlocalizedName(), (Object[])new Object[0]));
        int dura = this.mainConfig.durability - ItemGunChemthrower.getItemWear(stack);
        if (dura < 0) {
            dura = 0;
        }
        list.add("Durability: " + dura + " / " + this.mainConfig.durability);
        list.add("");
        list.add("Name: " + this.mainConfig.name);
        list.add("Manufacturer: " + (Object)((Object)this.mainConfig.manufacturer));
        if (!this.mainConfig.comment.isEmpty()) {
            list.add("");
            for (String s : this.mainConfig.comment) {
                list.add(EnumChatFormatting.ITALIC + s);
            }
        }
        if (GeneralConfig.enableExtendedLogging) {
            list.add("");
            list.add("Type: " + ItemGunChemthrower.getMagType(stack));
            list.add("Is Reloading: " + ItemGunChemthrower.getIsReloading(stack));
            list.add("Reload Cycle: " + ItemGunChemthrower.getReloadCycle(stack));
            list.add("RoF Cooldown: " + ItemGunChemthrower.getDelay(stack));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Pre event, RenderGameOverlayEvent.ElementType type, EntityPlayer player, ItemStack stack) {
        ItemGunBase gun = (ItemGunBase)stack.func_77973_b();
        GunConfiguration gcfg = gun.mainConfig;
        if (type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            FluidType fluid = this.getFluidType(stack);
            ItemStack ammo = ItemFluidIcon.make(fluid, 1);
            int count = ItemGunBase.getMag(stack);
            int max = gcfg.ammoCap;
            boolean showammo = gcfg.showAmmo;
            int dura = ItemGunBase.getItemWear(stack) * 50 / gcfg.durability;
            RenderScreenOverlay.renderAmmo(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, ammo, count, max, dura, showammo);
        }
        if (type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && GeneralConfig.enableCrosshairs) {
            event.setCanceled(true);
            if (!gcfg.hasSights || !player.func_70093_af()) {
                RenderScreenOverlay.renderCustomCrosshairs(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, ((IHoldableWeapon)player.func_70694_bm().func_77973_b()).getCrosshair());
            } else {
                RenderScreenOverlay.renderCustomCrosshairs(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, RenderScreenOverlay.Crosshair.NONE);
            }
        }
    }

    @Override
    protected void reload2(ItemStack stack, World world, EntityPlayer player) {
        ItemGunChemthrower.setIsReloading(stack, false);
    }

    public FluidType getFluidType(ItemStack stack) {
        return Fluids.fromID(ItemGunChemthrower.getMagType(stack));
    }

    public int getConsumption(ItemStack stack) {
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean acceptsFluid(FluidType type, ItemStack stack) {
        if (this.getFluidType(stack) == type) return true;
        if (ItemGunChemthrower.getMag(stack) != 0) return false;
        return true;
    }

    @Override
    public int tryFill(FluidType type, int amount, ItemStack stack) {
        if (!this.acceptsFluid(type, stack)) {
            return amount;
        }
        if (ItemGunChemthrower.getMag(stack) == 0) {
            ItemGunChemthrower.setMagType(stack, type.getID());
        }
        int fill = ItemGunChemthrower.getMag(stack);
        int req = this.mainConfig.ammoCap - fill;
        int toFill = Math.min(amount, req);
        toFill = Math.min(toFill, 50);
        ItemGunChemthrower.setMag(stack, fill + toFill);
        return amount - toFill;
    }

    @Override
    public boolean providesFluid(FluidType type, ItemStack stack) {
        return this.getFluidType(stack) == type;
    }

    @Override
    public int tryEmpty(FluidType type, int amount, ItemStack stack) {
        int fill = ItemGunChemthrower.getMag(stack);
        int toUnload = Math.min(fill, amount);
        toUnload = Math.min(toUnload, 50);
        ItemGunChemthrower.setMag(stack, fill - toUnload);
        return toUnload;
    }
}

