/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.handler.GunConfiguration;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemGunBio
extends ItemGunBase {
    public static long lastShot;
    public static List<double[]> smokeNodes;

    public ItemGunBio(GunConfiguration config) {
        super(config);
    }

    @Override
    public void startActionClient(ItemStack stack, World world, EntityPlayer player, boolean main) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void updateClient(ItemStack stack, World world, EntityPlayer entity, int slot, boolean isCurrentItem) {
        boolean smoking;
        super.updateClient(stack, world, entity, slot, isCurrentItem);
        boolean bl = smoking = lastShot + 2000L > System.currentTimeMillis();
        if (!smoking && !smokeNodes.isEmpty()) {
            smokeNodes.clear();
        }
        if (smoking) {
            Vec3 prev = Vec3.func_72443_a((double)(-entity.field_70159_w), (double)(-entity.field_70181_x), (double)(-entity.field_70179_y));
            prev.func_72442_b((float)((double)entity.field_70177_z * Math.PI / 180.0));
            double accel = 15.0;
            double side = (double)(entity.field_70177_z - entity.field_70758_at) * 0.1;
            double waggle = 0.025;
            for (double[] node : smokeNodes) {
                node[0] = node[0] + (prev.field_72450_a * accel + world.field_73012_v.nextGaussian() * waggle + side);
                node[1] = node[1] + (prev.field_72448_b + 1.5);
                node[2] = node[2] + (prev.field_72449_c * accel + world.field_73012_v.nextGaussian() * waggle);
            }
            double alpha = (double)(System.currentTimeMillis() - lastShot) / 2000.0;
            alpha = (1.0 - alpha) * 0.5;
            if (ItemGunBio.getIsReloading(stack)) {
                alpha = 0.0;
            }
            smokeNodes.add(new double[]{0.0, 0.0, 0.0, alpha});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BusAnimation getAnimation(ItemStack stack, HbmAnimations.AnimType type) {
        if (type == HbmAnimations.AnimType.CYCLE) {
            lastShot = System.currentTimeMillis();
            return new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, -3.0, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 250))).addBus("HAMMER", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 1.0, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 1.0, 300)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200))).addBus("DRUM", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 1.0, 50)));
        }
        if (type == HbmAnimations.AnimType.RELOAD) {
            return new BusAnimation().addBus("LATCH", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 90.0, 300)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 90.0, 2000)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 150))).addBus("FRONT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 45.0, 150)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 45.0, 2000)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 75))).addBus("RELOAD_ROT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 300)).addKeyframe(new BusAnimationKeyframe(60.0, 0.0, 0.0, 500)).addKeyframe(new BusAnimationKeyframe(60.0, 0.0, 0.0, 500)).addKeyframe(new BusAnimationKeyframe(0.0, -90.0, -90.0, 0)).addKeyframe(new BusAnimationKeyframe(0.0, -90.0, -90.0, 600)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 300)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 100)).addKeyframe(new BusAnimationKeyframe(-45.0, 0.0, 0.0, 50)).addKeyframe(new BusAnimationKeyframe(-45.0, 0.0, 0.0, 100)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 300))).addBus("RELOAD_MOVE", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 300)).addKeyframe(new BusAnimationKeyframe(0.0, -15.0, 0.0, 1000)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 450))).addBus("DRUM_PUSH", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 1600)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, -5.0, 0)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 300)));
        }
        return null;
    }

    static {
        smokeNodes = new ArrayList<double[]>();
    }
}

