/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.config.GeneralConfig;
import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.HbmKeybinds;
import com.hbm.interfaces.IHoldableWeapon;
import com.hbm.interfaces.IItemHUD;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.IEquipReceiver;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.GunAnimationPacket;
import com.hbm.packet.GunButtonPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import com.hbm.util.I18nUtil;
import com.hbm.util.InventoryUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Mouse;

public class ItemGunBase
extends Item
implements IHoldableWeapon,
IItemHUD,
IEquipReceiver {
    public GunConfiguration mainConfig;
    public GunConfiguration altConfig;
    @SideOnly(value=Side.CLIENT)
    public boolean m1;
    @SideOnly(value=Side.CLIENT)
    public boolean m2;

    public ItemGunBase(GunConfiguration config) {
        this.mainConfig = config;
        this.func_77625_d(1);
    }

    public ItemGunBase(GunConfiguration config, GunConfiguration alt) {
        this(config);
        this.altConfig = alt;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (entity instanceof EntityPlayer) {
            boolean bl = isCurrentItem = ((EntityPlayer)entity).func_70694_bm() == stack;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && world.field_72995_K) {
                this.updateClient(stack, world, (EntityPlayer)entity, slot, isCurrentItem);
            } else {
                this.updateServer(stack, world, (EntityPlayer)entity, slot, isCurrentItem);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClient(ItemStack stack, World world, EntityPlayer entity, int slot, boolean isCurrentItem) {
        if (!world.field_72995_K) {
            return;
        }
        boolean clickLeft = Mouse.isButtonDown((int)0);
        boolean clickRight = Mouse.isButtonDown((int)1);
        boolean left = this.m1;
        boolean right = this.m2;
        if (isCurrentItem) {
            if (left && right) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 0));
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 1));
                this.m1 = false;
                this.m2 = false;
            }
            if (left && !clickLeft) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 0));
                this.m1 = false;
                this.endActionClient(stack, world, entity, true);
            }
            if (right && !clickRight) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 1));
                this.m2 = false;
                this.endActionClient(stack, world, entity, false);
            }
            if ((this.mainConfig.reloadType != 0 || this.altConfig != null && this.altConfig.reloadType != 0) && GameSettings.func_100015_a((KeyBinding)HbmKeybinds.reloadKey) && Minecraft.func_71410_x().field_71462_r == null && (ItemGunBase.getMag(stack) < this.mainConfig.ammoCap || this.hasInfinity(stack, this.mainConfig))) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(true, 2));
                ItemGunBase.setIsReloading(stack, true);
                ItemGunBase.resetReloadCycle(stack);
            }
        }
    }

    protected void updateServer(ItemStack stack, World world, EntityPlayer player, int slot, boolean isCurrentItem) {
        if (ItemGunBase.getDelay(stack) > 0 && isCurrentItem) {
            ItemGunBase.setDelay(stack, ItemGunBase.getDelay(stack) - 1);
        }
        if (ItemGunBase.getIsMouseDown(stack) && player.func_70694_bm() != stack) {
            ItemGunBase.setIsMouseDown(stack, false);
        }
        if (ItemGunBase.getIsAltDown(stack) && !isCurrentItem) {
            ItemGunBase.setIsAltDown(stack, false);
        }
        if (GeneralConfig.enableGuns && this.mainConfig.firingMode == 1 && ItemGunBase.getIsMouseDown(stack) && this.tryShoot(stack, world, player, isCurrentItem)) {
            this.fire(stack, world, player);
            ItemGunBase.setDelay(stack, this.mainConfig.rateOfFire);
        }
        if (ItemGunBase.getIsReloading(stack) && isCurrentItem) {
            this.reload2(stack, world, player);
        }
        BulletConfiguration queued = ItemGunBase.getCasing(stack);
        int timer = ItemGunBase.getCasingTimer(stack);
        if (queued != null && timer > 0) {
            if (--timer <= 0) {
                ItemGunBase.trySpawnCasing((Entity)player, this.mainConfig.ejector, queued, stack);
            }
            ItemGunBase.setCasingTimer(stack, timer);
        }
    }

    protected boolean tryShoot(ItemStack stack, World world, EntityPlayer player, boolean main) {
        if (ItemGunBase.getIsReloading(stack)) {
            if (this.mainConfig.reloadType == 2) {
                if (ItemGunBase.getMag(stack) > 0) {
                    ItemGunBase.setReloadCycle(stack, 0);
                    ItemGunBase.setIsReloading(stack, false);
                }
            }
        }
        if (main && ItemGunBase.getDelay(stack) == 0 && !ItemGunBase.getIsReloading(stack) && ItemGunBase.getItemWear(stack) < this.mainConfig.durability) {
            return this.hasAmmo(stack, player, main);
        }
        if (!main && this.altConfig != null && ItemGunBase.getDelay(stack) == 0 && !ItemGunBase.getIsReloading(stack) && ItemGunBase.getItemWear(stack) < this.mainConfig.durability) {
            return this.hasAmmo(stack, player, false);
        }
        return false;
    }

    public boolean hasAmmo(ItemStack stack, EntityPlayer player, boolean main) {
        GunConfiguration config = this.mainConfig;
        if (!main) {
            config = this.altConfig;
        }
        if (config.reloadType == 0) {
            return ItemGunBase.getBeltSize(player, ItemGunBase.getBeltType(player, stack, main)) > 0;
        }
        return ItemGunBase.getMag(stack) > 0;
    }

    protected void fire(ItemStack stack, World world, EntityPlayer player) {
        BulletConfiguration config = null;
        config = this.mainConfig.reloadType == 0 ? ItemGunBase.getBeltCfg(player, stack, true) : BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(ItemGunBase.getMagType(stack)));
        int bullets = config.bulletsMin;
        for (int k = 0; k < this.mainConfig.roundsPerCycle && this.hasAmmo(stack, player, true); ++k) {
            if (config.bulletsMax > config.bulletsMin) {
                bullets += world.field_73012_v.nextInt(config.bulletsMax - config.bulletsMin);
            }
            for (int i = 0; i < bullets; ++i) {
                this.spawnProjectile(world, player, stack, BulletConfigSyncingUtil.getKey(config));
            }
            this.useUpAmmo(player, stack, true);
            player.field_71069_bz.func_75142_b();
            int wear = (int)Math.ceil((float)config.wear / (1.0f + (float)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack)));
            ItemGunBase.setItemWear(stack, ItemGunBase.getItemWear(stack) + wear);
        }
        world.func_72956_a((Entity)player, this.mainConfig.firingSound, this.mainConfig.firingVolume, this.mainConfig.firingPitch);
        if (this.mainConfig.ejector != null && !this.mainConfig.ejector.getAfterReload()) {
            ItemGunBase.queueCasing((Entity)player, this.mainConfig.ejector, config, stack);
        }
    }

    protected void altFire(ItemStack stack, World world, EntityPlayer player) {
        if (this.altConfig == null) {
            return;
        }
        BulletConfiguration config = this.altConfig.reloadType == 0 ? ItemGunBase.getBeltCfg(player, stack, false) : BulletConfigSyncingUtil.pullConfig(this.altConfig.config.get(ItemGunBase.getMagType(stack)));
        int bullets = config.bulletsMin;
        for (int k = 0; k < this.altConfig.roundsPerCycle; ++k) {
            if (this.altConfig.reloadType != 0 && !this.hasAmmo(stack, player, true)) break;
            if (config.bulletsMax > config.bulletsMin) {
                bullets += world.field_73012_v.nextInt(config.bulletsMax - config.bulletsMin);
            }
            for (int i = 0; i < bullets; ++i) {
                this.spawnProjectile(world, player, stack, BulletConfigSyncingUtil.getKey(config));
            }
            this.useUpAmmo(player, stack, false);
            player.field_71069_bz.func_75142_b();
            ItemGunBase.setItemWear(stack, ItemGunBase.getItemWear(stack) + config.wear);
        }
        world.func_72956_a((Entity)player, this.altConfig.firingSound, this.mainConfig.firingVolume, this.altConfig.firingPitch);
        if (this.altConfig.ejector != null) {
            ItemGunBase.queueCasing((Entity)player, this.altConfig.ejector, config, stack);
        }
    }

    protected void spawnProjectile(World world, EntityPlayer player, ItemStack stack, int config) {
        EntityBulletBaseNT bullet = new EntityBulletBaseNT(world, config, (EntityLivingBase)player);
        world.func_72838_d((Entity)bullet);
        if (player instanceof EntityPlayerMP) {
            PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.CYCLE.ordinal()), (EntityPlayerMP)player);
        }
    }

    public void startAction(ItemStack stack, World world, EntityPlayer player, boolean main) {
        if (this.mainConfig.firingMode == 0 && main && this.tryShoot(stack, world, player, main)) {
            this.fire(stack, world, player);
            ItemGunBase.setDelay(stack, this.mainConfig.rateOfFire);
        }
        if (!main && this.altConfig != null && this.tryShoot(stack, world, player, main)) {
            this.altFire(stack, world, player);
            ItemGunBase.setDelay(stack, this.altConfig.rateOfFire);
        }
    }

    public void startActionClient(ItemStack stack, World world, EntityPlayer player, boolean main) {
    }

    public void endAction(ItemStack stack, World world, EntityPlayer player, boolean main) {
    }

    public void endActionClient(ItemStack stack, World world, EntityPlayer player, boolean main) {
    }

    protected void reload2(ItemStack stack, World world, EntityPlayer player) {
        if (ItemGunBase.getMag(stack) >= this.mainConfig.ammoCap) {
            ItemGunBase.setIsReloading(stack, false);
            return;
        }
        if (ItemGunBase.getReloadCycle(stack) <= 0) {
            BulletConfiguration prevCfg = BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(ItemGunBase.getMagType(stack)));
            if (ItemGunBase.getMag(stack) == 0) {
                this.resetAmmoType(stack, world, player);
            }
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(ItemGunBase.getMagType(stack)));
            RecipesCommon.ComparableStack ammo = (RecipesCommon.ComparableStack)cfg.ammo.copy();
            int countNeeded = this.mainConfig.reloadType == 1 ? this.mainConfig.ammoCap - ItemGunBase.getMag(stack) : 1;
            int availableStacks = InventoryUtil.countAStackMatches(player, (RecipesCommon.AStack)ammo, true);
            int availableFills = availableStacks * cfg.ammoCount;
            boolean hasLoaded = availableFills > 0;
            int toAdd = Math.min(availableFills * cfg.ammoCount, countNeeded);
            int toConsume = (int)Math.ceil((double)toAdd / (double)cfg.ammoCount);
            if (availableFills == 0) {
                ItemGunBase.setIsReloading(stack, false);
                return;
            }
            ammo.stacksize = toConsume;
            ItemGunBase.setMag(stack, ItemGunBase.getMag(stack) + toAdd);
            if (ItemGunBase.getMag(stack) >= this.mainConfig.ammoCap) {
                ItemGunBase.setIsReloading(stack, false);
            } else {
                ItemGunBase.resetReloadCycle(stack);
            }
            if (hasLoaded && this.mainConfig.reloadSoundEnd) {
                world.func_72956_a((Entity)player, this.mainConfig.reloadSound, 1.0f, 1.0f);
            }
            if (this.mainConfig.ejector != null && this.mainConfig.ejector.getAfterReload()) {
                ItemGunBase.queueCasing((Entity)player, this.mainConfig.ejector, prevCfg, stack);
            }
            InventoryUtil.tryConsumeAStack(player.field_71071_by.field_70462_a, 0, player.field_71071_by.field_70462_a.length, ammo);
        } else {
            ItemGunBase.setReloadCycle(stack, ItemGunBase.getReloadCycle(stack) - 1);
        }
        if (stack != player.func_70694_bm()) {
            ItemGunBase.setReloadCycle(stack, 0);
            ItemGunBase.setIsReloading(stack, false);
        }
    }

    public void startReloadAction(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af() && this.hasInfinity(stack, this.mainConfig)) {
            if (ItemGunBase.getMag(stack) == this.mainConfig.ammoCap) {
                ItemGunBase.setMag(stack, 0);
                this.resetAmmoType(stack, world, player);
                world.func_72956_a((Entity)player, "tile.piston.out", 1.0f, 1.0f);
            }
            return;
        }
        if (ItemGunBase.getMag(stack) == this.mainConfig.ammoCap) {
            return;
        }
        if (ItemGunBase.getIsReloading(stack)) {
            return;
        }
        if (!this.mainConfig.reloadSoundEnd) {
            world.func_72956_a((Entity)player, this.mainConfig.reloadSound, 1.0f, 1.0f);
        }
        if (!world.field_72995_K) {
            PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.RELOAD.ordinal()), (EntityPlayerMP)player);
        }
        ItemGunBase.setIsReloading(stack, true);
        ItemGunBase.resetReloadCycle(stack);
    }

    public boolean canReload(ItemStack stack, World world, EntityPlayer player) {
        if (ItemGunBase.getMag(stack) == this.mainConfig.ammoCap && this.hasInfinity(stack, this.mainConfig)) {
            return true;
        }
        if (ItemGunBase.getMag(stack) == 0) {
            for (int config : this.mainConfig.config) {
                if (!InventoryUtil.doesPlayerHaveAStack(player, BulletConfigSyncingUtil.pullConfig((int)config).ammo, false, false)) continue;
                return true;
            }
        } else {
            RecipesCommon.ComparableStack ammo = BulletConfigSyncingUtil.pullConfig((int)this.mainConfig.config.get((int)ItemGunBase.getMagType((ItemStack)stack)).intValue()).ammo;
            return InventoryUtil.doesPlayerHaveAStack(player, ammo, false, false);
        }
        return false;
    }

    protected void resetAmmoType(ItemStack stack, World world, EntityPlayer player) {
        for (int config : this.mainConfig.config) {
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
            if (!InventoryUtil.doesPlayerHaveAStack(player, cfg.ammo, false, false)) continue;
            ItemGunBase.setMagType(stack, this.mainConfig.config.indexOf(config));
            break;
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        RecipesCommon.ComparableStack ammo = BulletConfigSyncingUtil.pullConfig((int)this.mainConfig.config.get((int)ItemGunBase.getMagType((ItemStack)stack)).intValue()).ammo;
        list.add(I18nUtil.resolveKey("desc.item.gun.ammo", this.mainConfig.ammoCap > 0 ? I18nUtil.resolveKey("desc.item.gun.ammoMag", ItemGunBase.getMag(stack), this.mainConfig.ammoCap) : I18nUtil.resolveKey("desc.item.gun.ammoBelt", new Object[0])));
        try {
            RecipesCommon.ComparableStack ammo2;
            list.add(I18nUtil.resolveKey("desc.item.gun.ammoType", ammo.toStack().func_82833_r()));
            if (this.altConfig != null && this.altConfig.ammoCap == 0 && !ammo.isApplicable(ammo2 = BulletConfigSyncingUtil.pullConfig((int)this.altConfig.config.get((int)0).intValue()).ammo)) {
                list.add(I18nUtil.resolveKey("desc.item.gun.ammoTypeAlt", ammo2.toStack().func_82833_r()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            list.add("Error: " + e + " has occurred!");
        }
        this.addAdditionalInformation(stack, list);
    }

    protected void addAdditionalInformation(ItemStack stack, List<String> list) {
        BulletConfiguration bulletConfig = BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(ItemGunBase.getMagType(stack)));
        list.add(I18nUtil.resolveKey("desc.item.gun.damage", Float.valueOf(bulletConfig.dmgMin), Float.valueOf(bulletConfig.dmgMax)));
        if (bulletConfig.bulletsMax != 1) {
            list.add(I18nUtil.resolveKey("desc.item.gun.pellets", bulletConfig.bulletsMin, bulletConfig.bulletsMax));
        }
        int dura = Math.max(this.mainConfig.durability - ItemGunBase.getItemWear(stack), 0);
        list.add(I18nUtil.resolveKey("desc.item.durability", dura + " / " + this.mainConfig.durability));
        list.add("");
        String unloc = "gun.name." + this.mainConfig.name;
        String loc = I18nUtil.resolveKey(unloc, new Object[0]);
        list.add(I18nUtil.resolveKey("desc.item.gun.name", unloc.equals(loc) ? this.mainConfig.name : loc));
        list.add(I18nUtil.resolveKey("desc.item.gun.manufacturer", I18nUtil.resolveKey(this.mainConfig.manufacturer.getKey(), new Object[0])));
        if (!this.mainConfig.comment.isEmpty()) {
            list.add("");
            for (String s : this.mainConfig.comment) {
                list.add(EnumChatFormatting.ITALIC + s);
            }
        }
        if (GeneralConfig.enableExtendedLogging) {
            list.add("");
            list.add("Type: " + ItemGunBase.getMagType(stack));
            list.add("Is Reloading: " + ItemGunBase.getIsReloading(stack));
            list.add("Reload Cycle: " + ItemGunBase.getReloadCycle(stack));
            list.add("RoF Cooldown: " + ItemGunBase.getDelay(stack));
        }
    }

    public static RecipesCommon.ComparableStack getBeltType(EntityPlayer player, ItemStack stack, boolean main) {
        ItemGunBase gun = (ItemGunBase)stack.func_77973_b();
        GunConfiguration guncfg = main ? gun.mainConfig : (gun.altConfig != null ? gun.altConfig : gun.mainConfig);
        for (Integer config : guncfg.config) {
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
            if (!InventoryUtil.doesPlayerHaveAStack(player, cfg.ammo, false, true)) continue;
            return cfg.ammo;
        }
        return BulletConfigSyncingUtil.pullConfig((int)guncfg.config.get((int)0).intValue()).ammo;
    }

    public static BulletConfiguration getBeltCfg(EntityPlayer player, ItemStack stack, boolean main) {
        ItemGunBase gun = (ItemGunBase)stack.func_77973_b();
        GunConfiguration guncfg = main ? gun.mainConfig : (gun.altConfig != null ? gun.altConfig : gun.mainConfig);
        ItemGunBase.getBeltType(player, stack, main);
        for (int config : guncfg.config) {
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
            if (!InventoryUtil.doesPlayerHaveAStack(player, cfg.ammo, false, false)) continue;
            return cfg;
        }
        return BulletConfigSyncingUtil.pullConfig(guncfg.config.get(0));
    }

    public static int getBeltSize(EntityPlayer player, RecipesCommon.ComparableStack ammo) {
        int amount = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !ammo.matchesRecipe(stack, true)) continue;
            amount += stack.field_77994_a;
        }
        return amount;
    }

    public void useUpAmmo(EntityPlayer player, ItemStack stack, boolean main) {
        if (!main && this.altConfig == null) {
            return;
        }
        GunConfiguration config = this.mainConfig;
        if (!main) {
            config = this.altConfig;
        }
        if (this.hasInfinity(stack, config)) {
            return;
        }
        if (config.reloadType != 0) {
            ItemGunBase.setMag(stack, ItemGunBase.getMag(stack) - 1);
        } else {
            InventoryUtil.doesPlayerHaveAStack(player, ItemGunBase.getBeltType(player, stack, main), true, false);
        }
    }

    public boolean hasInfinity(ItemStack stack, GunConfiguration config) {
        return config.allowsInfinity && EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
    }

    public static void resetReloadCycle(ItemStack stack) {
        ItemGunBase.writeNBT(stack, "reload", ((ItemGunBase)stack.func_77973_b()).mainConfig.reloadDuration);
    }

    public static void setIsReloading(ItemStack stack, boolean b) {
        ItemGunBase.writeNBT(stack, "isReloading", b ? 1 : 0);
    }

    public static boolean getIsReloading(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "isReloading") == 1;
    }

    public static void setIsMouseDown(ItemStack stack, boolean b) {
        ItemGunBase.writeNBT(stack, "isMouseDown", b ? 1 : 0);
    }

    public static boolean getIsMouseDown(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "isMouseDown") == 1;
    }

    public static void setIsAltDown(ItemStack stack, boolean b) {
        ItemGunBase.writeNBT(stack, "isAltDown", b ? 1 : 0);
    }

    public static boolean getIsAltDown(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "isAltDown") == 1;
    }

    public static void setDelay(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "dlay", i);
    }

    public static int getDelay(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "dlay");
    }

    public static void setItemWear(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "wear", i);
    }

    public static int getItemWear(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "wear");
    }

    public static void setCycleAnim(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "cycle", i);
    }

    public static int getCycleAnim(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "cycle");
    }

    public static void setReloadCycle(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "reload", i);
    }

    public static int getReloadCycle(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "reload");
    }

    public static void setMag(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "magazine", i);
    }

    public static int getMag(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "magazine");
    }

    public static void setMagType(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "magazineType", i);
    }

    public static int getMagType(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "magazineType");
    }

    public static void setCasing(ItemStack stack, BulletConfiguration bullet) {
        ItemGunBase.writeNBT(stack, "casing", BulletConfigSyncingUtil.getKey(bullet));
    }

    public static BulletConfiguration getCasing(ItemStack stack) {
        return BulletConfigSyncingUtil.pullConfig(ItemGunBase.readNBT(stack, "casing"));
    }

    public static void setCasingTimer(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "casingTimer", i);
    }

    public static int getCasingTimer(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "casingTimer");
    }

    public static void writeNBT(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a(key, value);
    }

    public static int readNBT(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.field_77990_d.func_74762_e(key);
    }

    @Override
    public RenderScreenOverlay.Crosshair getCrosshair() {
        return this.mainConfig.crosshair;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Pre event, RenderGameOverlayEvent.ElementType type, EntityPlayer player, ItemStack stack) {
        ItemGunBase gun = (ItemGunBase)stack.func_77973_b();
        GunConfiguration gcfg = gun.mainConfig;
        if (type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int mag = ItemGunBase.getMagType(stack);
            if (gun.mainConfig.config.size() == 0) {
                return;
            }
            BulletConfiguration bcfg = BulletConfigSyncingUtil.pullConfig(gun.mainConfig.config.get(mag < gun.mainConfig.config.size() ? mag : 0));
            if (bcfg == null) {
                return;
            }
            RecipesCommon.ComparableStack ammo = bcfg.ammo;
            int count = ItemGunBase.getMag(stack);
            int max = gcfg.ammoCap;
            boolean showammo = gcfg.showAmmo;
            if (gcfg.reloadType == 0) {
                ammo = ItemGunBase.getBeltType(player, stack, true);
                count = ItemGunBase.getBeltSize(player, ammo);
                max = -1;
            }
            int dura = ItemGunBase.getItemWear(stack) * 50 / gcfg.durability;
            RenderScreenOverlay.renderAmmo(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, ammo.toStack(), count, max, dura, showammo);
            if (gun.altConfig != null && gun.altConfig.reloadType == 0) {
                RecipesCommon.ComparableStack oldAmmo = ammo;
                ammo = ItemGunBase.getBeltType(player, stack, false);
                if (!ammo.isApplicable(oldAmmo)) {
                    count = ItemGunBase.getBeltSize(player, ammo);
                    RenderScreenOverlay.renderAmmoAlt(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, ammo.toStack(), count);
                }
            }
        }
        if (type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && GeneralConfig.enableCrosshairs) {
            event.setCanceled(true);
            if (!gcfg.hasSights || !player.func_70093_af()) {
                RenderScreenOverlay.renderCustomCrosshairs(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, ((IHoldableWeapon)player.func_70694_bm().func_77973_b()).getCrosshair());
            } else {
                RenderScreenOverlay.renderCustomCrosshairs(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, RenderScreenOverlay.Crosshair.NONE);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BusAnimation getAnimation(ItemStack stack, HbmAnimations.AnimType type) {
        GunConfiguration config = ((ItemGunBase)stack.func_77973_b()).mainConfig;
        return config.animations.get((Object)type);
    }

    @Override
    public void onEquip(EntityPlayer player) {
        if (!this.mainConfig.equipSound.isEmpty() && !player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72956_a((Entity)player, this.mainConfig.equipSound, 1.0f, 1.0f);
        }
    }

    protected static void queueCasing(Entity entity, CasingEjector ejector, BulletConfiguration bullet, ItemStack stack) {
        if (ejector == null || bullet == null || bullet.spentCasing == null) {
            return;
        }
        if (ejector.getDelay() <= 0) {
            ItemGunBase.trySpawnCasing(entity, ejector, bullet, stack);
        } else {
            ItemGunBase.setCasing(stack, bullet);
            ItemGunBase.setCasingTimer(stack, ejector.getDelay());
        }
    }

    protected static void trySpawnCasing(Entity entity, CasingEjector ejector, BulletConfiguration bullet, ItemStack stack) {
        if (ejector == null) {
            return;
        }
        if (bullet == null) {
            return;
        }
        if (bullet.spentCasing == null) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "casing");
        data.func_74776_a("pitch", (float)Math.toRadians(entity.field_70125_A));
        data.func_74776_a("yaw", (float)Math.toRadians(entity.field_70177_z));
        data.func_74757_a("crouched", entity.func_70093_af());
        data.func_74778_a("name", bullet.spentCasing.getName());
        data.func_74768_a("ej", ejector.getId());
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 50.0));
    }
}

